
use pyrite::window_settings::WindowSettings;
use pyrite::window::Window;
use pyrite::sound::Sound;
use pyrite::input::Key;

pub fn main()
{
    // create a window
    let window = Window::from(WindowSettings {
        title: "Hello, Pyrite!".to_string(),
        size: [500, 500],
        fullscreen: false,
        resizable: false,
        ..Default::default()
    });

    // load in a sound (from sound: "test_sound.mp3")
    let mut test_sound = Sound::new(include_bytes!("test_sound.mp3"));

    // start the following gameloop:
    window.run(move |ws, g, i| {

        // if the button 'P' or the space bar is pressed start the sound
        if i.get_key(Key::P) || i.get_key(Key::Space) { test_sound.play(); }

        // fill the screen with white
        g.fill([255, 255, 255, 255]);

    });

}