
use pyrite::window_settings::WindowSettings;
use pyrite::window::Window;

pub fn main()
{
    // create a window
    let window = Window::from(WindowSettings {
        title: "Hello, Pyrite!".to_string(),
        size: [500, 500],
        fullscreen: false,
        resizable: false,
        ..Default::default()
    });

    // initialize color angle variable
    let mut color_angle = 0.0;

    // start the following gameloop:
    window.run(move |ws, g, i| {

        // increment color angle and calculate it's radian
        color_angle = if color_angle >= 360.0 { 0.0 } else { color_angle + 90.0 * g.dt as f32 };
        let color_radians = color_angle * std::f32::consts::PI / 180.0;

        // fill the screen with white
        g.fill([255, 255, 255, 255]);
        // draw a line from the center to the bottom right edge of the screen in a color according to the color angle
        g.draw_line([250.0, 250.0], [500.0, 500.0], 200.0, [(color_radians.sin() * 255.0) as u8, 125, 125, 125]);
        // draw an oval in the center of the screen in a color according to the color angle
        g.draw_oval([150.0, 150.0], [200.0, 200.0], [(color_radians.sin() * 255.0) as u8, 125, 125, 255]);

    });

}