use crate::sprite::{Sprite, SpriteFileFormat};


#[derive(Clone)]
pub struct WindowSettings
{
    pub title: String,
    pub size: [u32; 2],
    pub fullscreen: bool,
    pub resizable: bool,
    pub icon: (&'static [u8], SpriteFileFormat),
}

impl Default for WindowSettings {
    fn default() -> WindowSettings {
        WindowSettings {
            title: "Pyrite Application".to_string(),
            size: [848, 480],
            fullscreen: false,
            resizable: true,
            icon: (&[], SpriteFileFormat::PNG)
        }
    }
}