
use pyrite::window_settings::WindowSettings;
use pyrite::window::Window;
use pyrite::sprite::{Sprite, SpriteFileFormat};

pub fn main()
{
    // create a window
    let window = Window::from(WindowSettings {
        title: "Hello, Pyrite!".to_string(),
        size: [500, 500],
        fullscreen: false,
        resizable: false,
        ..Default::default()
    });

    // load in a sprite (from image: "test_image.png", with format: PNG)
    let test_sprite = Sprite::new(include_bytes!("test_image.png"), SpriteFileFormat::PNG);

    // start the following gameloop:
    window.run(move |ws, g, i| {

        // fill the screen with white
        g.fill([255, 255, 255, 255]);

        // draw everything from the sprite between 0px,0px and 600px,600px (the entire sprite)
        // at 50, 50 and stretch it to a size of 400, 400
        g.draw_sprite(&test_sprite, [50.0, 50.0], [400.0, 400.0], [0, 0], [600, 600])

    });

}