
pub fn rect_touching_rect(rect_1_pos: [f32; 2], rect_1_size: [f32; 2], rect_2_pos: [f32; 2], rect_2_size: [f32; 2]) -> bool
{
    !(rect_1_pos[0] + rect_1_size[0] < rect_2_pos[0])
    && !(rect_2_pos[0] + rect_2_size[0] < rect_1_pos[0])
    && !(rect_1_pos[1] + rect_1_size[1] < rect_2_pos[1])
    && !(rect_2_pos[1] + rect_2_size[1] < rect_1_pos[1])
}

pub fn point_inside_rect(point: [f32; 2], rect_pos: [f32; 2], rect_size: [f32; 2]) -> bool
{
    rect_pos[0] < point[0]
    && point[0] < rect_pos[0] + rect_size[0]
    && rect_pos[1] < point[1]
    && point[1] < rect_pos[1] + rect_size[1]
}

pub fn rect_inside_rect(rect_1_pos: [f32; 2], rect_1_size: [f32; 2], rect_2_pos: [f32; 2], rect_2_size: [f32; 2]) -> bool
{
    rect_2_pos[0] < rect_1_pos[0]
    && rect_1_pos[0] + rect_1_size[0] < rect_2_pos[0] + rect_2_size[0]
    && rect_2_pos[1] < rect_1_pos[1]
    && rect_1_pos[1] + rect_1_size[1] < rect_2_pos[1] + rect_2_size[1]
}