use rodio::{OutputStream, OutputStreamHandle, Source};
use std::io::{BufReader, Cursor};
use std::time::Duration;


pub struct Sound<>
{
    out: rodio::OutputStream,
    out_handle: rodio::OutputStreamHandle,
    sink: rodio::Sink,
    data: &'static [u8],
    volume: f32,
    looping: bool
}

impl Sound
{
    pub fn new(sound_data: &'static [u8]) -> Sound
    {
        let (_stream, handle): (OutputStream, OutputStreamHandle) = rodio::OutputStream::try_default().unwrap();
        Sound {
            out: _stream,
            sink: rodio::Sink::try_new(&handle).unwrap(),
            out_handle: handle,
            data: sound_data,
            volume: 1.0,
            looping: false
        }
    }

    pub fn play(&mut self)
    {
        self.sink = rodio::Sink::try_new(&self.out_handle).unwrap();
        self.sink.set_volume(self.volume);
        let source = rodio::Decoder::new(std::io::Cursor::new(self.data.as_ref())).unwrap();
        let source_looped = rodio::Decoder::new_looped(std::io::Cursor::new(self.data.as_ref())).unwrap();
        if !self.looping { self.sink.append(source); }
        else { self.sink.append(source_looped); }
    }

    pub fn set_volume(&mut self, volume: f32)
    {
        self.volume = volume;
    }

    pub fn set_looping(&mut self, looping: bool)
    {
        self.looping = looping;
    }

    pub fn stop(&mut self)
    {
        self.sink.stop();
    }

}