
use glutin_window::GlutinWindow;
use graphics::Context;
use opengl_graphics::{GlGraphics, OpenGL};
use piston::event_loop::{EventSettings, Events};
use piston::input::{RenderArgs, RenderEvent, UpdateArgs, UpdateEvent};
use piston::window::WindowSettings as PistonWindowSettings;
use graphics::*;
use graphics::types::{ColorComponent, Radius};

use crate::sprite::Sprite;

pub struct Graphics<'a>
{
    gl: &'a mut GlGraphics,
    c: Context,
    default_draw_state: DrawState,
    pub width: f32,
    pub height: f32,
    pub dt: f64
}

impl Graphics<'_>
{
    pub(crate) fn new(gl: &mut GlGraphics, c: Context, width: f32, height: f32, dt: f64) -> Graphics
    {
        Graphics {
            default_draw_state: DrawState { ..Default::default() },
            gl,
            c,
            width,
            height,
            dt
        }
    }


    pub fn fill(&mut self, color: [u8; 4])
    {
        clear(translate_color(color), self.gl);
    }

    pub fn draw_rect(&mut self, position: [f32; 2], size: [f32; 2], color: [u8; 4])
    {
        let rect_rect = rectangle::rectangle_by_corners(position[0].into(), position[1].into(), (position[0] + size[0]).into(), (position[1] + size[1]).into());
        rectangle(translate_color(color), rect_rect, self.c.transform, self.gl);
    }

    pub fn draw_oval(&mut self, position: [f32; 2], size: [f32; 2], color: [u8; 4])
    {
        let oval_rect = rectangle::rectangle_by_corners(position[0].into(), position[1].into(), (position[0] + size[0]).into(), (position[1] + size[1]).into());
        ellipse(translate_color(color), oval_rect, self.c.transform, self.gl);
    }

    pub fn draw_line(&mut self, position_start: [f32; 2], position_end: [f32; 2], width: f32, color: [u8; 4])
    {
        let line_rect = rectangle::rectangle_by_corners(position_start[0].into(), position_start[1].into(), (position_end[0] + position_start[0]).into(), (position_end[1] + position_start[1]).into());
        line(translate_color(color), width.into(), line_rect, self.c.transform, self.gl);
    }

    pub fn draw_sprite(&mut self, sprite: &Sprite, position: [f32; 2], size: [f32; 2], cutout_position: [u32; 2], cutout_size: [u32; 2])
    {
        let image = graphics::Image::new().rect(rectangle::rectangle_by_corners(position[0].into(), position[1].into(), (position[0] + size[0]).into(), (position[1] + size[1]).into()));
        image.draw(&sprite.texture, &self.default_draw_state, self.c.transform, self.gl);
    }

}


fn translate_color(color: [u8; 4]) -> [f32; 4]
{
    let mut translated_color: [f32; 4] = [0.0, 0.0, 0.0, 0.0];
    for color_iterator in 0..4 {
        translated_color[color_iterator] = color[color_iterator] as f32 / 255.0;
    }
    translated_color
}