use std::{env, fs, path};

mod entrypoint;
mod import;

/*
__Start__
1. Ingest entrypoint path
2. Create temp directory
3. Parse entrypoint file


__Process__
1. Read file contents of path provided
2. Find import statements
3. Process each import statement
    1. Expand import statement into "filepath-like"
    2. Check if "filepath-like" entry exists in HashSet
*/

#[derive(Debug)]
pub struct Parser {
    entrypoint: entrypoint::Entrypoint,
    // used to store copies of files used
    _temp_dir: path::PathBuf,
}

impl Parser {
    pub fn new(entrypoint_path: &str) -> Parser {
        let entrypoint = entrypoint::Entrypoint::new(entrypoint_path);
        let _temp_dir = env::temp_dir();

        Parser {
            entrypoint,
            _temp_dir,
        }
    }

    pub fn parse(&self) {
        let contents = fs::read_to_string(&self.entrypoint.file_path).unwrap();
        let imports = import::extract_imports(&contents);
        println!("{:?}", &imports);

        for import in &imports {
            let root = import::get_root_module(import);
            println!("{:?}", root)
        }
    }
}
