mod ebu_ttml_live;
mod format_context;
mod frame;
#[cfg(test)]
mod tests;

pub use ebu_ttml_live::PyEbuTtmlLive;
pub use format_context::FormatContext;
pub use frame::Frame;
use mcai_worker_sdk::prelude::GenericFilter;
use pyo3::prelude::*;
use pyo3::types::{PyDict, PyList, PyString};
use std::collections::HashMap;

#[pyclass]
#[derive(Clone, Debug)]
pub(crate) struct PyGenericFilter {
  pub name: String,
  pub label: Option<String>,
  pub parameters: HashMap<String, String>,
}

impl From<PyGenericFilter> for GenericFilter {
  fn from(filter: PyGenericFilter) -> Self {
    GenericFilter {
      name: filter.name.clone(),
      label: filter.label.clone(),
      parameters: filter.parameters,
    }
  }
}

impl From<&PyDict> for PyGenericFilter {
  fn from(py_dict: &PyDict) -> Self {
    let name = py_dict
      .get_item("name")
      .unwrap()
      .downcast::<PyString>()
      .unwrap()
      .extract::<String>()
      .unwrap();

    let label = py_dict.get_item("label").map(|label| {
      label
        .downcast::<PyString>()
        .unwrap()
        .extract::<String>()
        .unwrap()
    });

    let parameters = py_dict
      .get_item("parameters")
      .unwrap()
      .downcast::<PyDict>()
      .unwrap()
      .extract::<HashMap<String, String>>()
      .unwrap();

    PyGenericFilter {
      name,
      label,
      parameters,
    }
  }
}

pub(crate) fn extract_generic_filters(py_list: &PyList) -> Vec<GenericFilter> {
  py_list
    .iter()
    .map(|item| item.downcast::<PyDict>().unwrap())
    .map(PyGenericFilter::from)
    .map(GenericFilter::from)
    .collect()
}
