use rand::{Rng, thread_rng};

fn main() {
    let mut rng = thread_rng();
    const CHARSET: &[u8] = b"_+=-ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    loop {
        let password: String = (0..48)
            .map(|_| {
                CHARSET[rng.gen_range(0..CHARSET.len())] as char
            })
            .collect();
        if password.as_str().matches(|x| match x {
            '_' => true,
            '+' => true,
            '=' => true,
            '-' => true,
            _ => false
        }).collect::<Vec<&str>>().len() > 0 &&
        password.as_str().matches(char::is_numeric)
            .collect::<Vec<&str>>().len() > 0 &&
            password.as_str().matches(char::is_lowercase)
            .collect::<Vec<&str>>().len() > 0 &&
            password.as_str().matches(char::is_uppercase)
            .collect::<Vec<&str>>().len() > 0 {
                println!("{}", password);
                return
            }
    } 
}
