#!/bin/bash

BENCHES=(filter_map chain_take_filter_map dedup_filter flatten_dedup_filter_map dedup_flatten_filter_map transrangers_test6)
#VARIANTS=(for_each try_for_each iter_next pushgen)
VARIANTS=(pushgen)
if [ -z "$1" ]
then
    TOOLCHAIN=stable
else
    TOOLCHAIN=$1
fi

echo "Running benchmarks using ${TOOLCHAIN}" >/dev/stderr

printf '%s' "${TOOLCHAIN}"
for V in ${VARIANTS[@]}
do
    printf '%s' ";${V}"
done

printf '\n'

# If anything needs to be built we do so in parallell
cargo +${TOOLCHAIN} criterion --no-run


for B in ${BENCHES[@]}
do
    report_line=("\"${B}\"")
    for V in ${VARIANTS[@]}
    do
        estimate=`taskset 0x01 cargo +${TOOLCHAIN} criterion \
            --bench ${V}_${B} --message-format=json | jq '.typical.estimate/1000 | select( . != null )' | head -1`
        report_line+=(";${estimate}")
    done
    printf '%s' "${report_line[@]}"
    printf '\n'
done
