//! Memory operations.

use std::mem::ManuallyDrop;
use std::os::raw::c_char;

#[no_mangle]
pub extern fn allocate(size: usize) -> *mut c_char {
    let buffer: Vec<u8> = Vec::with_capacity(size);
    let mut buffer = ManuallyDrop::new(buffer);
    let pointer = buffer.as_mut_ptr();

    pointer as *mut c_char
}

#[no_mangle]
pub extern fn deallocate(pointer: *mut c_char, capacity: usize) {
    if pointer as i32 == 0 {
        return;
    }
    unsafe {
        let _ = Vec::from_raw_parts(pointer, 0, capacity);
    }
}