//! punch_api is the Punch WebAssembly public API.
//!
//! It consists of interfaces and a runtime glue allowing you to write wasm functions
//! able to run in the Punch FaaS.
//!
//! Learn more about the Punch : http://doc.punchplatform.com/

mod error;
pub use error::Error;

mod function;
pub use function::Function;

mod run;
pub use run::run;

mod mem;
// extern functions
#[allow(unused_imports)]
use mem::{allocate, deallocate};