// SPDX-License-Identifier: MIT
//! Tests and the like
//!
//! TODO: add some "real"-world usage exaples (e.g. deserializing into a struct)

extern crate test;

use test::{black_box, Bencher};

use crate::PunchCard;

/// using a punch card to store strings
#[test]
fn string_decode() {
	#[rustfmt::skip]
	assert_eq!(
		std::str::from_utf8(
			&(
				.. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
				..=..=..=..=..=.. .. ..=..=..=..=..=.. .. ..,
				.. ..=..=..=..=..=..=.. ..=..=..=..=..=.. ..,
				.. .. .. .. .. .. .. ..=.. ..=.. .. .. .. ..,
				..=.. ..=..=..=..=.. .. ..=.. ..=.. .. ..=..,
				.. ..=..=..=..=..=.. ..=..=.. ..=..=.. .. ..,
				.. .. .. .. ..=.. .. ..=..=..=.. .. .. ..=..,
				.. ..=.. .. ..=.. .. ..=..=.. .. .. ..=.. ..,
			)
				.punch_card()
		)
		.unwrap(),
		"Hello, World!\n"
	);
}

/// bool parsing can't ever length mismatch lol
#[test]
fn valid_u1_0() {
	#[rustfmt::skip]
	assert_eq!(
		(..=.. ..=..=.. .. ..=..=..=..,).punch_card(),
		[true, false, true, true, false, false, true, true, true]
	);
}

/// alternative bool parsing form, not a tuple
#[test]
fn valid_u1_1() {
	#[rustfmt::skip]
	assert_eq!(
		(..=.. ..=..=.. .. ..=..=..=..).punch_card(),
		[true, false, true, true, false, false, true, true, true]
	);
}

/// this is probably the most useful form of tape
#[test]
fn valid_u8_0() {
	#[rustfmt::skip]
	assert_eq!((
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
	).punch_card(), [
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
		0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f
	]);
}

/// zero-length cards are valid
#[test]
fn valid_u8_1() {
	#[rustfmt::skip]
	assert_eq!(
		(.., .., .., .., .., .., .., ..).punch_card(),
		[]
	);
}

/// line 0 was used in older versions as the source of truth, that's a bad idea
#[test]
#[should_panic]
fn invalid_u8_0() {
	#[rustfmt::skip]
	(
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
	).punch_card();
}

/// in said older versions the other lines would be padded with zeros
#[test]
#[should_panic]
fn invalid_u8_1() {
	#[rustfmt::skip]
	(
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
	).punch_card();
}

/// these also work to test slice inputting
#[test]
fn valid_u16() {
	#[rustfmt::skip]
	assert_eq!(
		(
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
		)
			.punch_card(),
		[0x0F0F, 0xF0F0, 0x3C3C, 0xC3C3],
	);
}

#[test]
fn valid_u32() {
	#[rustfmt::skip]
	assert_eq!(
		(
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
		)
			.punch_card(),
		[0x0F0F0F0F, 0xF0F0F0F0, 0x3C3C3C3C, 0xC3C3C3C3],
	);
}

#[test]
fn valid_u64() {
	#[rustfmt::skip]
	assert_eq!(
		(
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
			.. ..=.. ..=..,
			.. ..=.. ..=..,
			.. ..=..=.. ..,
			.. ..=..=.. ..,
			..=.. ..=.. ..,
			..=.. ..=.. ..,
			..=.. .. ..=..,
			..=.. .. ..=..,
		)
			.punch_card(),
		[0x0F0F0F0F0F0F0F0F, 0xF0F0F0F0F0F0F0F0, 0x3C3C3C3C3C3C3C3C, 0xC3C3C3C3C3C3C3C3],
	);
}

#[rustfmt::skip]
fn massive_card() -> [u128; 256] {
	(
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..=..,
		.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=.. .. .. .. .. .. .. .. ..=..=..=..=..=..=..=..=..,
		.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=.. .. .. .. ..=..=..=..=..,
		.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=.. .. ..=..=..,
		.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=.. ..=..,
	).punch_card()
}
/// i'm sorry
#[test]
fn massive_u128() {
	#[rustfmt::skip]
	assert_eq!(massive_card(), [
		0x00000000000000000000000000000000, 0x01010101010101010101010101010101, 0x02020202020202020202020202020202, 0x03030303030303030303030303030303, 0x04040404040404040404040404040404, 0x05050505050505050505050505050505, 0x06060606060606060606060606060606, 0x07070707070707070707070707070707, 0x08080808080808080808080808080808, 0x09090909090909090909090909090909, 0x0a0a0a0a0a0a0a0a0a0a0a0a0a0a0a0a, 0x0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b, 0x0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c, 0x0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d, 0x0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e, 0x0f0f0f0f0f0f0f0f0f0f0f0f0f0f0f0f,
		0x10101010101010101010101010101010, 0x11111111111111111111111111111111, 0x12121212121212121212121212121212, 0x13131313131313131313131313131313, 0x14141414141414141414141414141414, 0x15151515151515151515151515151515, 0x16161616161616161616161616161616, 0x17171717171717171717171717171717, 0x18181818181818181818181818181818, 0x19191919191919191919191919191919, 0x1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a, 0x1b1b1b1b1b1b1b1b1b1b1b1b1b1b1b1b, 0x1c1c1c1c1c1c1c1c1c1c1c1c1c1c1c1c, 0x1d1d1d1d1d1d1d1d1d1d1d1d1d1d1d1d, 0x1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e, 0x1f1f1f1f1f1f1f1f1f1f1f1f1f1f1f1f,
		0x20202020202020202020202020202020, 0x21212121212121212121212121212121, 0x22222222222222222222222222222222, 0x23232323232323232323232323232323, 0x24242424242424242424242424242424, 0x25252525252525252525252525252525, 0x26262626262626262626262626262626, 0x27272727272727272727272727272727, 0x28282828282828282828282828282828, 0x29292929292929292929292929292929, 0x2a2a2a2a2a2a2a2a2a2a2a2a2a2a2a2a, 0x2b2b2b2b2b2b2b2b2b2b2b2b2b2b2b2b, 0x2c2c2c2c2c2c2c2c2c2c2c2c2c2c2c2c, 0x2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d, 0x2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e, 0x2f2f2f2f2f2f2f2f2f2f2f2f2f2f2f2f,
		0x30303030303030303030303030303030, 0x31313131313131313131313131313131, 0x32323232323232323232323232323232, 0x33333333333333333333333333333333, 0x34343434343434343434343434343434, 0x35353535353535353535353535353535, 0x36363636363636363636363636363636, 0x37373737373737373737373737373737, 0x38383838383838383838383838383838, 0x39393939393939393939393939393939, 0x3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a, 0x3b3b3b3b3b3b3b3b3b3b3b3b3b3b3b3b, 0x3c3c3c3c3c3c3c3c3c3c3c3c3c3c3c3c, 0x3d3d3d3d3d3d3d3d3d3d3d3d3d3d3d3d, 0x3e3e3e3e3e3e3e3e3e3e3e3e3e3e3e3e, 0x3f3f3f3f3f3f3f3f3f3f3f3f3f3f3f3f,
		0x40404040404040404040404040404040, 0x41414141414141414141414141414141, 0x42424242424242424242424242424242, 0x43434343434343434343434343434343, 0x44444444444444444444444444444444, 0x45454545454545454545454545454545, 0x46464646464646464646464646464646, 0x47474747474747474747474747474747, 0x48484848484848484848484848484848, 0x49494949494949494949494949494949, 0x4a4a4a4a4a4a4a4a4a4a4a4a4a4a4a4a, 0x4b4b4b4b4b4b4b4b4b4b4b4b4b4b4b4b, 0x4c4c4c4c4c4c4c4c4c4c4c4c4c4c4c4c, 0x4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d, 0x4e4e4e4e4e4e4e4e4e4e4e4e4e4e4e4e, 0x4f4f4f4f4f4f4f4f4f4f4f4f4f4f4f4f,
		0x50505050505050505050505050505050, 0x51515151515151515151515151515151, 0x52525252525252525252525252525252, 0x53535353535353535353535353535353, 0x54545454545454545454545454545454, 0x55555555555555555555555555555555, 0x56565656565656565656565656565656, 0x57575757575757575757575757575757, 0x58585858585858585858585858585858, 0x59595959595959595959595959595959, 0x5a5a5a5a5a5a5a5a5a5a5a5a5a5a5a5a, 0x5b5b5b5b5b5b5b5b5b5b5b5b5b5b5b5b, 0x5c5c5c5c5c5c5c5c5c5c5c5c5c5c5c5c, 0x5d5d5d5d5d5d5d5d5d5d5d5d5d5d5d5d, 0x5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e, 0x5f5f5f5f5f5f5f5f5f5f5f5f5f5f5f5f,
		0x60606060606060606060606060606060, 0x61616161616161616161616161616161, 0x62626262626262626262626262626262, 0x63636363636363636363636363636363, 0x64646464646464646464646464646464, 0x65656565656565656565656565656565, 0x66666666666666666666666666666666, 0x67676767676767676767676767676767, 0x68686868686868686868686868686868, 0x69696969696969696969696969696969, 0x6a6a6a6a6a6a6a6a6a6a6a6a6a6a6a6a, 0x6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b, 0x6c6c6c6c6c6c6c6c6c6c6c6c6c6c6c6c, 0x6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d, 0x6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e, 0x6f6f6f6f6f6f6f6f6f6f6f6f6f6f6f6f,
		0x70707070707070707070707070707070, 0x71717171717171717171717171717171, 0x72727272727272727272727272727272, 0x73737373737373737373737373737373, 0x74747474747474747474747474747474, 0x75757575757575757575757575757575, 0x76767676767676767676767676767676, 0x77777777777777777777777777777777, 0x78787878787878787878787878787878, 0x79797979797979797979797979797979, 0x7a7a7a7a7a7a7a7a7a7a7a7a7a7a7a7a, 0x7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b, 0x7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c, 0x7d7d7d7d7d7d7d7d7d7d7d7d7d7d7d7d, 0x7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e, 0x7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f,
		0x80808080808080808080808080808080, 0x81818181818181818181818181818181, 0x82828282828282828282828282828282, 0x83838383838383838383838383838383, 0x84848484848484848484848484848484, 0x85858585858585858585858585858585, 0x86868686868686868686868686868686, 0x87878787878787878787878787878787, 0x88888888888888888888888888888888, 0x89898989898989898989898989898989, 0x8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a, 0x8b8b8b8b8b8b8b8b8b8b8b8b8b8b8b8b, 0x8c8c8c8c8c8c8c8c8c8c8c8c8c8c8c8c, 0x8d8d8d8d8d8d8d8d8d8d8d8d8d8d8d8d, 0x8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e, 0x8f8f8f8f8f8f8f8f8f8f8f8f8f8f8f8f,
		0x90909090909090909090909090909090, 0x91919191919191919191919191919191, 0x92929292929292929292929292929292, 0x93939393939393939393939393939393, 0x94949494949494949494949494949494, 0x95959595959595959595959595959595, 0x96969696969696969696969696969696, 0x97979797979797979797979797979797, 0x98989898989898989898989898989898, 0x99999999999999999999999999999999, 0x9a9a9a9a9a9a9a9a9a9a9a9a9a9a9a9a, 0x9b9b9b9b9b9b9b9b9b9b9b9b9b9b9b9b, 0x9c9c9c9c9c9c9c9c9c9c9c9c9c9c9c9c, 0x9d9d9d9d9d9d9d9d9d9d9d9d9d9d9d9d, 0x9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e, 0x9f9f9f9f9f9f9f9f9f9f9f9f9f9f9f9f,
		0xa0a0a0a0a0a0a0a0a0a0a0a0a0a0a0a0, 0xa1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1, 0xa2a2a2a2a2a2a2a2a2a2a2a2a2a2a2a2, 0xa3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3, 0xa4a4a4a4a4a4a4a4a4a4a4a4a4a4a4a4, 0xa5a5a5a5a5a5a5a5a5a5a5a5a5a5a5a5, 0xa6a6a6a6a6a6a6a6a6a6a6a6a6a6a6a6, 0xa7a7a7a7a7a7a7a7a7a7a7a7a7a7a7a7, 0xa8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8, 0xa9a9a9a9a9a9a9a9a9a9a9a9a9a9a9a9, 0xaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa, 0xabababababababababababababababab, 0xacacacacacacacacacacacacacacacac, 0xadadadadadadadadadadadadadadadad, 0xaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeae, 0xafafafafafafafafafafafafafafafaf,
		0xb0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0, 0xb1b1b1b1b1b1b1b1b1b1b1b1b1b1b1b1, 0xb2b2b2b2b2b2b2b2b2b2b2b2b2b2b2b2, 0xb3b3b3b3b3b3b3b3b3b3b3b3b3b3b3b3, 0xb4b4b4b4b4b4b4b4b4b4b4b4b4b4b4b4, 0xb5b5b5b5b5b5b5b5b5b5b5b5b5b5b5b5, 0xb6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6, 0xb7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7, 0xb8b8b8b8b8b8b8b8b8b8b8b8b8b8b8b8, 0xb9b9b9b9b9b9b9b9b9b9b9b9b9b9b9b9, 0xbabababababababababababababababa, 0xbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb, 0xbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbc, 0xbdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbd, 0xbebebebebebebebebebebebebebebebe, 0xbfbfbfbfbfbfbfbfbfbfbfbfbfbfbfbf,
		0xc0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0, 0xc1c1c1c1c1c1c1c1c1c1c1c1c1c1c1c1, 0xc2c2c2c2c2c2c2c2c2c2c2c2c2c2c2c2, 0xc3c3c3c3c3c3c3c3c3c3c3c3c3c3c3c3, 0xc4c4c4c4c4c4c4c4c4c4c4c4c4c4c4c4, 0xc5c5c5c5c5c5c5c5c5c5c5c5c5c5c5c5, 0xc6c6c6c6c6c6c6c6c6c6c6c6c6c6c6c6, 0xc7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7, 0xc8c8c8c8c8c8c8c8c8c8c8c8c8c8c8c8, 0xc9c9c9c9c9c9c9c9c9c9c9c9c9c9c9c9, 0xcacacacacacacacacacacacacacacaca, 0xcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcb, 0xcccccccccccccccccccccccccccccccc, 0xcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcd, 0xcececececececececececececececece, 0xcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcf,
		0xd0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0, 0xd1d1d1d1d1d1d1d1d1d1d1d1d1d1d1d1, 0xd2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2, 0xd3d3d3d3d3d3d3d3d3d3d3d3d3d3d3d3, 0xd4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4, 0xd5d5d5d5d5d5d5d5d5d5d5d5d5d5d5d5, 0xd6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6, 0xd7d7d7d7d7d7d7d7d7d7d7d7d7d7d7d7, 0xd8d8d8d8d8d8d8d8d8d8d8d8d8d8d8d8, 0xd9d9d9d9d9d9d9d9d9d9d9d9d9d9d9d9, 0xdadadadadadadadadadadadadadadada, 0xdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbdb, 0xdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdc, 0xdddddddddddddddddddddddddddddddd, 0xdededededededededededededededede, 0xdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdf,
		0xe0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0, 0xe1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1, 0xe2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2, 0xe3e3e3e3e3e3e3e3e3e3e3e3e3e3e3e3, 0xe4e4e4e4e4e4e4e4e4e4e4e4e4e4e4e4, 0xe5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5, 0xe6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6, 0xe7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7, 0xe8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8, 0xe9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9, 0xeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaea, 0xebebebebebebebebebebebebebebebeb, 0xecececececececececececececececec, 0xedededededededededededededededed, 0xeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee, 0xefefefefefefefefefefefefefefefef,
		0xf0f0f0f0f0f0f0f0f0f0f0f0f0f0f0f0, 0xf1f1f1f1f1f1f1f1f1f1f1f1f1f1f1f1, 0xf2f2f2f2f2f2f2f2f2f2f2f2f2f2f2f2, 0xf3f3f3f3f3f3f3f3f3f3f3f3f3f3f3f3, 0xf4f4f4f4f4f4f4f4f4f4f4f4f4f4f4f4, 0xf5f5f5f5f5f5f5f5f5f5f5f5f5f5f5f5, 0xf6f6f6f6f6f6f6f6f6f6f6f6f6f6f6f6, 0xf7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7, 0xf8f8f8f8f8f8f8f8f8f8f8f8f8f8f8f8, 0xf9f9f9f9f9f9f9f9f9f9f9f9f9f9f9f9, 0xfafafafafafafafafafafafafafafafa, 0xfbfbfbfbfbfbfbfbfbfbfbfbfbfbfbfb, 0xfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfc, 0xfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfd, 0xfefefefefefefefefefefefefefefefe, 0xffffffffffffffffffffffffffffffff,
	]);
}

#[bench]
fn massive_bench(b: &mut Bencher) {
	b.iter(|| {
		for _ in 1..100 {
			black_box(massive_card());
		}
	})
}
