A Rust attribute macro used to mark struct/union and its fields as public

### How to use

add the dependency to your Cargo.toml

```toml
[dependencies]
public = { git = "https://github.com/yuchunzhou/public", branch = "main" }
```

then, mark the struct with `public` attribute macro

```rust
#[macro_use]
extern crate public;

#[public]
#[derive(Debug, Default)]
struct Foo {
    a: i8,
    b: char,
    c: String,
}
```

the struct `Foo` and its fields will be visible within the current crate(default scope), of course, you can pass other scope arguments to the `public` attribute macro, like the usage of `pub` keyword in Rust.
