/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nvPTXCompiler {
    _unused: [u8; 0],
}
#[doc = " \\ingroup handle"]
#[doc = " \\brief   nvPTXCompilerHandle represents a handle to the PTX Compiler."]
#[doc = ""]
#[doc = " To compile a PTX program string, an instance of nvPTXCompiler"]
#[doc = " must be created and the handle to it must be obtained using the"]
#[doc = " API nvPTXCompilerCreate(). Then the compilation can be done"]
#[doc = " using the API nvPTXCompilerCompile()."]
#[doc = ""]
pub type nvPTXCompilerHandle = *mut nvPTXCompiler;
pub const nvPTXCompileResult_NVPTXCOMPILE_SUCCESS: nvPTXCompileResult = 0;
pub const nvPTXCompileResult_NVPTXCOMPILE_ERROR_INVALID_COMPILER_HANDLE: nvPTXCompileResult = 1;
pub const nvPTXCompileResult_NVPTXCOMPILE_ERROR_INVALID_INPUT: nvPTXCompileResult = 2;
pub const nvPTXCompileResult_NVPTXCOMPILE_ERROR_COMPILATION_FAILURE: nvPTXCompileResult = 3;
pub const nvPTXCompileResult_NVPTXCOMPILE_ERROR_INTERNAL: nvPTXCompileResult = 4;
pub const nvPTXCompileResult_NVPTXCOMPILE_ERROR_OUT_OF_MEMORY: nvPTXCompileResult = 5;
pub const nvPTXCompileResult_NVPTXCOMPILE_ERROR_COMPILER_INVOCATION_INCOMPLETE: nvPTXCompileResult =
    6;
pub const nvPTXCompileResult_NVPTXCOMPILE_ERROR_UNSUPPORTED_PTX_VERSION: nvPTXCompileResult = 7;
#[doc = " \\ingroup error"]
#[doc = ""]
#[doc = " \\brief     The nvPTXCompiler APIs return the nvPTXCompileResult codes to indicate the call result"]
pub type nvPTXCompileResult = ::std::os::raw::c_int;
extern "C" {
    #[doc = " \\ingroup versioning"]
    #[doc = ""]
    #[doc = " \\brief            Queries the current \\p major and \\p minor version of"]
    #[doc = "                   PTX Compiler APIs being used"]
    #[doc = ""]
    #[doc = " \\param            [out] major   Major version of the PTX Compiler APIs"]
    #[doc = " \\param            [out] minor   Minor version of the PTX Compiler APIs"]
    #[doc = " \\note                           The version of PTX Compiler APIs follows the CUDA Toolkit versioning."]
    #[doc = "                                 The PTX ISA version supported by a PTX Compiler API version is listed"]
    #[doc = "                                 <a href=\"https://docs.nvidia.com/cuda/parallel-thread-execution/#release-notes\">here</a>."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    pub fn nvPTXCompilerGetVersion(
        major: *mut ::std::os::raw::c_uint,
        minor: *mut ::std::os::raw::c_uint,
    ) -> nvPTXCompileResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = ""]
    #[doc = " \\brief            Obtains the handle to an instance of the PTX compiler"]
    #[doc = "                   initialized with the given PTX program \\p ptxCode"]
    #[doc = ""]
    #[doc = " \\param            [out] compiler  Returns a handle to PTX compiler initialized"]
    #[doc = "                                   with the PTX program \\p ptxCode"]
    #[doc = " \\param            [in] ptxCodeLen Size of the PTX program \\p ptxCode passed as string"]
    #[doc = " \\param            [in] ptxCode    The PTX program which is to be compiled passed as string."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_OUT_OF_MEMORY \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    pub fn nvPTXCompilerCreate(
        compiler: *mut nvPTXCompilerHandle,
        ptxCodeLen: size_t,
        ptxCode: *const ::std::os::raw::c_char,
    ) -> nvPTXCompileResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = ""]
    #[doc = " \\brief            Destroys and cleans the already created PTX compiler"]
    #[doc = ""]
    #[doc = " \\param            [in] compiler  A handle to the PTX compiler which is to be destroyed"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_OUT_OF_MEMORY \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INVALID_PROGRAM_HANDLE \\endlink"]
    #[doc = ""]
    pub fn nvPTXCompilerDestroy(compiler: *mut nvPTXCompilerHandle) -> nvPTXCompileResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = ""]
    #[doc = " \\brief          Compile a PTX program with the given compiler options"]
    #[doc = ""]
    #[doc = " \\param            [in,out] compiler      A handle to PTX compiler initialized with the"]
    #[doc = "                                          PTX program which is to be compiled."]
    #[doc = "                                          The compiled program can be accessed using the handle"]
    #[doc = " \\param            [in] numCompileOptions Length of the array \\p compileOptions"]
    #[doc = " \\param            [in] compileOptions   Compiler options with which compilation should be done."]
    #[doc = "                                         The compiler options string is a null terminated character array."]
    #[doc = "                                         A valid list of compiler options is at"]
    #[doc = "                                         <a href=\"http://docs.nvidia.com/cuda/ptx-compiler-api/index.html#compile-options\">link</a>."]
    #[doc = " \\note                                   --gpu-name (-arch) is a mandatory option."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_OUT_OF_MEMORY \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INVALID_PROGRAM_HANDLE \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_COMPILATION_FAILURE  \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_UNSUPPORTED_PTX_VERSION  \\endlink"]
    #[doc = ""]
    pub fn nvPTXCompilerCompile(
        compiler: nvPTXCompilerHandle,
        numCompileOptions: ::std::os::raw::c_int,
        compileOptions: *const *const ::std::os::raw::c_char,
    ) -> nvPTXCompileResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = ""]
    #[doc = " \\brief            Obtains the size of the image of the compiled program"]
    #[doc = ""]
    #[doc = " \\param            [in] compiler          A handle to PTX compiler on which nvPTXCompilerCompile() has been performed."]
    #[doc = " \\param            [out] binaryImageSize  The size of the image of the compiled program"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INVALID_PROGRAM_HANDLE \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_COMPILER_INVOCATION_INCOMPLETE \\endlink"]
    #[doc = ""]
    #[doc = " \\note             nvPTXCompilerCompile() API should be invoked for the handle before calling this API."]
    #[doc = "                   Otherwise, NVPTXCOMPILE_ERROR_COMPILER_INVOCATION_INCOMPLETE is returned."]
    pub fn nvPTXCompilerGetCompiledProgramSize(
        compiler: nvPTXCompilerHandle,
        binaryImageSize: *mut size_t,
    ) -> nvPTXCompileResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = ""]
    #[doc = " \\brief            Obtains the image of the compiled program"]
    #[doc = ""]
    #[doc = " \\param            [in] compiler          A handle to PTX compiler on which nvPTXCompilerCompile() has been performed."]
    #[doc = " \\param            [out] binaryImage      The image of the compiled program."]
    #[doc = "                                         Client should allocate memory for \\p binaryImage"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INVALID_PROGRAM_HANDLE \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_COMPILER_INVOCATION_INCOMPLETE \\endlink"]
    #[doc = ""]
    #[doc = " \\note             nvPTXCompilerCompile() API should be invoked for the handle before calling this API."]
    #[doc = "                   Otherwise, NVPTXCOMPILE_ERROR_COMPILER_INVOCATION_INCOMPLETE is returned."]
    #[doc = ""]
    pub fn nvPTXCompilerGetCompiledProgram(
        compiler: nvPTXCompilerHandle,
        binaryImage: *mut ::std::os::raw::c_void,
    ) -> nvPTXCompileResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = ""]
    #[doc = " \\brief            Query the size of the error message that was seen previously for the handle"]
    #[doc = ""]
    #[doc = " \\param            [in] compiler          A handle to PTX compiler on which nvPTXCompilerCompile() has been performed."]
    #[doc = " \\param            [out] errorLogSize     The size of the error log in bytes which was produced"]
    #[doc = "                                          in previous call to nvPTXCompilerCompiler()."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INVALID_PROGRAM_HANDLE \\endlink"]
    #[doc = ""]
    pub fn nvPTXCompilerGetErrorLogSize(
        compiler: nvPTXCompilerHandle,
        errorLogSize: *mut size_t,
    ) -> nvPTXCompileResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = ""]
    #[doc = " \\brief            Query the error message that was seen previously for the handle"]
    #[doc = ""]
    #[doc = " \\param            [in] compiler         A handle to PTX compiler on which nvPTXCompilerCompile() has been performed."]
    #[doc = " \\param            [out] errorLog        The error log which was produced in previous call to nvPTXCompilerCompiler()."]
    #[doc = "                                         Clients should allocate memory for \\p errorLog"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INVALID_PROGRAM_HANDLE \\endlink"]
    #[doc = ""]
    pub fn nvPTXCompilerGetErrorLog(
        compiler: nvPTXCompilerHandle,
        errorLog: *mut ::std::os::raw::c_char,
    ) -> nvPTXCompileResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = ""]
    #[doc = " \\brief            Query the size of the information message that was seen previously for the handle"]
    #[doc = ""]
    #[doc = " \\param            [in] compiler        A handle to PTX compiler on which nvPTXCompilerCompile() has been performed."]
    #[doc = " \\param            [out] infoLogSize    The size of the information log in bytes which was produced"]
    #[doc = "                                         in previous call to nvPTXCompilerCompiler()."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INVALID_PROGRAM_HANDLE \\endlink"]
    #[doc = ""]
    pub fn nvPTXCompilerGetInfoLogSize(
        compiler: nvPTXCompilerHandle,
        infoLogSize: *mut size_t,
    ) -> nvPTXCompileResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = ""]
    #[doc = " \\brief           Query the information message that was seen previously for the handle"]
    #[doc = ""]
    #[doc = " \\param            [in] compiler        A handle to PTX compiler on which nvPTXCompilerCompile() has been performed."]
    #[doc = " \\param            [out] infoLog        The information log which was produced in previous call to nvPTXCompilerCompiler()."]
    #[doc = "                                        Clients should allocate memory for \\p infoLog"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_SUCCESS \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INTERNAL \\endlink"]
    #[doc = "   - \\link #nvPTXCompileResult NVPTXCOMPILE_ERROR_INVALID_PROGRAM_HANDLE \\endlink"]
    #[doc = ""]
    pub fn nvPTXCompilerGetInfoLog(
        compiler: nvPTXCompilerHandle,
        infoLog: *mut ::std::os::raw::c_char,
    ) -> nvPTXCompileResult;
}
pub type size_t = ::std::os::raw::c_ulonglong;
