use thiserror::Error;

#[derive (Debug, Error)]
pub enum FileServerError {
	#[error ("I/O error")]
	Io (#[from] std::io::Error),
	
	#[error ("Request path is not UTF-8")]
	PathNotUtf8 (std::str::Utf8Error),
	
	#[error ("Can't get file metadata")]
	CantGetFileMetadata (std::io::Error),
	
	#[error ("No file name requested")]
	NoFileNameRequested,
	
	#[error ("File path is not UTF-8")]
	FilePathNotUtf8,
	
	//#[error ("Markdown error")]
	//Markdown (#[from] super::markdown::Error),
	
	#[error ("Invalid URI")]
	InvalidUri (#[from] http::uri::InvalidUri),
	
	#[error ("Heim process error")]
	HeimProcess,
	
	#[error(transparent)]
	Other (#[from] anyhow::Error),
}

impl From <heim::process::ProcessError> for FileServerError {
	fn from (_: heim::process::ProcessError) -> Self {
		FileServerError::HeimProcess
	}
}
