#[tokio::main]
async fn main () -> anyhow::Result <()> {
	use std::{
		fs,
		sync::Arc,
	};
	
	use ptth_core::{
		graceful_shutdown,
		http_serde::{
			RequestParts,
			Response,
		},
	};
	use ptth_server::{
		Builder,
		State,
	};
	
	let api_key = fs::read_to_string ("config/ptth_server_custom_key.txt")?
	.trim_end ()
	.to_string ();
	
	let state = Builder::new (
		"ptth_server_custom".to_string (), 
		"http://127.0.0.1:4000/7ZSFUKGV".to_string ()
	)
	.api_key (api_key)
	.build ()?;
	
	let state = Arc::new (state);
	
	let mut spawn_handler = || {
		|req: RequestParts| async move {
			let mut resp = Response::default ();
			resp.body_bytes (req.uri.as_bytes ().to_vec ());
			
			Ok (resp)
		}
	};
	
	State::run (
		&state,
		graceful_shutdown::init (),
		&mut spawn_handler,
	).await?;
	
	Ok (())
}
