#[repr(transparent)] 
pub struct Exception(u32);

impl Exception {
    pub fn into_result(self) -> Result<(), Error> {
        match self.0 {
            0 => {
                Ok(())
            }

            std::u32::MAX => {
                let s = unsafe { std::ffi::CStr::from_ptr(ptex_get_exception_string()).to_string_lossy().to_string()};
                panic!("Unhandled exception: {}", s)
            }
            _ => {
                let s = unsafe { std::ffi::CStr::from_ptr(ptex_get_exception_string()).to_string_lossy().to_string()};
                panic!("Unexpected exception value: {} - {}", self.0, s)
            }
        }
    }
}

#[derive(Debug, PartialEq)]
pub enum Error {
}

impl std::error::Error for Error {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        None
    }
}

use std::fmt;
impl fmt::Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {

        Ok(())
    }
}
extern {
    pub fn ptex_get_exception_string() -> *const std::os::raw::c_char;
}

pub use c_ptex_half::Ptex__v2_4__PtexHalf_t as Ptex_PtexHalf_t;

pub use c_ptex_half::Ptex__v2_4__PtexHalf_sizeof as Ptex_PtexHalf_sizeof;
pub use c_ptex_half::Ptex__v2_4__PtexHalf_alignof as Ptex_PtexHalf_alignof;
pub use c_ptex_half::Ptex__v2_4__PtexHalf_default as Ptex_PtexHalf_default;
pub use c_ptex_half::Ptex__v2_4__PtexHalf_from_f32 as Ptex_PtexHalf_from_f32;
pub use c_ptex_half::Ptex__v2_4__PtexHalf_from_f64 as Ptex_PtexHalf_from_f64;
pub use c_ptex_half::Ptex__v2_4__PtexHalf_as_f32 as Ptex_PtexHalf_as_f32;
pub use c_ptex_half::Ptex__v2_4__PtexHalf_toFloat as Ptex_PtexHalf_toFloat;
pub use c_ptex_half::Ptex__v2_4__PtexHalf_fromFloat as Ptex_PtexHalf_fromFloat;
pub use std_string::std__string_t as std_string_t;

pub use std_string::std__string_sizeof as std_string_sizeof;
pub use std_string::std__string_alignof as std_string_alignof;
pub use std_string::std__string_ctor as std_string_ctor;
pub use std_string::std__string_assign as std_string_assign;
pub use std_string::std__string_c_str as std_string_c_str;
pub use c_ptexture::Ptex__v2_4__Res_t as Ptex_Res_t;
pub use c_ptexture::Ptex__v2_4__FaceInfo_t as Ptex_FaceInfo_t;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_t as Ptex_PtexMetaData_t;
pub use c_ptexture::Ptex__v2_4__PtexFaceData_t as Ptex_PtexFaceData_t;
pub use c_ptexture::Ptex__v2_4__PtexTexture_t as Ptex_PtexTexture_t;
pub use c_ptexture::Ptex__v2_4__PtexTexture__Info_t as Ptex_PtexTexture_Info_t;
pub use c_ptexture::Ptex__v2_4__PtexInputHandler_t as Ptex_PtexInputHandler_t;
pub use c_ptexture::Ptex__v2_4__PtexErrorHandler_t as Ptex_PtexErrorHandler_t;
pub use c_ptexture::Ptex__v2_4__PtexCache_t as Ptex_PtexCache_t;
pub use c_ptexture::Ptex__v2_4__PtexCache__Stats_t as Ptex_PtexCache_Stats_t;
pub use c_ptexture::Ptex__v2_4__PtexWriter_t as Ptex_PtexWriter_t;
pub use c_ptexture::Ptex__v2_4__PtexFilter_t as Ptex_PtexFilter_t;
pub use c_ptexture::Ptex__v2_4__PtexFilter__Options_t as Ptex_PtexFilter_Options_t;

pub use c_ptexture::Ptex__v2_4__PtexFilter__FilterType_e as Ptex_PtexFilter_FilterType;
pub use c_ptexture::Ptex_PtexFilter_FilterType_f_point;
pub use c_ptexture::Ptex_PtexFilter_FilterType_f_bilinear;
pub use c_ptexture::Ptex_PtexFilter_FilterType_f_box;
pub use c_ptexture::Ptex_PtexFilter_FilterType_f_gaussian;
pub use c_ptexture::Ptex_PtexFilter_FilterType_f_bicubic;
pub use c_ptexture::Ptex_PtexFilter_FilterType_f_bspline;
pub use c_ptexture::Ptex_PtexFilter_FilterType_f_catmullrom;
pub use c_ptexture::Ptex_PtexFilter_FilterType_f_mitchell;
pub use c_ptexture::Ptex__v2_4__MeshType_e as Ptex_MeshType;
pub use c_ptexture::Ptex_MeshType_mt_triangle;
pub use c_ptexture::Ptex_MeshType_mt_quad;
pub use c_ptexture::MeshType;
pub use c_ptexture::Ptex__v2_4__DataType_e as Ptex_DataType;
pub use c_ptexture::Ptex_DataType_dt_uint8;
pub use c_ptexture::Ptex_DataType_dt_uint16;
pub use c_ptexture::Ptex_DataType_dt_half;
pub use c_ptexture::Ptex_DataType_dt_float;
pub use c_ptexture::DataType;
pub use c_ptexture::Ptex__v2_4__EdgeFilterMode_e as Ptex_EdgeFilterMode;
pub use c_ptexture::Ptex_EdgeFilterMode_efm_none;
pub use c_ptexture::Ptex_EdgeFilterMode_efm_tanvec;
pub use c_ptexture::EdgeFilterMode;
pub use c_ptexture::Ptex__v2_4__BorderMode_e as Ptex_BorderMode;
pub use c_ptexture::Ptex_BorderMode_m_clamp;
pub use c_ptexture::Ptex_BorderMode_m_black;
pub use c_ptexture::Ptex_BorderMode_m_periodic;
pub use c_ptexture::BorderMode;
pub use c_ptexture::Ptex__v2_4__EdgeId_e as Ptex_EdgeId;
pub use c_ptexture::Ptex_EdgeId_e_bottom;
pub use c_ptexture::Ptex_EdgeId_e_right;
pub use c_ptexture::Ptex_EdgeId_e_top;
pub use c_ptexture::Ptex_EdgeId_e_left;
pub use c_ptexture::EdgeId;
pub use c_ptexture::Ptex__v2_4__MetaDataType_e as Ptex_MetaDataType;
pub use c_ptexture::Ptex_MetaDataType_mdt_string;
pub use c_ptexture::Ptex_MetaDataType_mdt_int8;
pub use c_ptexture::Ptex_MetaDataType_mdt_int16;
pub use c_ptexture::Ptex_MetaDataType_mdt_int32;
pub use c_ptexture::Ptex_MetaDataType_mdt_float;
pub use c_ptexture::Ptex_MetaDataType_mdt_double;
pub use c_ptexture::MetaDataType;
pub use c_ptexture::Ptex__v2_4__Res_ctor as Ptex_Res_ctor;
pub use c_ptexture::Ptex__v2_4__Res_from_uv_log2 as Ptex_Res_from_uv_log2;
pub use c_ptexture::Ptex__v2_4__Res_from_value as Ptex_Res_from_value;
pub use c_ptexture::Ptex__v2_4__Res_u as Ptex_Res_u;
pub use c_ptexture::Ptex__v2_4__Res_v as Ptex_Res_v;
pub use c_ptexture::Ptex__v2_4__Res_val as Ptex_Res_val;
pub use c_ptexture::Ptex__v2_4__Res_size as Ptex_Res_size;
pub use c_ptexture::Ptex__v2_4__Res__eq as Ptex_Res__eq;
pub use c_ptexture::Ptex__v2_4__Res__ne as Ptex_Res__ne;
pub use c_ptexture::Ptex__v2_4__Res__op_ge as Ptex_Res__op_ge;
pub use c_ptexture::Ptex__v2_4__Res_swappeduv as Ptex_Res_swappeduv;
pub use c_ptexture::Ptex__v2_4__Res_swapuv as Ptex_Res_swapuv;
pub use c_ptexture::Ptex__v2_4__Res_clamp as Ptex_Res_clamp;
pub use c_ptexture::Ptex__v2_4__Res_ntilesu as Ptex_Res_ntilesu;
pub use c_ptexture::Ptex__v2_4__Res_ntilesv as Ptex_Res_ntilesv;
pub use c_ptexture::Ptex__v2_4__Res_ntiles as Ptex_Res_ntiles;
pub use c_ptexture::Ptex__v2_4__Res_copy as Ptex_Res_copy;
pub use c_ptexture::Ptex__v2_4__Res_dtor as Ptex_Res_dtor;
pub use c_ptexture::Ptex__v2_4__Res_assign as Ptex_Res_assign;
pub use c_ptexture::Ptex__v2_4__FaceInfo_sizeof as Ptex_FaceInfo_sizeof;
pub use c_ptexture::Ptex__v2_4__FaceInfo_alignof as Ptex_FaceInfo_alignof;
pub use c_ptexture::Ptex__v2_4__FaceInfo_default as Ptex_FaceInfo_default;
pub use c_ptexture::Ptex__v2_4__FaceInfo_from_res as Ptex_FaceInfo_from_res;
pub use c_ptexture::Ptex__v2_4__FaceInfo_from_res_and_adjacency as Ptex_FaceInfo_from_res_and_adjacency;
pub use c_ptexture::Ptex__v2_4__FaceInfo_adjedge as Ptex_FaceInfo_adjedge;
pub use c_ptexture::Ptex__v2_4__FaceInfo_adjface as Ptex_FaceInfo_adjface;
pub use c_ptexture::Ptex__v2_4__FaceInfo_isConstant as Ptex_FaceInfo_isConstant;
pub use c_ptexture::Ptex__v2_4__FaceInfo_isNeighborhoodConstant as Ptex_FaceInfo_isNeighborhoodConstant;
pub use c_ptexture::Ptex__v2_4__FaceInfo_hasEdits as Ptex_FaceInfo_hasEdits;
pub use c_ptexture::Ptex__v2_4__FaceInfo_isSubface as Ptex_FaceInfo_isSubface;
pub use c_ptexture::Ptex__v2_4__FaceInfo_setadjfaces as Ptex_FaceInfo_setadjfaces;
pub use c_ptexture::Ptex__v2_4__FaceInfo_setadjedges as Ptex_FaceInfo_setadjedges;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_release as Ptex_PtexMetaData_release;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_numKeys as Ptex_PtexMetaData_numKeys;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getKey as Ptex_PtexMetaData_getKey;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_findKey as Ptex_PtexMetaData_findKey;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromKeyChar as Ptex_PtexMetaData_getValueFromKeyChar;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromIndexChar as Ptex_PtexMetaData_getValueFromIndexChar;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromKeySChar as Ptex_PtexMetaData_getValueFromKeySChar;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromIndexSChar as Ptex_PtexMetaData_getValueFromIndexSChar;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromKeyShort as Ptex_PtexMetaData_getValueFromKeyShort;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromIndexShort as Ptex_PtexMetaData_getValueFromIndexShort;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromKeyInt as Ptex_PtexMetaData_getValueFromKeyInt;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromIndexInt as Ptex_PtexMetaData_getValueFromIndexInt;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromKeyFloat as Ptex_PtexMetaData_getValueFromKeyFloat;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromIndexFloat as Ptex_PtexMetaData_getValueFromIndexFloat;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromKeyDouble as Ptex_PtexMetaData_getValueFromKeyDouble;
pub use c_ptexture::Ptex__v2_4__PtexMetaData_getValueFromIndexDouble as Ptex_PtexMetaData_getValueFromIndexDouble;
pub use c_ptexture::Ptex__v2_4__PtexMetaData__assign as Ptex_PtexMetaData__assign;
pub use c_ptexture::Ptex__v2_4__PtexFaceData_release as Ptex_PtexFaceData_release;
pub use c_ptexture::Ptex__v2_4__PtexFaceData_isConstant as Ptex_PtexFaceData_isConstant;
pub use c_ptexture::Ptex__v2_4__PtexFaceData_res as Ptex_PtexFaceData_res;
pub use c_ptexture::Ptex__v2_4__PtexFaceData_getPixel as Ptex_PtexFaceData_getPixel;
pub use c_ptexture::Ptex__v2_4__PtexFaceData_getData as Ptex_PtexFaceData_getData;
pub use c_ptexture::Ptex__v2_4__PtexFaceData_isTiled as Ptex_PtexFaceData_isTiled;
pub use c_ptexture::Ptex__v2_4__PtexFaceData_tileRes as Ptex_PtexFaceData_tileRes;
pub use c_ptexture::Ptex__v2_4__PtexFaceData_getTile as Ptex_PtexFaceData_getTile;
pub use c_ptexture::Ptex__v2_4__PtexFaceData__assign as Ptex_PtexFaceData__assign;
pub use c_ptexture::Ptex__v2_4__PtexTexture_open as Ptex_PtexTexture_open;
pub use c_ptexture::Ptex__v2_4__PtexTexture_release as Ptex_PtexTexture_release;
pub use c_ptexture::Ptex__v2_4__PtexTexture_path as Ptex_PtexTexture_path;
pub use c_ptexture::Ptex__v2_4__PtexTexture_getInfo as Ptex_PtexTexture_getInfo;
pub use c_ptexture::Ptex__v2_4__PtexTexture_meshType as Ptex_PtexTexture_meshType;
pub use c_ptexture::Ptex__v2_4__PtexTexture_dataType as Ptex_PtexTexture_dataType;
pub use c_ptexture::Ptex__v2_4__PtexTexture_uBorderMode as Ptex_PtexTexture_uBorderMode;
pub use c_ptexture::Ptex__v2_4__PtexTexture_vBorderMode as Ptex_PtexTexture_vBorderMode;
pub use c_ptexture::Ptex__v2_4__PtexTexture_edgeFilterMode as Ptex_PtexTexture_edgeFilterMode;
pub use c_ptexture::Ptex__v2_4__PtexTexture_alphaChannel as Ptex_PtexTexture_alphaChannel;
pub use c_ptexture::Ptex__v2_4__PtexTexture_numChannels as Ptex_PtexTexture_numChannels;
pub use c_ptexture::Ptex__v2_4__PtexTexture_numFaces as Ptex_PtexTexture_numFaces;
pub use c_ptexture::Ptex__v2_4__PtexTexture_hasEdits as Ptex_PtexTexture_hasEdits;
pub use c_ptexture::Ptex__v2_4__PtexTexture_hasMipMaps as Ptex_PtexTexture_hasMipMaps;
pub use c_ptexture::Ptex__v2_4__PtexTexture_getMetaData as Ptex_PtexTexture_getMetaData;
pub use c_ptexture::Ptex__v2_4__PtexTexture_getFaceInfo as Ptex_PtexTexture_getFaceInfo;
pub use c_ptexture::Ptex__v2_4__PtexTexture_getDataInto as Ptex_PtexTexture_getDataInto;
pub use c_ptexture::Ptex__v2_4__PtexTexture_getDataIntoWithRes as Ptex_PtexTexture_getDataIntoWithRes;
pub use c_ptexture::Ptex__v2_4__PtexTexture_getData as Ptex_PtexTexture_getData;
pub use c_ptexture::Ptex__v2_4__PtexTexture_getDataWithRes as Ptex_PtexTexture_getDataWithRes;
pub use c_ptexture::Ptex__v2_4__PtexTexture_getPixel as Ptex_PtexTexture_getPixel;
pub use c_ptexture::Ptex__v2_4__PtexTexture_getPixelWithRes as Ptex_PtexTexture_getPixelWithRes;
pub use c_ptexture::Ptex__v2_4__PtexTexture__assign as Ptex_PtexTexture__assign;
pub use c_ptexture::Ptex__v2_4__PtexTexture__Info_sizeof as Ptex_PtexTexture_Info_sizeof;
pub use c_ptexture::Ptex__v2_4__PtexTexture__Info_alignof as Ptex_PtexTexture_Info_alignof;
pub use c_ptexture::Ptex__v2_4__PtexInputHandler_open as Ptex_PtexInputHandler_open;
pub use c_ptexture::Ptex__v2_4__PtexInputHandler_seek as Ptex_PtexInputHandler_seek;
pub use c_ptexture::Ptex__v2_4__PtexInputHandler_close as Ptex_PtexInputHandler_close;
pub use c_ptexture::Ptex__v2_4__PtexInputHandler_lastError as Ptex_PtexInputHandler_lastError;
pub use c_ptexture::Ptex__v2_4__PtexInputHandler__assign as Ptex_PtexInputHandler__assign;
pub use c_ptexture::Ptex__v2_4__PtexErrorHandler_reportError as Ptex_PtexErrorHandler_reportError;
pub use c_ptexture::Ptex__v2_4__PtexErrorHandler__assign as Ptex_PtexErrorHandler__assign;
pub use c_ptexture::Ptex__v2_4__PtexCache_release as Ptex_PtexCache_release;
pub use c_ptexture::Ptex__v2_4__PtexCache_setSearchPath as Ptex_PtexCache_setSearchPath;
pub use c_ptexture::Ptex__v2_4__PtexCache_getSearchPath as Ptex_PtexCache_getSearchPath;
pub use c_ptexture::Ptex__v2_4__PtexCache_get as Ptex_PtexCache_get;
pub use c_ptexture::Ptex__v2_4__PtexCache_purge as Ptex_PtexCache_purge;
pub use c_ptexture::Ptex__v2_4__PtexCache_purgePath as Ptex_PtexCache_purgePath;
pub use c_ptexture::Ptex__v2_4__PtexCache_purgeAll as Ptex_PtexCache_purgeAll;
pub use c_ptexture::Ptex__v2_4__PtexCache_getStats as Ptex_PtexCache_getStats;
pub use c_ptexture::Ptex__v2_4__PtexCache__assign as Ptex_PtexCache__assign;
pub use c_ptexture::Ptex__v2_4__PtexCache__Stats_sizeof as Ptex_PtexCache_Stats_sizeof;
pub use c_ptexture::Ptex__v2_4__PtexCache__Stats_alignof as Ptex_PtexCache_Stats_alignof;
pub use c_ptexture::Ptex__v2_4__PtexWriter_open as Ptex_PtexWriter_open;
pub use c_ptexture::Ptex__v2_4__PtexWriter_edit as Ptex_PtexWriter_edit;
pub use c_ptexture::Ptex__v2_4__PtexWriter_applyEdits as Ptex_PtexWriter_applyEdits;
pub use c_ptexture::Ptex__v2_4__PtexWriter_release as Ptex_PtexWriter_release;
pub use c_ptexture::Ptex__v2_4__PtexWriter_setBorderModes as Ptex_PtexWriter_setBorderModes;
pub use c_ptexture::Ptex__v2_4__PtexWriter_setEdgeFilterMode as Ptex_PtexWriter_setEdgeFilterMode;
pub use c_ptexture::Ptex__v2_4__PtexWriter_writeMetaString as Ptex_PtexWriter_writeMetaString;
pub use c_ptexture::Ptex__v2_4__PtexWriter_writeMetaChar as Ptex_PtexWriter_writeMetaChar;
pub use c_ptexture::Ptex__v2_4__PtexWriter_writeMetaShort as Ptex_PtexWriter_writeMetaShort;
pub use c_ptexture::Ptex__v2_4__PtexWriter_writeMetaInt as Ptex_PtexWriter_writeMetaInt;
pub use c_ptexture::Ptex__v2_4__PtexWriter_writeMetaFloat as Ptex_PtexWriter_writeMetaFloat;
pub use c_ptexture::Ptex__v2_4__PtexWriter_writeMetaDouble as Ptex_PtexWriter_writeMetaDouble;
pub use c_ptexture::Ptex__v2_4__PtexWriter_writeMeta as Ptex_PtexWriter_writeMeta;
pub use c_ptexture::Ptex__v2_4__PtexWriter_writeFace as Ptex_PtexWriter_writeFace;
pub use c_ptexture::Ptex__v2_4__PtexWriter_writeConstantFace as Ptex_PtexWriter_writeConstantFace;
pub use c_ptexture::Ptex__v2_4__PtexWriter_close as Ptex_PtexWriter_close;
pub use c_ptexture::Ptex__v2_4__PtexWriter__assign as Ptex_PtexWriter__assign;
pub use c_ptexture::Ptex__v2_4__PtexFilter_getFilter as Ptex_PtexFilter_getFilter;
pub use c_ptexture::Ptex__v2_4__PtexFilter_release as Ptex_PtexFilter_release;
pub use c_ptexture::Ptex__v2_4__PtexFilter_eval as Ptex_PtexFilter_eval;
pub use c_ptexture::Ptex__v2_4__PtexFilter__assign as Ptex_PtexFilter__assign;
pub use c_ptexture::Ptex__v2_4__PtexFilter__Options_sizeof as Ptex_PtexFilter_Options_sizeof;
pub use c_ptexture::Ptex__v2_4__PtexFilter__Options_alignof as Ptex_PtexFilter_Options_alignof;
pub use c_ptexture::Ptex__v2_4__PtexFilter__Options_ctor as Ptex_PtexFilter_Options_ctor;
pub use c_ptexture::Ptex_v2_4_MeshTypeName as Ptex_MeshTypeName;
pub use c_ptexture::Ptex_v2_4_DataTypeName as Ptex_DataTypeName;
pub use c_ptexture::Ptex_v2_4_BorderModeName as Ptex_BorderModeName;
pub use c_ptexture::Ptex_v2_4_EdgeFilterModeName as Ptex_EdgeFilterModeName;
pub use c_ptexture::Ptex_v2_4_EdgeIdName as Ptex_EdgeIdName;
pub use c_ptexture::Ptex_v2_4_MetaDataTypeName as Ptex_MetaDataTypeName;
pub use c_ptexture::Ptex_v2_4_DataSize as Ptex_DataSize;
pub use c_ptexture::Ptex_v2_4_OneValue as Ptex_OneValue;
pub use c_ptexture::Ptex_v2_4_OneValueInv as Ptex_OneValueInv;
pub use c_ptexture::Ptex_v2_4_ConvertToFloat as Ptex_ConvertToFloat;
pub use c_ptexture::Ptex_v2_4_ConvertFromFloat as Ptex_ConvertFromFloat;
pub mod c_ptexture;
pub mod std_string;
pub mod c_ptex_half;
pub mod cppmmabi;


#[cfg(test)]
mod test;
