#![allow(non_snake_case)]
#![allow(non_camel_case_types)]
#![allow(non_upper_case_globals)]
#![allow(unused_imports)]
use crate::*;
pub use crate::cppmmabi::*;
use std::os::raw::*;

#[repr(C, align(1))]
#[derive(Clone)]
pub struct Ptex__v2_4__Res_t {
    pub ulog2: c_char,
    pub vlog2: c_char,
}


impl Ptex__v2_4__FaceInfo_t {
    pub fn layout() -> std::alloc::Layout {
        unsafe {
            std::alloc::Layout::from_size_align(
                Ptex__v2_4__FaceInfo_sizeof(),
                Ptex__v2_4__FaceInfo_alignof(),
            ).unwrap()
        }
    }
}

#[repr(C)]
pub struct Ptex__v2_4__PtexMetaData_t {
    _unused: [u8; 0],
}
#[repr(C)]
pub struct Ptex__v2_4__PtexFaceData_t {
    _unused: [u8; 0],
}
#[repr(C)]
pub struct Ptex__v2_4__PtexTexture_t {
    _unused: [u8; 0],
}

impl Ptex__v2_4__PtexTexture__Info_t {
    pub fn layout() -> std::alloc::Layout {
        unsafe {
            std::alloc::Layout::from_size_align(
                Ptex__v2_4__PtexTexture__Info_sizeof(),
                Ptex__v2_4__PtexTexture__Info_alignof(),
            ).unwrap()
        }
    }
}

#[repr(C)]
pub struct Ptex__v2_4__PtexInputHandler_t {
    _unused: [u8; 0],
}
#[repr(C)]
pub struct Ptex__v2_4__PtexErrorHandler_t {
    _unused: [u8; 0],
}
#[repr(C)]
pub struct Ptex__v2_4__PtexCache_t {
    _unused: [u8; 0],
}

impl Ptex__v2_4__PtexCache__Stats_t {
    pub fn layout() -> std::alloc::Layout {
        unsafe {
            std::alloc::Layout::from_size_align(
                Ptex__v2_4__PtexCache__Stats_sizeof(),
                Ptex__v2_4__PtexCache__Stats_alignof(),
            ).unwrap()
        }
    }
}

#[repr(C)]
pub struct Ptex__v2_4__PtexWriter_t {
    _unused: [u8; 0],
}
#[repr(C)]
pub struct Ptex__v2_4__PtexFilter_t {
    _unused: [u8; 0],
}

impl Ptex__v2_4__PtexFilter__Options_t {
    pub fn layout() -> std::alloc::Layout {
        unsafe {
            std::alloc::Layout::from_size_align(
                Ptex__v2_4__PtexFilter__Options_sizeof(),
                Ptex__v2_4__PtexFilter__Options_alignof(),
            ).unwrap()
        }
    }
}


#[repr(transparent)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Ptex__v2_4__PtexFilter__FilterType_e(pub u32);
pub const Ptex_PtexFilter_FilterType_f_point: Ptex__v2_4__PtexFilter__FilterType_e = Ptex__v2_4__PtexFilter__FilterType_e(0);
pub const Ptex_PtexFilter_FilterType_f_bilinear: Ptex__v2_4__PtexFilter__FilterType_e = Ptex__v2_4__PtexFilter__FilterType_e(1);
pub const Ptex_PtexFilter_FilterType_f_box: Ptex__v2_4__PtexFilter__FilterType_e = Ptex__v2_4__PtexFilter__FilterType_e(2);
pub const Ptex_PtexFilter_FilterType_f_gaussian: Ptex__v2_4__PtexFilter__FilterType_e = Ptex__v2_4__PtexFilter__FilterType_e(3);
pub const Ptex_PtexFilter_FilterType_f_bicubic: Ptex__v2_4__PtexFilter__FilterType_e = Ptex__v2_4__PtexFilter__FilterType_e(4);
pub const Ptex_PtexFilter_FilterType_f_bspline: Ptex__v2_4__PtexFilter__FilterType_e = Ptex__v2_4__PtexFilter__FilterType_e(5);
pub const Ptex_PtexFilter_FilterType_f_catmullrom: Ptex__v2_4__PtexFilter__FilterType_e = Ptex__v2_4__PtexFilter__FilterType_e(6);
pub const Ptex_PtexFilter_FilterType_f_mitchell: Ptex__v2_4__PtexFilter__FilterType_e = Ptex__v2_4__PtexFilter__FilterType_e(7);

#[repr(transparent)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Ptex__v2_4__MeshType_e(pub u32);
pub const Ptex_MeshType_mt_triangle: Ptex__v2_4__MeshType_e = Ptex__v2_4__MeshType_e(0);
pub const Ptex_MeshType_mt_quad: Ptex__v2_4__MeshType_e = Ptex__v2_4__MeshType_e(1);

#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub enum MeshType {
    Triangle = 0,
    Quad = 1,
}

impl From<Ptex__v2_4__MeshType_e> for MeshType {
    fn from(e: Ptex__v2_4__MeshType_e) -> MeshType {
        match e {
            Ptex_MeshType_mt_triangle => MeshType::Triangle,
            Ptex_MeshType_mt_quad => MeshType::Quad,
            _ => panic!("Invalid value {:?} for MeshType in conversion", e),
        }
    }
}

impl From<MeshType> for Ptex__v2_4__MeshType_e {
    fn from(e: MeshType) -> Ptex__v2_4__MeshType_e {
        match e {
            MeshType::Triangle => Ptex_MeshType_mt_triangle,
            MeshType::Quad => Ptex_MeshType_mt_quad,
        }
    }
}

#[repr(transparent)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Ptex__v2_4__DataType_e(pub u32);
pub const Ptex_DataType_dt_uint8: Ptex__v2_4__DataType_e = Ptex__v2_4__DataType_e(0);
pub const Ptex_DataType_dt_uint16: Ptex__v2_4__DataType_e = Ptex__v2_4__DataType_e(1);
pub const Ptex_DataType_dt_half: Ptex__v2_4__DataType_e = Ptex__v2_4__DataType_e(2);
pub const Ptex_DataType_dt_float: Ptex__v2_4__DataType_e = Ptex__v2_4__DataType_e(3);

#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub enum DataType {
    Uint8 = 0,
    Uint16 = 1,
    Half = 2,
    Float = 3,
}

impl From<Ptex__v2_4__DataType_e> for DataType {
    fn from(e: Ptex__v2_4__DataType_e) -> DataType {
        match e {
            Ptex_DataType_dt_uint8 => DataType::Uint8,
            Ptex_DataType_dt_uint16 => DataType::Uint16,
            Ptex_DataType_dt_half => DataType::Half,
            Ptex_DataType_dt_float => DataType::Float,
            _ => panic!("Invalid value {:?} for DataType in conversion", e),
        }
    }
}

impl From<DataType> for Ptex__v2_4__DataType_e {
    fn from(e: DataType) -> Ptex__v2_4__DataType_e {
        match e {
            DataType::Uint8 => Ptex_DataType_dt_uint8,
            DataType::Uint16 => Ptex_DataType_dt_uint16,
            DataType::Half => Ptex_DataType_dt_half,
            DataType::Float => Ptex_DataType_dt_float,
        }
    }
}

#[repr(transparent)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Ptex__v2_4__EdgeFilterMode_e(pub u32);
pub const Ptex_EdgeFilterMode_efm_none: Ptex__v2_4__EdgeFilterMode_e = Ptex__v2_4__EdgeFilterMode_e(0);
pub const Ptex_EdgeFilterMode_efm_tanvec: Ptex__v2_4__EdgeFilterMode_e = Ptex__v2_4__EdgeFilterMode_e(1);

#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub enum EdgeFilterMode {
    None = 0,
    Tanvec = 1,
}

impl From<Ptex__v2_4__EdgeFilterMode_e> for EdgeFilterMode {
    fn from(e: Ptex__v2_4__EdgeFilterMode_e) -> EdgeFilterMode {
        match e {
            Ptex_EdgeFilterMode_efm_none => EdgeFilterMode::None,
            Ptex_EdgeFilterMode_efm_tanvec => EdgeFilterMode::Tanvec,
            _ => panic!("Invalid value {:?} for EdgeFilterMode in conversion", e),
        }
    }
}

impl From<EdgeFilterMode> for Ptex__v2_4__EdgeFilterMode_e {
    fn from(e: EdgeFilterMode) -> Ptex__v2_4__EdgeFilterMode_e {
        match e {
            EdgeFilterMode::None => Ptex_EdgeFilterMode_efm_none,
            EdgeFilterMode::Tanvec => Ptex_EdgeFilterMode_efm_tanvec,
        }
    }
}

#[repr(transparent)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Ptex__v2_4__BorderMode_e(pub u32);
pub const Ptex_BorderMode_m_clamp: Ptex__v2_4__BorderMode_e = Ptex__v2_4__BorderMode_e(0);
pub const Ptex_BorderMode_m_black: Ptex__v2_4__BorderMode_e = Ptex__v2_4__BorderMode_e(1);
pub const Ptex_BorderMode_m_periodic: Ptex__v2_4__BorderMode_e = Ptex__v2_4__BorderMode_e(2);

#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub enum BorderMode {
    Clamp = 0,
    Black = 1,
    Periodic = 2,
}

impl From<Ptex__v2_4__BorderMode_e> for BorderMode {
    fn from(e: Ptex__v2_4__BorderMode_e) -> BorderMode {
        match e {
            Ptex_BorderMode_m_clamp => BorderMode::Clamp,
            Ptex_BorderMode_m_black => BorderMode::Black,
            Ptex_BorderMode_m_periodic => BorderMode::Periodic,
            _ => panic!("Invalid value {:?} for BorderMode in conversion", e),
        }
    }
}

impl From<BorderMode> for Ptex__v2_4__BorderMode_e {
    fn from(e: BorderMode) -> Ptex__v2_4__BorderMode_e {
        match e {
            BorderMode::Clamp => Ptex_BorderMode_m_clamp,
            BorderMode::Black => Ptex_BorderMode_m_black,
            BorderMode::Periodic => Ptex_BorderMode_m_periodic,
        }
    }
}

#[repr(transparent)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Ptex__v2_4__EdgeId_e(pub u32);
pub const Ptex_EdgeId_e_bottom: Ptex__v2_4__EdgeId_e = Ptex__v2_4__EdgeId_e(0);
pub const Ptex_EdgeId_e_right: Ptex__v2_4__EdgeId_e = Ptex__v2_4__EdgeId_e(1);
pub const Ptex_EdgeId_e_top: Ptex__v2_4__EdgeId_e = Ptex__v2_4__EdgeId_e(2);
pub const Ptex_EdgeId_e_left: Ptex__v2_4__EdgeId_e = Ptex__v2_4__EdgeId_e(3);

#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub enum EdgeId {
    Bottom = 0,
    Right = 1,
    Top = 2,
    Left = 3,
}

impl From<Ptex__v2_4__EdgeId_e> for EdgeId {
    fn from(e: Ptex__v2_4__EdgeId_e) -> EdgeId {
        match e {
            Ptex_EdgeId_e_bottom => EdgeId::Bottom,
            Ptex_EdgeId_e_right => EdgeId::Right,
            Ptex_EdgeId_e_top => EdgeId::Top,
            Ptex_EdgeId_e_left => EdgeId::Left,
            _ => panic!("Invalid value {:?} for EdgeId in conversion", e),
        }
    }
}

impl From<EdgeId> for Ptex__v2_4__EdgeId_e {
    fn from(e: EdgeId) -> Ptex__v2_4__EdgeId_e {
        match e {
            EdgeId::Bottom => Ptex_EdgeId_e_bottom,
            EdgeId::Right => Ptex_EdgeId_e_right,
            EdgeId::Top => Ptex_EdgeId_e_top,
            EdgeId::Left => Ptex_EdgeId_e_left,
        }
    }
}

#[repr(transparent)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Ptex__v2_4__MetaDataType_e(pub u32);
pub const Ptex_MetaDataType_mdt_string: Ptex__v2_4__MetaDataType_e = Ptex__v2_4__MetaDataType_e(0);
pub const Ptex_MetaDataType_mdt_int8: Ptex__v2_4__MetaDataType_e = Ptex__v2_4__MetaDataType_e(1);
pub const Ptex_MetaDataType_mdt_int16: Ptex__v2_4__MetaDataType_e = Ptex__v2_4__MetaDataType_e(2);
pub const Ptex_MetaDataType_mdt_int32: Ptex__v2_4__MetaDataType_e = Ptex__v2_4__MetaDataType_e(3);
pub const Ptex_MetaDataType_mdt_float: Ptex__v2_4__MetaDataType_e = Ptex__v2_4__MetaDataType_e(4);
pub const Ptex_MetaDataType_mdt_double: Ptex__v2_4__MetaDataType_e = Ptex__v2_4__MetaDataType_e(5);

#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub enum MetaDataType {
    String = 0,
    Int8 = 1,
    Int16 = 2,
    Int32 = 3,
    Float = 4,
    Double = 5,
}

impl From<Ptex__v2_4__MetaDataType_e> for MetaDataType {
    fn from(e: Ptex__v2_4__MetaDataType_e) -> MetaDataType {
        match e {
            Ptex_MetaDataType_mdt_string => MetaDataType::String,
            Ptex_MetaDataType_mdt_int8 => MetaDataType::Int8,
            Ptex_MetaDataType_mdt_int16 => MetaDataType::Int16,
            Ptex_MetaDataType_mdt_int32 => MetaDataType::Int32,
            Ptex_MetaDataType_mdt_float => MetaDataType::Float,
            Ptex_MetaDataType_mdt_double => MetaDataType::Double,
            _ => panic!("Invalid value {:?} for MetaDataType in conversion", e),
        }
    }
}

impl From<MetaDataType> for Ptex__v2_4__MetaDataType_e {
    fn from(e: MetaDataType) -> Ptex__v2_4__MetaDataType_e {
        match e {
            MetaDataType::String => Ptex_MetaDataType_mdt_string,
            MetaDataType::Int8 => Ptex_MetaDataType_mdt_int8,
            MetaDataType::Int16 => Ptex_MetaDataType_mdt_int16,
            MetaDataType::Int32 => Ptex_MetaDataType_mdt_int32,
            MetaDataType::Float => Ptex_MetaDataType_mdt_float,
            MetaDataType::Double => Ptex_MetaDataType_mdt_double,
        }
    }
}


extern "C" {

pub fn Ptex__v2_4__Res_ctor(this_: *mut Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_from_uv_log2(this_: *mut Ptex_Res_t, ulog2_: c_char, vlog2_: c_char) -> Exception;

pub fn Ptex__v2_4__Res_from_value(this_: *mut Ptex_Res_t, value: c_ushort) -> Exception;

pub fn Ptex__v2_4__Res_u(this_: *const Ptex_Res_t, return_: *mut c_int) -> Exception;

pub fn Ptex__v2_4__Res_v(this_: *const Ptex_Res_t, return_: *mut c_int) -> Exception;

pub fn Ptex__v2_4__Res_val(this_: *const Ptex_Res_t, return_: *mut c_ushort) -> Exception;

pub fn Ptex__v2_4__Res_size(this_: *const Ptex_Res_t, return_: *mut c_int) -> Exception;

pub fn Ptex__v2_4__Res__eq(this_: *const Ptex_Res_t, return_: *mut bool, r: *const Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res__ne(this_: *const Ptex_Res_t, return_: *mut bool, r: *const Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res__op_ge(this_: *const Ptex_Res_t, return_: *mut bool, r: *const Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_swappeduv(this_: *const Ptex_Res_t, return_: *mut Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_swapuv(this_: *mut Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_clamp(this_: *mut Ptex_Res_t, r: *const Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_ntilesu(this_: *const Ptex_Res_t, return_: *mut c_int, tileres: Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_ntilesv(this_: *const Ptex_Res_t, return_: *mut c_int, tileres: Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_ntiles(this_: *const Ptex_Res_t, return_: *mut c_int, tileres: Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_copy(this_: *mut Ptex_Res_t, rhs: *const Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_dtor(this_: *mut Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__Res_assign(this_: *mut Ptex_Res_t, return_: *mut *mut Ptex_Res_t, rhs: *const Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__FaceInfo_sizeof() -> usize;

pub fn Ptex__v2_4__FaceInfo_alignof() -> usize;

pub fn Ptex__v2_4__FaceInfo_default(this_: *mut Ptex_FaceInfo_t) -> Exception;

pub fn Ptex__v2_4__FaceInfo_from_res(this_: *mut Ptex_FaceInfo_t, res_: Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__FaceInfo_from_res_and_adjacency(this_: *mut Ptex_FaceInfo_t, res_: Ptex_Res_t, adjfaces_: *mut c_int, adjedges_: *mut c_int, is_subface_: bool) -> Exception;

pub fn Ptex__v2_4__FaceInfo_adjedge(this_: *const Ptex_FaceInfo_t, return_: *mut Ptex_EdgeId, eid: c_int) -> Exception;

pub fn Ptex__v2_4__FaceInfo_adjface(this_: *const Ptex_FaceInfo_t, return_: *mut c_int, eid: c_int) -> Exception;

pub fn Ptex__v2_4__FaceInfo_isConstant(this_: *const Ptex_FaceInfo_t, return_: *mut bool) -> Exception;

pub fn Ptex__v2_4__FaceInfo_isNeighborhoodConstant(this_: *const Ptex_FaceInfo_t, return_: *mut bool) -> Exception;

pub fn Ptex__v2_4__FaceInfo_hasEdits(this_: *const Ptex_FaceInfo_t, return_: *mut bool) -> Exception;

pub fn Ptex__v2_4__FaceInfo_isSubface(this_: *const Ptex_FaceInfo_t, return_: *mut bool) -> Exception;

pub fn Ptex__v2_4__FaceInfo_setadjfaces(this_: *mut Ptex_FaceInfo_t, f0: c_int, f1: c_int, f2: c_int, f3: c_int) -> Exception;

pub fn Ptex__v2_4__FaceInfo_setadjedges(this_: *mut Ptex_FaceInfo_t, e0: c_int, e1: c_int, e2: c_int, e3: c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_release(this_: *mut Ptex_PtexMetaData_t) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_numKeys(this_: *mut Ptex_PtexMetaData_t, return_: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getKey(this_: *mut Ptex_PtexMetaData_t, index: c_int, key: *mut *const c_char, type_: *mut Ptex_MetaDataType) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_findKey(this_: *mut Ptex_PtexMetaData_t, return_: *mut bool, key: *const c_char, index: *mut c_int, type_: *mut Ptex_MetaDataType) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromKeyChar(this_: *mut Ptex_PtexMetaData_t, key: *const c_char, value: *mut *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromIndexChar(this_: *mut Ptex_PtexMetaData_t, index: c_int, value: *mut *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromKeySChar(this_: *mut Ptex_PtexMetaData_t, key: *const c_char, value: *mut *const c_char, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromIndexSChar(this_: *mut Ptex_PtexMetaData_t, index: c_int, value: *mut *const c_char, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromKeyShort(this_: *mut Ptex_PtexMetaData_t, key: *const c_char, value: *mut *const c_short, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromIndexShort(this_: *mut Ptex_PtexMetaData_t, index: c_int, value: *mut *const c_short, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromKeyInt(this_: *mut Ptex_PtexMetaData_t, key: *const c_char, value: *mut *const c_int, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromIndexInt(this_: *mut Ptex_PtexMetaData_t, index: c_int, value: *mut *const c_int, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromKeyFloat(this_: *mut Ptex_PtexMetaData_t, key: *const c_char, value: *mut *const c_float, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromIndexFloat(this_: *mut Ptex_PtexMetaData_t, index: c_int, value: *mut *const c_float, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromKeyDouble(this_: *mut Ptex_PtexMetaData_t, key: *const c_char, value: *mut *const c_double, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData_getValueFromIndexDouble(this_: *mut Ptex_PtexMetaData_t, index: c_int, value: *mut *const c_double, count: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexMetaData__assign(this_: *mut Ptex_PtexMetaData_t, return_: *mut *mut Ptex_PtexMetaData_t, rhs: *const Ptex_PtexMetaData_t) -> Exception;

pub fn Ptex__v2_4__PtexFaceData_release(this_: *mut Ptex_PtexFaceData_t) -> Exception;

pub fn Ptex__v2_4__PtexFaceData_isConstant(this_: *mut Ptex_PtexFaceData_t, return_: *mut bool) -> Exception;

pub fn Ptex__v2_4__PtexFaceData_res(this_: *mut Ptex_PtexFaceData_t, return_: *mut Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__PtexFaceData_getPixel(this_: *mut Ptex_PtexFaceData_t, u: c_int, v: c_int, result: *mut c_void) -> Exception;

pub fn Ptex__v2_4__PtexFaceData_getData(this_: *mut Ptex_PtexFaceData_t, return_: *mut *mut c_void) -> Exception;

pub fn Ptex__v2_4__PtexFaceData_isTiled(this_: *mut Ptex_PtexFaceData_t, return_: *mut bool) -> Exception;

pub fn Ptex__v2_4__PtexFaceData_tileRes(this_: *mut Ptex_PtexFaceData_t, return_: *mut Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__PtexFaceData_getTile(this_: *mut Ptex_PtexFaceData_t, return_: *mut *mut Ptex_PtexFaceData_t, tile: c_int) -> Exception;

pub fn Ptex__v2_4__PtexFaceData__assign(this_: *mut Ptex_PtexFaceData_t, return_: *mut *mut Ptex_PtexFaceData_t, rhs: *const Ptex_PtexFaceData_t) -> Exception;

pub fn Ptex__v2_4__PtexTexture_open(return_: *mut *mut Ptex_PtexTexture_t, path: *const c_char, error: *mut std_string_t, premultiply: bool) -> Exception;

pub fn Ptex__v2_4__PtexTexture_release(this_: *mut Ptex_PtexTexture_t) -> Exception;

pub fn Ptex__v2_4__PtexTexture_path(this_: *mut Ptex_PtexTexture_t, return_: *mut *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexTexture_getInfo(this_: *mut Ptex_PtexTexture_t, return_: *mut Ptex_PtexTexture_Info_t) -> Exception;

pub fn Ptex__v2_4__PtexTexture_meshType(this_: *mut Ptex_PtexTexture_t, return_: *mut Ptex_MeshType) -> Exception;

pub fn Ptex__v2_4__PtexTexture_dataType(this_: *mut Ptex_PtexTexture_t, return_: *mut Ptex_DataType) -> Exception;

pub fn Ptex__v2_4__PtexTexture_uBorderMode(this_: *mut Ptex_PtexTexture_t, return_: *mut Ptex_BorderMode) -> Exception;

pub fn Ptex__v2_4__PtexTexture_vBorderMode(this_: *mut Ptex_PtexTexture_t, return_: *mut Ptex_BorderMode) -> Exception;

pub fn Ptex__v2_4__PtexTexture_edgeFilterMode(this_: *mut Ptex_PtexTexture_t, return_: *mut Ptex_EdgeFilterMode) -> Exception;

pub fn Ptex__v2_4__PtexTexture_alphaChannel(this_: *mut Ptex_PtexTexture_t, return_: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexTexture_numChannels(this_: *mut Ptex_PtexTexture_t, return_: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexTexture_numFaces(this_: *mut Ptex_PtexTexture_t, return_: *mut c_int) -> Exception;

pub fn Ptex__v2_4__PtexTexture_hasEdits(this_: *mut Ptex_PtexTexture_t, return_: *mut bool) -> Exception;

pub fn Ptex__v2_4__PtexTexture_hasMipMaps(this_: *mut Ptex_PtexTexture_t, return_: *mut bool) -> Exception;

pub fn Ptex__v2_4__PtexTexture_getMetaData(this_: *mut Ptex_PtexTexture_t, return_: *mut *mut Ptex_PtexMetaData_t) -> Exception;

pub fn Ptex__v2_4__PtexTexture_getFaceInfo(this_: *mut Ptex_PtexTexture_t, return_: *mut *const Ptex_FaceInfo_t, faceid: c_int) -> Exception;

pub fn Ptex__v2_4__PtexTexture_getDataInto(this_: *mut Ptex_PtexTexture_t, faceid: c_int, buffer: *mut c_void, stride: c_int) -> Exception;

pub fn Ptex__v2_4__PtexTexture_getDataIntoWithRes(this_: *mut Ptex_PtexTexture_t, faceid: c_int, buffer: *mut c_void, stride: c_int, res: Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__PtexTexture_getData(this_: *mut Ptex_PtexTexture_t, return_: *mut *mut Ptex_PtexFaceData_t, faceid: c_int) -> Exception;

pub fn Ptex__v2_4__PtexTexture_getDataWithRes(this_: *mut Ptex_PtexTexture_t, return_: *mut *mut Ptex_PtexFaceData_t, faceid: c_int, res: Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__PtexTexture_getPixel(this_: *mut Ptex_PtexTexture_t, faceid: c_int, u: c_int, v: c_int, result: *mut c_float, firstchan: c_int, nchannels: c_int) -> Exception;

pub fn Ptex__v2_4__PtexTexture_getPixelWithRes(this_: *mut Ptex_PtexTexture_t, faceid: c_int, u: c_int, v: c_int, result: *mut c_float, firstchan: c_int, nchannels: c_int, res: Ptex_Res_t) -> Exception;

pub fn Ptex__v2_4__PtexTexture__assign(this_: *mut Ptex_PtexTexture_t, return_: *mut *mut Ptex_PtexTexture_t, rhs: *const Ptex_PtexTexture_t) -> Exception;

pub fn Ptex__v2_4__PtexTexture__Info_sizeof() -> usize;

pub fn Ptex__v2_4__PtexTexture__Info_alignof() -> usize;

pub fn Ptex__v2_4__PtexInputHandler_open(this_: *mut Ptex_PtexInputHandler_t, return_: *mut *mut c_void, path: *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexInputHandler_seek(this_: *mut Ptex_PtexInputHandler_t, handle: *mut c_void, pos: c_longlong) -> Exception;

pub fn Ptex__v2_4__PtexInputHandler_close(this_: *mut Ptex_PtexInputHandler_t, return_: *mut bool, handle: *mut c_void) -> Exception;

pub fn Ptex__v2_4__PtexInputHandler_lastError(this_: *mut Ptex_PtexInputHandler_t, return_: *mut *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexInputHandler__assign(this_: *mut Ptex_PtexInputHandler_t, return_: *mut *mut Ptex_PtexInputHandler_t, rhs: *const Ptex_PtexInputHandler_t) -> Exception;

pub fn Ptex__v2_4__PtexErrorHandler_reportError(this_: *mut Ptex_PtexErrorHandler_t, error: *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexErrorHandler__assign(this_: *mut Ptex_PtexErrorHandler_t, return_: *mut *mut Ptex_PtexErrorHandler_t, rhs: *const Ptex_PtexErrorHandler_t) -> Exception;

pub fn Ptex__v2_4__PtexCache_release(this_: *mut Ptex_PtexCache_t) -> Exception;

pub fn Ptex__v2_4__PtexCache_setSearchPath(this_: *mut Ptex_PtexCache_t, path: *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexCache_getSearchPath(this_: *mut Ptex_PtexCache_t, return_: *mut *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexCache_get(this_: *mut Ptex_PtexCache_t, return_: *mut *mut Ptex_PtexTexture_t, path: *const c_char, error: *mut std_string_t) -> Exception;

pub fn Ptex__v2_4__PtexCache_purge(this_: *mut Ptex_PtexCache_t, texture: *mut Ptex_PtexTexture_t) -> Exception;

pub fn Ptex__v2_4__PtexCache_purgePath(this_: *mut Ptex_PtexCache_t, path: *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexCache_purgeAll(this_: *mut Ptex_PtexCache_t) -> Exception;

pub fn Ptex__v2_4__PtexCache_getStats(this_: *mut Ptex_PtexCache_t, stats: *mut Ptex_PtexCache_Stats_t) -> Exception;

pub fn Ptex__v2_4__PtexCache__assign(this_: *mut Ptex_PtexCache_t, return_: *mut *mut Ptex_PtexCache_t, rhs: *const Ptex_PtexCache_t) -> Exception;

pub fn Ptex__v2_4__PtexCache__Stats_sizeof() -> usize;

pub fn Ptex__v2_4__PtexCache__Stats_alignof() -> usize;

pub fn Ptex__v2_4__PtexWriter_open(return_: *mut *mut Ptex_PtexWriter_t, path: *const c_char, mt: Ptex_MeshType, dt: Ptex_DataType, nchannels: c_int, alphachan: c_int, nfaces: c_int, error: *mut std_string_t, genmipmaps: bool) -> Exception;

pub fn Ptex__v2_4__PtexWriter_edit(return_: *mut *mut Ptex_PtexWriter_t, path: *const c_char, incremental: bool, mt: Ptex_MeshType, dt: Ptex_DataType, nchannels: c_int, alphachan: c_int, nfaces: c_int, error: *mut std_string_t, genmipmaps: bool) -> Exception;

pub fn Ptex__v2_4__PtexWriter_applyEdits(return_: *mut bool, path: *const c_char, error: *mut std_string_t) -> Exception;

pub fn Ptex__v2_4__PtexWriter_release(this_: *mut Ptex_PtexWriter_t) -> Exception;

pub fn Ptex__v2_4__PtexWriter_setBorderModes(this_: *mut Ptex_PtexWriter_t, u_border_mode: Ptex_BorderMode, v_border_mode: Ptex_BorderMode) -> Exception;

pub fn Ptex__v2_4__PtexWriter_setEdgeFilterMode(this_: *mut Ptex_PtexWriter_t, edge_filter_mode: Ptex_EdgeFilterMode) -> Exception;

pub fn Ptex__v2_4__PtexWriter_writeMetaString(this_: *mut Ptex_PtexWriter_t, key: *const c_char, string: *const c_char) -> Exception;

pub fn Ptex__v2_4__PtexWriter_writeMetaChar(this_: *mut Ptex_PtexWriter_t, key: *const c_char, value: *const c_char, count: c_int) -> Exception;

pub fn Ptex__v2_4__PtexWriter_writeMetaShort(this_: *mut Ptex_PtexWriter_t, key: *const c_char, value: *const c_short, count: c_int) -> Exception;

pub fn Ptex__v2_4__PtexWriter_writeMetaInt(this_: *mut Ptex_PtexWriter_t, key: *const c_char, value: *const c_int, count: c_int) -> Exception;

pub fn Ptex__v2_4__PtexWriter_writeMetaFloat(this_: *mut Ptex_PtexWriter_t, key: *const c_char, value: *const c_float, count: c_int) -> Exception;

pub fn Ptex__v2_4__PtexWriter_writeMetaDouble(this_: *mut Ptex_PtexWriter_t, key: *const c_char, value: *const c_double, count: c_int) -> Exception;

pub fn Ptex__v2_4__PtexWriter_writeMeta(this_: *mut Ptex_PtexWriter_t, data: *mut Ptex_PtexMetaData_t) -> Exception;

pub fn Ptex__v2_4__PtexWriter_writeFace(this_: *mut Ptex_PtexWriter_t, return_: *mut bool, faceid: c_int, info: *const Ptex_FaceInfo_t, data: *const c_void, stride: c_int) -> Exception;

pub fn Ptex__v2_4__PtexWriter_writeConstantFace(this_: *mut Ptex_PtexWriter_t, return_: *mut bool, faceid: c_int, info: *const Ptex_FaceInfo_t, data: *const c_void) -> Exception;

pub fn Ptex__v2_4__PtexWriter_close(this_: *mut Ptex_PtexWriter_t, return_: *mut bool, error: *mut std_string_t) -> Exception;

pub fn Ptex__v2_4__PtexWriter__assign(this_: *mut Ptex_PtexWriter_t, return_: *mut *mut Ptex_PtexWriter_t, rhs: *const Ptex_PtexWriter_t) -> Exception;

pub fn Ptex__v2_4__PtexFilter_getFilter(return_: *mut *mut Ptex_PtexFilter_t, tx: *mut Ptex_PtexTexture_t, opts: *const Ptex_PtexFilter_Options_t) -> Exception;

pub fn Ptex__v2_4__PtexFilter_release(this_: *mut Ptex_PtexFilter_t) -> Exception;

pub fn Ptex__v2_4__PtexFilter_eval(this_: *mut Ptex_PtexFilter_t, result: *mut c_float, firstchan: c_int, nchannels: c_int, faceid: c_int, u: c_float, v: c_float, uw1: c_float, vw1: c_float, uw2: c_float, vw2: c_float, width: c_float, blur: c_float) -> Exception;

pub fn Ptex__v2_4__PtexFilter__assign(this_: *mut Ptex_PtexFilter_t, return_: *mut *mut Ptex_PtexFilter_t, rhs: *const Ptex_PtexFilter_t) -> Exception;

pub fn Ptex__v2_4__PtexFilter__Options_sizeof() -> usize;

pub fn Ptex__v2_4__PtexFilter__Options_alignof() -> usize;

pub fn Ptex__v2_4__PtexFilter__Options_ctor(this_: *mut Ptex_PtexFilter_Options_t, filter_: Ptex_PtexFilter_FilterType, lerp_: bool, sharpness_: c_float, noedgeblend_: bool) -> Exception;

pub fn Ptex_v2_4_MeshTypeName(return_: *mut *const c_char, mt: Ptex_MeshType) -> Exception;

pub fn Ptex_v2_4_DataTypeName(return_: *mut *const c_char, dt: Ptex_DataType) -> Exception;

pub fn Ptex_v2_4_BorderModeName(return_: *mut *const c_char, m: Ptex_BorderMode) -> Exception;

pub fn Ptex_v2_4_EdgeFilterModeName(return_: *mut *const c_char, m: Ptex_EdgeFilterMode) -> Exception;

pub fn Ptex_v2_4_EdgeIdName(return_: *mut *const c_char, eid: Ptex_EdgeId) -> Exception;

pub fn Ptex_v2_4_MetaDataTypeName(return_: *mut *const c_char, mdt: Ptex_MetaDataType) -> Exception;

pub fn Ptex_v2_4_DataSize(return_: *mut c_int, dt: Ptex_DataType) -> Exception;

pub fn Ptex_v2_4_OneValue(return_: *mut c_float, dt: Ptex_DataType) -> Exception;

pub fn Ptex_v2_4_OneValueInv(return_: *mut c_float, dt: Ptex_DataType) -> Exception;

pub fn Ptex_v2_4_ConvertToFloat(dst: *mut c_float, src: *const c_void, dt: Ptex_DataType, num_channels: c_int) -> Exception;

pub fn Ptex_v2_4_ConvertFromFloat(dst: *mut c_void, src: *const c_float, dt: Ptex_DataType, num_channels: c_int) -> Exception;


} // extern "C"
