#include "std_string_private.h"

#include <new>

#include <stdexcept>

PTEX_CPPMM_API unsigned int std__string_sizeof()
{
        return sizeof(std::string);
}

PTEX_CPPMM_API unsigned int std__string_alignof()
{
        return alignof(std::string);
}

PTEX_CPPMM_API unsigned int std__string_ctor(
    std_string_t * this_
    , char const * s
    , size_t count)
{
    try {
        new (this_) std::string(s, count);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int std__string_assign(
    std_string_t * this_
    , std_string_t * * return_
    , char const * s
    , size_t count)
{
    try {
        to_c(return_, (to_cpp(this_)) -> assign(s, count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int std__string_c_str(
    std_string_t const * this_
    , char const * * return_)
{
        *(return_) = (to_cpp(this_)) -> c_str();
        return 0;
}

