#include "c-ptexture_private.h"

#include "std_string_private.h"
#include <new>

#include <stdexcept>

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_ctor(
    Ptex_Res_t * this_)
{
    try {
        new (this_) Ptex::v2_4::Res();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_from_uv_log2(
    Ptex_Res_t * this_
    , signed char ulog2_
    , signed char vlog2_)
{
    try {
        new (this_) Ptex::v2_4::Res(ulog2_, vlog2_);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_from_value(
    Ptex_Res_t * this_
    , unsigned short value)
{
    try {
        new (this_) Ptex::v2_4::Res(value);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_u(
    Ptex_Res_t const * this_
    , int * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> u();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_v(
    Ptex_Res_t const * this_
    , int * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> v();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_val(
    Ptex_Res_t const * this_
    , unsigned short * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> val();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_size(
    Ptex_Res_t const * this_
    , int * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> size();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res__eq(
    Ptex_Res_t const * this_
    , _Bool * return_
    , Ptex_Res_t const * r)
{
    try {
        *(return_) = (to_cpp(this_)) -> operator==(to_cpp_ref(r));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res__ne(
    Ptex_Res_t const * this_
    , _Bool * return_
    , Ptex_Res_t const * r)
{
    try {
        *(return_) = (to_cpp(this_)) -> operator!=(to_cpp_ref(r));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res__op_ge(
    Ptex_Res_t const * this_
    , _Bool * return_
    , Ptex_Res_t const * r)
{
    try {
        *(return_) = (to_cpp(this_)) -> operator>=(to_cpp_ref(r));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_swappeduv(
    Ptex_Res_t const * this_
    , Ptex_Res_t * return_)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> swappeduv());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_swapuv(
    Ptex_Res_t * this_)
{
    try {
        (to_cpp(this_)) -> swapuv();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_clamp(
    Ptex_Res_t * this_
    , Ptex_Res_t const * r)
{
    try {
        (to_cpp(this_)) -> clamp(to_cpp_ref(r));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_ntilesu(
    Ptex_Res_t const * this_
    , int * return_
    , Ptex_Res_t tileres)
{
    try {
        *(return_) = (to_cpp(this_)) -> ntilesu(to_cpp_ref(&(tileres)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_ntilesv(
    Ptex_Res_t const * this_
    , int * return_
    , Ptex_Res_t tileres)
{
    try {
        *(return_) = (to_cpp(this_)) -> ntilesv(to_cpp_ref(&(tileres)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_ntiles(
    Ptex_Res_t const * this_
    , int * return_
    , Ptex_Res_t tileres)
{
    try {
        *(return_) = (to_cpp(this_)) -> ntiles(to_cpp_ref(&(tileres)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_copy(
    Ptex_Res_t * this_
    , Ptex_Res_t const * rhs)
{
        new (this_) Ptex::v2_4::Res(to_cpp_ref(rhs));
        return 0;
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_dtor(
    Ptex_Res_t * this_)
{
        (to_cpp(this_)) -> Ptex::v2_4::Res::~Res();
        return 0;
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__Res_assign(
    Ptex_Res_t * this_
    , Ptex_Res_t * * return_
    , Ptex_Res_t const * rhs)
{
    try {
        to_c(return_, (to_cpp(this_)) -> operator=(to_cpp_ref(rhs)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_sizeof()
{
        return sizeof(Ptex::v2_4::FaceInfo);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_alignof()
{
        return alignof(Ptex::v2_4::FaceInfo);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_default(
    Ptex_FaceInfo_t * this_)
{
    try {
        new (this_) Ptex::v2_4::FaceInfo();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_from_res(
    Ptex_FaceInfo_t * this_
    , Ptex_Res_t res_)
{
    try {
        new (this_) Ptex::v2_4::FaceInfo(to_cpp_ref(&(res_)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_from_res_and_adjacency(
    Ptex_FaceInfo_t * this_
    , Ptex_Res_t res_
    , int adjfaces_[4]
    , int adjedges_[4]
    , _Bool isSubface_)
{
    try {
        new (this_) Ptex::v2_4::FaceInfo(to_cpp_ref(&(res_)), adjfaces_, adjedges_, isSubface_);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_adjedge(
    Ptex_FaceInfo_t const * this_
    , Ptex_EdgeId * return_
    , int eid)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> adjedge(eid));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_adjface(
    Ptex_FaceInfo_t const * this_
    , int * return_
    , int eid)
{
    try {
        *(return_) = (to_cpp(this_)) -> adjface(eid);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_isConstant(
    Ptex_FaceInfo_t const * this_
    , _Bool * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> isConstant();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_isNeighborhoodConstant(
    Ptex_FaceInfo_t const * this_
    , _Bool * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> isNeighborhoodConstant();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_hasEdits(
    Ptex_FaceInfo_t const * this_
    , _Bool * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> hasEdits();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_isSubface(
    Ptex_FaceInfo_t const * this_
    , _Bool * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> isSubface();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_setadjfaces(
    Ptex_FaceInfo_t * this_
    , int f0
    , int f1
    , int f2
    , int f3)
{
    try {
        (to_cpp(this_)) -> setadjfaces(f0, f1, f2, f3);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__FaceInfo_setadjedges(
    Ptex_FaceInfo_t * this_
    , int e0
    , int e1
    , int e2
    , int e3)
{
    try {
        (to_cpp(this_)) -> setadjedges(e0, e1, e2, e3);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_release(
    Ptex_PtexMetaData_t * this_)
{
    try {
        (to_cpp(this_)) -> release();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_numKeys(
    Ptex_PtexMetaData_t * this_
    , int * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> numKeys();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getKey(
    Ptex_PtexMetaData_t * this_
    , int index
    , char const * * key
    , Ptex_MetaDataType * type)
{
    try {
        (to_cpp(this_)) -> getKey(index, *(key), Ptex_MetaDataType_to_cpp_ref(type));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_findKey(
    Ptex_PtexMetaData_t * this_
    , _Bool * return_
    , char const * key
    , int * index
    , Ptex_MetaDataType * type)
{
    try {
        *(return_) = (to_cpp(this_)) -> findKey(key, *(index), Ptex_MetaDataType_to_cpp_ref(type));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromKeyChar(
    Ptex_PtexMetaData_t * this_
    , char const * key
    , char const * * value)
{
    try {
        (to_cpp(this_)) -> getValue(key, *(value));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromIndexChar(
    Ptex_PtexMetaData_t * this_
    , int index
    , char const * * value)
{
    try {
        (to_cpp(this_)) -> getValue(index, *(value));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromKeySChar(
    Ptex_PtexMetaData_t * this_
    , char const * key
    , signed char const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(key, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromIndexSChar(
    Ptex_PtexMetaData_t * this_
    , int index
    , signed char const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(index, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromKeyShort(
    Ptex_PtexMetaData_t * this_
    , char const * key
    , short const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(key, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromIndexShort(
    Ptex_PtexMetaData_t * this_
    , int index
    , short const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(index, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromKeyInt(
    Ptex_PtexMetaData_t * this_
    , char const * key
    , int const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(key, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromIndexInt(
    Ptex_PtexMetaData_t * this_
    , int index
    , int const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(index, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromKeyFloat(
    Ptex_PtexMetaData_t * this_
    , char const * key
    , float const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(key, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromIndexFloat(
    Ptex_PtexMetaData_t * this_
    , int index
    , float const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(index, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromKeyDouble(
    Ptex_PtexMetaData_t * this_
    , char const * key
    , double const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(key, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData_getValueFromIndexDouble(
    Ptex_PtexMetaData_t * this_
    , int index
    , double const * * value
    , int * count)
{
    try {
        (to_cpp(this_)) -> getValue(index, *(value), *(count));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexMetaData__assign(
    Ptex_PtexMetaData_t * this_
    , Ptex_PtexMetaData_t * * return_
    , Ptex_PtexMetaData_t const * rhs)
{
    try {
        to_c(return_, (to_cpp(this_)) -> operator=(to_cpp_ref(rhs)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFaceData_release(
    Ptex_PtexFaceData_t * this_)
{
    try {
        (to_cpp(this_)) -> release();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFaceData_isConstant(
    Ptex_PtexFaceData_t * this_
    , _Bool * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> isConstant();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFaceData_res(
    Ptex_PtexFaceData_t * this_
    , Ptex_Res_t * return_)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> res());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFaceData_getPixel(
    Ptex_PtexFaceData_t * this_
    , int u
    , int v
    , void * result)
{
    try {
        (to_cpp(this_)) -> getPixel(u, v, result);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFaceData_getData(
    Ptex_PtexFaceData_t * this_
    , void * * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> getData();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFaceData_isTiled(
    Ptex_PtexFaceData_t * this_
    , _Bool * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> isTiled();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFaceData_tileRes(
    Ptex_PtexFaceData_t * this_
    , Ptex_Res_t * return_)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> tileRes());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFaceData_getTile(
    Ptex_PtexFaceData_t * this_
    , Ptex_PtexFaceData_t * * return_
    , int tile)
{
    try {
        to_c(return_, (to_cpp(this_)) -> getTile(tile));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFaceData__assign(
    Ptex_PtexFaceData_t * this_
    , Ptex_PtexFaceData_t * * return_
    , Ptex_PtexFaceData_t const * rhs)
{
    try {
        to_c(return_, (to_cpp(this_)) -> operator=(to_cpp_ref(rhs)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_open(
    Ptex_PtexTexture_t * * return_
    , char const * path
    , std_string_t * error
    , _Bool premultiply)
{
    try {
        to_c(return_, Ptex::v2_4::PtexTexture::open(path, to_cpp_ref(error), premultiply));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_release(
    Ptex_PtexTexture_t * this_)
{
    try {
        (to_cpp(this_)) -> release();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_path(
    Ptex_PtexTexture_t * this_
    , char const * * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> path();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_getInfo(
    Ptex_PtexTexture_t * this_
    , Ptex_PtexTexture_Info_t * return_)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> getInfo());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_meshType(
    Ptex_PtexTexture_t * this_
    , Ptex_MeshType * return_)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> meshType());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_dataType(
    Ptex_PtexTexture_t * this_
    , Ptex_DataType * return_)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> dataType());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_uBorderMode(
    Ptex_PtexTexture_t * this_
    , Ptex_BorderMode * return_)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> uBorderMode());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_vBorderMode(
    Ptex_PtexTexture_t * this_
    , Ptex_BorderMode * return_)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> vBorderMode());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_edgeFilterMode(
    Ptex_PtexTexture_t * this_
    , Ptex_EdgeFilterMode * return_)
{
    try {
        to_c_copy(return_, (to_cpp(this_)) -> edgeFilterMode());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_alphaChannel(
    Ptex_PtexTexture_t * this_
    , int * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> alphaChannel();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_numChannels(
    Ptex_PtexTexture_t * this_
    , int * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> numChannels();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_numFaces(
    Ptex_PtexTexture_t * this_
    , int * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> numFaces();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_hasEdits(
    Ptex_PtexTexture_t * this_
    , _Bool * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> hasEdits();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_hasMipMaps(
    Ptex_PtexTexture_t * this_
    , _Bool * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> hasMipMaps();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_getMetaData(
    Ptex_PtexTexture_t * this_
    , Ptex_PtexMetaData_t * * return_)
{
    try {
        to_c(return_, (to_cpp(this_)) -> getMetaData());
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_getFaceInfo(
    Ptex_PtexTexture_t * this_
    , Ptex_FaceInfo_t const * * return_
    , int faceid)
{
    try {
        to_c(return_, (to_cpp(this_)) -> getFaceInfo(faceid));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_getDataInto(
    Ptex_PtexTexture_t * this_
    , int faceid
    , void * buffer
    , int stride)
{
    try {
        (to_cpp(this_)) -> getData(faceid, buffer, stride);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_getDataIntoWithRes(
    Ptex_PtexTexture_t * this_
    , int faceid
    , void * buffer
    , int stride
    , Ptex_Res_t res)
{
    try {
        (to_cpp(this_)) -> getData(faceid, buffer, stride, to_cpp_ref(&(res)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_getData(
    Ptex_PtexTexture_t * this_
    , Ptex_PtexFaceData_t * * return_
    , int faceid)
{
    try {
        to_c(return_, (to_cpp(this_)) -> getData(faceid));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_getDataWithRes(
    Ptex_PtexTexture_t * this_
    , Ptex_PtexFaceData_t * * return_
    , int faceid
    , Ptex_Res_t res)
{
    try {
        to_c(return_, (to_cpp(this_)) -> getData(faceid, to_cpp_ref(&(res))));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_getPixel(
    Ptex_PtexTexture_t * this_
    , int faceid
    , int u
    , int v
    , float * result
    , int firstchan
    , int nchannels)
{
    try {
        (to_cpp(this_)) -> getPixel(faceid, u, v, result, firstchan, nchannels);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture_getPixelWithRes(
    Ptex_PtexTexture_t * this_
    , int faceid
    , int u
    , int v
    , float * result
    , int firstchan
    , int nchannels
    , Ptex_Res_t res)
{
    try {
        (to_cpp(this_)) -> getPixel(faceid, u, v, result, firstchan, nchannels, to_cpp_ref(&(res)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture__assign(
    Ptex_PtexTexture_t * this_
    , Ptex_PtexTexture_t * * return_
    , Ptex_PtexTexture_t const * rhs)
{
    try {
        to_c(return_, (to_cpp(this_)) -> operator=(to_cpp_ref(rhs)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture__Info_sizeof()
{
        return sizeof(Ptex::v2_4::PtexTexture::Info);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexTexture__Info_alignof()
{
        return alignof(Ptex::v2_4::PtexTexture::Info);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexInputHandler_open(
    Ptex_PtexInputHandler_t * this_
    , void * * return_
    , char const * path)
{
    try {
        *(return_) = (to_cpp(this_)) -> open(path);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexInputHandler_seek(
    Ptex_PtexInputHandler_t * this_
    , void * handle
    , long long pos)
{
    try {
        (to_cpp(this_)) -> seek(handle, pos);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexInputHandler_close(
    Ptex_PtexInputHandler_t * this_
    , _Bool * return_
    , void * handle)
{
    try {
        *(return_) = (to_cpp(this_)) -> close(handle);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexInputHandler_lastError(
    Ptex_PtexInputHandler_t * this_
    , char const * * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> lastError();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexInputHandler__assign(
    Ptex_PtexInputHandler_t * this_
    , Ptex_PtexInputHandler_t * * return_
    , Ptex_PtexInputHandler_t const * rhs)
{
    try {
        to_c(return_, (to_cpp(this_)) -> operator=(to_cpp_ref(rhs)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexErrorHandler_reportError(
    Ptex_PtexErrorHandler_t * this_
    , char const * error)
{
    try {
        (to_cpp(this_)) -> reportError(error);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexErrorHandler__assign(
    Ptex_PtexErrorHandler_t * this_
    , Ptex_PtexErrorHandler_t * * return_
    , Ptex_PtexErrorHandler_t const * rhs)
{
    try {
        to_c(return_, (to_cpp(this_)) -> operator=(to_cpp_ref(rhs)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache_release(
    Ptex_PtexCache_t * this_)
{
    try {
        (to_cpp(this_)) -> release();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache_setSearchPath(
    Ptex_PtexCache_t * this_
    , char const * path)
{
    try {
        (to_cpp(this_)) -> setSearchPath(path);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache_getSearchPath(
    Ptex_PtexCache_t * this_
    , char const * * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> getSearchPath();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache_get(
    Ptex_PtexCache_t * this_
    , Ptex_PtexTexture_t * * return_
    , char const * path
    , std_string_t * error)
{
    try {
        to_c(return_, (to_cpp(this_)) -> get(path, to_cpp_ref(error)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache_purge(
    Ptex_PtexCache_t * this_
    , Ptex_PtexTexture_t * texture)
{
    try {
        (to_cpp(this_)) -> purge(to_cpp(texture));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache_purgePath(
    Ptex_PtexCache_t * this_
    , char const * path)
{
    try {
        (to_cpp(this_)) -> purge(path);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache_purgeAll(
    Ptex_PtexCache_t * this_)
{
    try {
        (to_cpp(this_)) -> purgeAll();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache_getStats(
    Ptex_PtexCache_t * this_
    , Ptex_PtexCache_Stats_t * stats)
{
    try {
        (to_cpp(this_)) -> getStats(to_cpp_ref(stats));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache__assign(
    Ptex_PtexCache_t * this_
    , Ptex_PtexCache_t * * return_
    , Ptex_PtexCache_t const * rhs)
{
    try {
        to_c(return_, (to_cpp(this_)) -> operator=(to_cpp_ref(rhs)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache__Stats_sizeof()
{
        return sizeof(Ptex::v2_4::PtexCache::Stats);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexCache__Stats_alignof()
{
        return alignof(Ptex::v2_4::PtexCache::Stats);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_open(
    Ptex_PtexWriter_t * * return_
    , char const * path
    , Ptex_MeshType mt
    , Ptex_DataType dt
    , int nchannels
    , int alphachan
    , int nfaces
    , std_string_t * error
    , _Bool genmipmaps)
{
    try {
        to_c(return_, Ptex::v2_4::PtexWriter::open(path, Ptex_MeshType_to_cpp_ref(&(mt)), Ptex_DataType_to_cpp_ref(&(dt)), nchannels, alphachan, nfaces, to_cpp_ref(error), genmipmaps));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_edit(
    Ptex_PtexWriter_t * * return_
    , char const * path
    , _Bool incremental
    , Ptex_MeshType mt
    , Ptex_DataType dt
    , int nchannels
    , int alphachan
    , int nfaces
    , std_string_t * error
    , _Bool genmipmaps)
{
    try {
        to_c(return_, Ptex::v2_4::PtexWriter::edit(path, incremental, Ptex_MeshType_to_cpp_ref(&(mt)), Ptex_DataType_to_cpp_ref(&(dt)), nchannels, alphachan, nfaces, to_cpp_ref(error), genmipmaps));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_applyEdits(
    _Bool * return_
    , char const * path
    , std_string_t * error)
{
    try {
        *(return_) = Ptex::v2_4::PtexWriter::applyEdits(path, to_cpp_ref(error));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_release(
    Ptex_PtexWriter_t * this_)
{
    try {
        (to_cpp(this_)) -> release();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_setBorderModes(
    Ptex_PtexWriter_t * this_
    , Ptex_BorderMode uBorderMode
    , Ptex_BorderMode vBorderMode)
{
    try {
        (to_cpp(this_)) -> setBorderModes(Ptex_BorderMode_to_cpp_ref(&(uBorderMode)), Ptex_BorderMode_to_cpp_ref(&(vBorderMode)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_setEdgeFilterMode(
    Ptex_PtexWriter_t * this_
    , Ptex_EdgeFilterMode edgeFilterMode)
{
    try {
        (to_cpp(this_)) -> setEdgeFilterMode(Ptex_EdgeFilterMode_to_cpp_ref(&(edgeFilterMode)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_writeMetaString(
    Ptex_PtexWriter_t * this_
    , char const * key
    , char const * string)
{
    try {
        (to_cpp(this_)) -> writeMeta(key, string);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_writeMetaChar(
    Ptex_PtexWriter_t * this_
    , char const * key
    , signed char const * value
    , int count)
{
    try {
        (to_cpp(this_)) -> writeMeta(key, value, count);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_writeMetaShort(
    Ptex_PtexWriter_t * this_
    , char const * key
    , short const * value
    , int count)
{
    try {
        (to_cpp(this_)) -> writeMeta(key, value, count);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_writeMetaInt(
    Ptex_PtexWriter_t * this_
    , char const * key
    , int const * value
    , int count)
{
    try {
        (to_cpp(this_)) -> writeMeta(key, value, count);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_writeMetaFloat(
    Ptex_PtexWriter_t * this_
    , char const * key
    , float const * value
    , int count)
{
    try {
        (to_cpp(this_)) -> writeMeta(key, value, count);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_writeMetaDouble(
    Ptex_PtexWriter_t * this_
    , char const * key
    , double const * value
    , int count)
{
    try {
        (to_cpp(this_)) -> writeMeta(key, value, count);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_writeMeta(
    Ptex_PtexWriter_t * this_
    , Ptex_PtexMetaData_t * data)
{
    try {
        (to_cpp(this_)) -> writeMeta(to_cpp(data));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_writeFace(
    Ptex_PtexWriter_t * this_
    , _Bool * return_
    , int faceid
    , Ptex_FaceInfo_t const * info
    , void const * data
    , int stride)
{
    try {
        *(return_) = (to_cpp(this_)) -> writeFace(faceid, to_cpp_ref(info), data, stride);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_writeConstantFace(
    Ptex_PtexWriter_t * this_
    , _Bool * return_
    , int faceid
    , Ptex_FaceInfo_t const * info
    , void const * data)
{
    try {
        *(return_) = (to_cpp(this_)) -> writeConstantFace(faceid, to_cpp_ref(info), data);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter_close(
    Ptex_PtexWriter_t * this_
    , _Bool * return_
    , std_string_t * error)
{
    try {
        *(return_) = (to_cpp(this_)) -> close(to_cpp_ref(error));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexWriter__assign(
    Ptex_PtexWriter_t * this_
    , Ptex_PtexWriter_t * * return_
    , Ptex_PtexWriter_t const * rhs)
{
    try {
        to_c(return_, (to_cpp(this_)) -> operator=(to_cpp_ref(rhs)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFilter_getFilter(
    Ptex_PtexFilter_t * * return_
    , Ptex_PtexTexture_t * tx
    , Ptex_PtexFilter_Options_t const * opts)
{
    try {
        to_c(return_, Ptex::v2_4::PtexFilter::getFilter(to_cpp(tx), to_cpp_ref(opts)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFilter_release(
    Ptex_PtexFilter_t * this_)
{
    try {
        (to_cpp(this_)) -> release();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFilter_eval(
    Ptex_PtexFilter_t * this_
    , float * result
    , int firstchan
    , int nchannels
    , int faceid
    , float u
    , float v
    , float uw1
    , float vw1
    , float uw2
    , float vw2
    , float width
    , float blur)
{
    try {
        (to_cpp(this_)) -> eval(result, firstchan, nchannels, faceid, u, v, uw1, vw1, uw2, vw2, width, blur);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFilter__assign(
    Ptex_PtexFilter_t * this_
    , Ptex_PtexFilter_t * * return_
    , Ptex_PtexFilter_t const * rhs)
{
    try {
        to_c(return_, (to_cpp(this_)) -> operator=(to_cpp_ref(rhs)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFilter__Options_sizeof()
{
        return sizeof(Ptex::v2_4::PtexFilter::Options);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFilter__Options_alignof()
{
        return alignof(Ptex::v2_4::PtexFilter::Options);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexFilter__Options_ctor(
    Ptex_PtexFilter_Options_t * this_
    , Ptex_PtexFilter_FilterType filter_
    , _Bool lerp_
    , float sharpness_
    , _Bool noedgeblend_)
{
    try {
        new (this_) Ptex::v2_4::PtexFilter::Options(Ptex_PtexFilter_FilterType_to_cpp_ref(&(filter_)), lerp_, sharpness_, noedgeblend_);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_MeshTypeName(
    char const * * return_
    , Ptex_MeshType mt)
{
    try {
        *(return_) = Ptex::v2_4::MeshTypeName(Ptex_MeshType_to_cpp_ref(&(mt)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_DataTypeName(
    char const * * return_
    , Ptex_DataType dt)
{
    try {
        *(return_) = Ptex::v2_4::DataTypeName(Ptex_DataType_to_cpp_ref(&(dt)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_BorderModeName(
    char const * * return_
    , Ptex_BorderMode m)
{
    try {
        *(return_) = Ptex::v2_4::BorderModeName(Ptex_BorderMode_to_cpp_ref(&(m)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_EdgeFilterModeName(
    char const * * return_
    , Ptex_EdgeFilterMode m)
{
    try {
        *(return_) = Ptex::v2_4::EdgeFilterModeName(Ptex_EdgeFilterMode_to_cpp_ref(&(m)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_EdgeIdName(
    char const * * return_
    , Ptex_EdgeId eid)
{
    try {
        *(return_) = Ptex::v2_4::EdgeIdName(Ptex_EdgeId_to_cpp_ref(&(eid)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_MetaDataTypeName(
    char const * * return_
    , Ptex_MetaDataType mdt)
{
    try {
        *(return_) = Ptex::v2_4::MetaDataTypeName(Ptex_MetaDataType_to_cpp_ref(&(mdt)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_DataSize(
    int * return_
    , Ptex_DataType dt)
{
    try {
        *(return_) = Ptex::v2_4::DataSize(Ptex_DataType_to_cpp_ref(&(dt)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_OneValue(
    float * return_
    , Ptex_DataType dt)
{
    try {
        *(return_) = Ptex::v2_4::OneValue(Ptex_DataType_to_cpp_ref(&(dt)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_OneValueInv(
    float * return_
    , Ptex_DataType dt)
{
    try {
        *(return_) = Ptex::v2_4::OneValueInv(Ptex_DataType_to_cpp_ref(&(dt)));
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_ConvertToFloat(
    float * dst
    , void const * src
    , Ptex_DataType dt
    , int numChannels)
{
    try {
        Ptex::v2_4::ConvertToFloat(dst, src, Ptex_DataType_to_cpp_ref(&(dt)), numChannels);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex_v2_4_ConvertFromFloat(
    void * dst
    , float const * src
    , Ptex_DataType dt
    , int numChannels)
{
    try {
        Ptex::v2_4::ConvertFromFloat(dst, src, Ptex_DataType_to_cpp_ref(&(dt)), numChannels);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

