#include "c-ptex_half_private.h"

#include <new>

#include <stdexcept>

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_sizeof()
{
        return sizeof(Ptex::v2_4::PtexHalf);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_alignof()
{
        return alignof(Ptex::v2_4::PtexHalf);
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_default(
    Ptex_PtexHalf_t * this_)
{
    try {
        new (this_) Ptex::v2_4::PtexHalf();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_from_f32(
    Ptex_PtexHalf_t * this_
    , float val)
{
    try {
        new (this_) Ptex::v2_4::PtexHalf(val);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_from_f64(
    Ptex_PtexHalf_t * this_
    , double val)
{
    try {
        new (this_) Ptex::v2_4::PtexHalf(val);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_as_f32(
    Ptex_PtexHalf_t const * this_
    , float * return_)
{
    try {
        *(return_) = (to_cpp(this_)) -> operator float();
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_toFloat(
    float * return_
    , unsigned short h)
{
    try {
        *(return_) = Ptex::v2_4::PtexHalf::toFloat(h);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_fromFloat(
    unsigned short * return_
    , float val)
{
    try {
        *(return_) = Ptex::v2_4::PtexHalf::fromFloat(val);
        return 0;
    } catch (std::exception& e) {
        TLG_EXCEPTION_STRING = e.what();
        return -1;
    }
}

