#pragma once
#include "ptex-api-export.h"


#ifdef __cplusplus
extern "C" {
#endif

/** 
   @class PtexHalf
   @brief Half-precision (16-bit) floating-point type.

   This type should be compatible with opengl, openexr, and IEEE 754r.
   The range is [-65504.0, 65504.0] and the precision is about 1 part
   in 2000 (3.3 decimal places).

   From OpenGL spec 2.1.2:

   A 16-bit floating-point number has a 1-bit sign (S), a 5-bit
   exponent (E), and a 10-bit mantissa (M).  The value of a 16-bit
   floating-point number is determined by the following:

   \verbatim
        (-1)^S * 0.0,                        if E == 0 and M == 0,
        (-1)^S * 2^-14 * (M/2^10),           if E == 0 and M != 0,
        (-1)^S * 2^(E-15) * (1 + M/2^10),    if 0 < E < 31,
        (-1)^S * INF,                        if E == 31 and M == 0, or
        NaN,                                 if E == 31 and M != 0 \endverbatim */
typedef struct Ptex__v2_4__PtexHalf_t_s {
    char data[%SIZEPtex::v2_4::PtexHalf%];
} PTEX_CPPMM_ALIGN(%ALIGNPtex::v2_4::PtexHalf%) Ptex__v2_4__PtexHalf_t;
typedef Ptex__v2_4__PtexHalf_t Ptex_PtexHalf_t;


/** returns the size of this type in bytes */
PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_sizeof();
#define Ptex_PtexHalf_sizeof Ptex__v2_4__PtexHalf_sizeof


/** returns the size of this type in bytes */
PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_alignof();
#define Ptex_PtexHalf_alignof Ptex__v2_4__PtexHalf_alignof


/** Default constructor, value is undefined */
PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_default(
    Ptex_PtexHalf_t * this_);
#define Ptex_PtexHalf_default Ptex__v2_4__PtexHalf_default


PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_from_f32(
    Ptex_PtexHalf_t * this_
    , float val);
#define Ptex_PtexHalf_from_f32 Ptex__v2_4__PtexHalf_from_f32


PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_from_f64(
    Ptex_PtexHalf_t * this_
    , double val);
#define Ptex_PtexHalf_from_f64 Ptex__v2_4__PtexHalf_from_f64


PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_as_f32(
    Ptex_PtexHalf_t const * this_
    , float * return_);
#define Ptex_PtexHalf_as_f32 Ptex__v2_4__PtexHalf_as_f32


PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_toFloat(
    float * return_
    , unsigned short h);
#define Ptex_PtexHalf_toFloat Ptex__v2_4__PtexHalf_toFloat


PTEX_CPPMM_API unsigned int Ptex__v2_4__PtexHalf_fromFloat(
    unsigned short * return_
    , float val);
#define Ptex_PtexHalf_fromFloat Ptex__v2_4__PtexHalf_fromFloat


#ifdef __cplusplus
}
#endif
