//! BIOS kernel functions
//!
//! These are wrappers for calling BIOS functions directly.
// This file was automatically generated by gen_bios_mod.rs

core::arch::global_asm!(include_str!("trampoline.s"));

extern "C" {
    /// Calls BIOS function [A(00h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn file_open(filename: *const i8, accessmode: u32) -> i8;
    /// Calls BIOS function [A(01h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn file_seek(fd: i8, offset: u32, seektype: u8) -> i32;
    /// Calls BIOS function [A(02h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn file_read(fd: i8, dst: *mut u32, length: usize) -> i32;
    /// Calls BIOS function [A(03h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn file_write(fd: i8, src: *const u32, length: usize) -> i32;
    /// Calls BIOS function [A(04h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn file_close(fd: i8) -> i8;
    /// Calls BIOS function [A(06h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn exit(exitcode: i32) -> !;
    /// Calls BIOS function [A(13h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn save_state(buf: *mut u8);
    /// Calls BIOS function [A(14h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn restore_state(buf: *const u8, ret_val: u32);
    /// Calls BIOS function [A(2Fh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn rand() -> u16;
    /// Calls BIOS function [A(30h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn srand(seed: u32);
    /// Calls BIOS function [A(33h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn malloc(size: usize) -> *mut u8;
    /// Calls BIOS function [A(34h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn free(buf: *mut u8);
    /// Calls BIOS function [A(37h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn calloc(sizex: usize, sizey: usize) -> *const u8;
    /// Calls BIOS function [A(38h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn realloc(old_buf: *const u8, new_size: usize);
    /// Calls BIOS function [A(39h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn init_heap(addr: usize, size: usize);
    /// Calls BIOS function [A(3Ah)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn system_error_exit(exitcode: i32) -> !;
    /// Calls BIOS function [A(3Eh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn std_out_puts(msg: *const i8);
    /// Calls BIOS function [A(3Fh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn printf(msg: *const i8, ...);
    /// Calls BIOS function [A(41h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn load_exe_header(filename: *const i8, headerbuf: *mut u8);
    /// Calls BIOS function [A(42h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn load_exe_file(filename: *const i8, headerbuf: *mut u8);
    /// Calls BIOS function [A(43h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn do_execute(headerbuf: *mut u8, param1: u32, param2: u32);
    /// Calls BIOS function [A(44h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn flush_cache();
    /// Calls BIOS function [A(47h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn gpu_send_dma(xdst: u16, ydst: u16, xsiz: u16, ysize: u16, src: u32);
    /// Calls BIOS function [A(48h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn gp1_command(cmd: u32);
    /// Calls BIOS function [A(49h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn gp0_command(cmd: u32);
    /// Calls BIOS function [A(4Ah)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn gp0_command_params(src: *const u32, num: usize);
    /// Calls BIOS function [A(4Dh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn gpu_get_status() -> u32;
    /// Calls BIOS function [A(4Eh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn gpu_sync() -> i32;
    /// Calls BIOS function [A(51h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn load_and_execute(filename: *const i8, stackbase: u32, stackoffset: u32);
    /// Calls BIOS function [A(54h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn cd_init();
    /// Calls BIOS function [A(56h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn cd_remove();
    /// Calls BIOS function [A(7Ch)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn cd_async_get_status(dst: *mut u32);
    /// Calls BIOS function [A(96h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn add_cdrom_device();
    /// Calls BIOS function [A(9Fh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn set_memsize(megabytes: u8);
    /// Calls BIOS function [A(A0h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn warm_boot() -> !;
    /// Calls BIOS function [A(A4h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn cd_get_lbn(filename: *const i8) -> i32;
    /// Calls BIOS function [A(A6h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn cd_get_status(dst: *mut u32);
    /// Calls BIOS function [A(B4h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn get_system_info(index: u8) -> u32;
    /// Calls BIOS function [B(03h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn get_timer(t: u32);
    /// Calls BIOS function [B(04h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn enable_timer_irq(t: u32);
    /// Calls BIOS function [B(05h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn disable_timer_irq(t: u32);
    /// Calls BIOS function [B(06h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn restart_timer(t: u32);
    /// Calls BIOS function [B(07h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn deliver_event(class: u32, spec: u16);
    /// Calls BIOS function [B(08h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn open_event(class: u32, spec: u16, mode: u16, func: *const u32) -> u32;
    /// Calls BIOS function [B(09h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn close_event(event: u32);
    /// Calls BIOS function [B(0Ah)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn wait_event(event: u32) -> bool;
    /// Calls BIOS function [B(0Bh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn test_event(event: u32) -> bool;
    /// Calls BIOS function [B(0Ch)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn enable_event(event: u32);
    /// Calls BIOS function [B(0Dh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn disable_event(event: u32);
    /// Calls BIOS function [B(0Eh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn open_thread(pc: usize, sp: usize, gp: usize) -> u32;
    /// Calls BIOS function [B(0Fh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn close_thread(handle: u32);
    /// Calls BIOS function [B(10h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn change_thread(handle: u32);
    /// Calls BIOS function [B(12h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn init_pad(buf1: *mut u8, siz1: usize, buf2: *mut u8, siz2: usize);
    /// Calls BIOS function [B(13h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn start_pad();
    /// Calls BIOS function [B(14h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn stop_pad();
    /// Calls BIOS function [B(18h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn set_default_exit_from_exception();
    /// Calls BIOS function [B(20h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn undeliver_event(class: u32, spec: u16);
    /// Calls BIOS function [B(44h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn file_rename(old_filename: *const i8, new_filename: *const i8) -> bool;
    /// Calls BIOS function [B(45h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn file_delete(filename: *const i8) -> bool;
    /// Calls BIOS function [B(46h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn file_undelete(filename: *const i8) -> bool;
    /// Calls BIOS function [B(49h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn print_installed_devices();
    /// Calls BIOS function [B(4Ah)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn init_card(pad_enable: bool);
    /// Calls BIOS function [B(4Bh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn start_card();
    /// Calls BIOS function [B(4Ch)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn stop_card();
    /// Calls BIOS function [B(54h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn get_last_error() -> u32;
    /// Calls BIOS function [B(55h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn get_last_file_error(fd: i8) -> u32;
    /// Calls BIOS function [B(5Bh)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn change_clear_pad(int: u32);
    /// Calls BIOS function [C(0Ah)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn change_clear_rcnt(t: u32, flag: bool) -> bool;
    /// Calls BIOS function [C(13h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn flush_std_in_out_put();
    /// Calls BIOS function [SYS(01h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn enter_critical_section() -> bool;
    /// Calls BIOS function [SYS(02h)](http://problemkaputt.de/psx-spx.htm#biosfunctionsummary)
    pub fn exit_critical_section();
}
