# Common

LEN = packet length (4 bytes = u32)

Response frames:

* 0x00 - NOP (should be sent every N < timeout seconds to make sure the socket
  is alive)
* 0x01 - OK
* 0x02 - OK WAIT (waiting for data)
* 0xE0 - Not required
* 0xFE - Access denied
* 0xFF - ERROR

Data sockets usually use the same port as control ones

Priority byte is not used at the moment (reserved for the future) and should be
always 0x7F.

## Control socket

### Greetings

Client: 0xEE 0xAA <0x00 / 0x01 for STARTTLS>
Server: sets mode or disconnects
Server (4 byte): EE AA XX XX (XX XX - proto version)
Client: LEN LOGIN\x0PASSWORD (for anonymous login send (LEN=1) \x0 only)
Server: 32 bytes (*client token)

### Subscribe

Client: 

0x02 LEN TOPIC (or multiple topics splitted by 0x00)

Server:

OK/ERROR

### Unsubscribe

Client:

0x03 LEN TOPIC (or multiple topics splitted by 0x00)

Server:

OK/ERROR

### Publish

Client:

0x01 PRI(u8=7F) LEN TOPIC \x0 MESSAGE

Server:

OK/ERROR

### Publish if subscribed (replicate)

Client:

0x11 LEN TOPIC

Server:

OK_WAIT/ERROR/NOT_REQ

Client (if required)

PRI(u8=7F) TIMESTAMP(u64, ns) LEN MESSAGE

### Bye

Client

0xFF

Server: closes socket

## Data socket

Client: 0xEE 0xAB <0x00 / 0x01 for STARTTLS>
Server: sets mode or disconnects
Server (4 byte): EE AB XX XX (XX XX - proto version)
Client: 32 bytes (hash) TIMEOUT_SEC (u8)
Server: OK or closes the socket

Server:

\x01 PRI(u8=7F) LEN TOPIC\x0MESSAGE

Server will also send beacon messages with TIMEOUT/2 interval

Data socket MUST be forcibly disconnected by the server when the client is
disconnected from the control socket.

### UDP

Client:

EE AA 01 00 LOGIN 00 PASSWORD 00 0x01/0x12 PRIO TOPIC 00 DATA

Server:

OK (for 0x01) or silently accepts the message
