pub(crate) fn assert_keep<Item: crate::Item + std::cmp::Ord + std::fmt::Debug>(
	config: &crate::Config<Item::Period>,
	candidates: impl IntoIterator<Item=Item> + Clone,
	saved: impl IntoIterator<Item=Item>,
) {
	let mut actual = candidates.clone().into_iter().collect::<std::collections::BTreeSet<_>>();
	let expected = saved.into_iter().collect::<std::collections::BTreeSet<_>>();

	for evicted in crate::prune(config, candidates) {
		assert!(actual.remove(&evicted), "{:?} was evicted twice.", evicted);
	}

	assert_eq!(actual, expected);
}
