use clap::ArgMatches;

use super::Matcher;
use crate::cmd::arg::{ArgStore, CmdArgOption};

/// The init command matcher.
pub struct InitMatcher<'a> {
    matches: &'a ArgMatches,
}

impl<'a: 'b, 'b> InitMatcher<'a> {
    /// The store.
    pub fn store(&self) -> String {
        ArgStore::value(self.matches)
    }
}

impl<'a> Matcher<'a> for InitMatcher<'a> {
    fn with(matches: &'a ArgMatches) -> Option<Self> {
        matches
            .subcommand_matches("init")
            .map(|matches| InitMatcher { matches })
    }
}
