#[derive(Debug, Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
#[repr(transparent)]
pub struct Protect<T> {
    value: T,
}

#[allow(clippy::missing_safety_doc)]
impl<T> Protect<T> {
    pub unsafe fn new_unchecked(value: T) -> Protect<T> {
        Protect { value }
    }

    pub unsafe fn get_unchecked(&self) -> &T {
        &self.value
    }

    #[allow(clippy::wrong_self_convention)]
    pub unsafe fn get_unchecked_mut(&mut self) -> &mut T {
        &mut self.value
    }

    pub unsafe fn into_inner_unchecked(self) -> T {
        self.value
    }
}

impl<T> Protect<T> {
    pub fn new<P: Permit<T>>(permit: &mut P, value: T) -> Option<Protect<T>> {
        permit.new(value)
    }

    pub fn get<P: Permit<T>>(&self, permit: &mut P) -> Option<&T> {
        permit.get(self)
    }

    #[allow(clippy::wrong_self_convention)]
    pub fn get_mut<P: Permit<T>>(&mut self, permit: &mut P) -> Option<&mut T> {
        permit.get_mut(self)
    }

    #[allow(clippy::wrong_self_convention)]
    pub fn into_inner<P: Permit<T>>(self, permit: &mut P) -> Option<T> {
        permit.into_inner(self)
    }
}

pub trait Permit<T> {
    #[allow(clippy::new_ret_no_self)]
    fn new(&mut self, value: T) -> Option<Protect<T>>;

    fn get<'protect>(&mut self, value: &'protect Protect<T>) -> Option<&'protect T>;

    #[allow(clippy::wrong_self_convention)]
    fn get_mut<'protect>(&mut self, value: &'protect mut Protect<T>) -> Option<&'protect mut T>;

    #[allow(clippy::wrong_self_convention)]
    fn into_inner(&mut self, value: Protect<T>) -> Option<T>;
}
