use num_traits::{real::Real, One, Zero};

pub trait Projective<T>
where
    Self: Sized,
    T: Zero + One + Real,
{
    fn transform(self, matrix: &[T; 9]) -> Self;
    #[rustfmt::skip]
    fn rotate(self, angle: T) -> Self {
        self.transform(&[
             angle.cos(), angle.sin(), T::zero(),
            -angle.sin(), angle.cos(), T::zero(),
             T::zero(),   T::zero(),   T::one(),
        ])
    }
    #[rustfmt::skip]
    fn translate(self, x: T, y: T) -> Self {
        self.transform(&[
            T::one(), T::zero(), x,
            T::zero(), T::one(), y,
            T::zero(), T::zero(), T::one(),
        ])
    }
    #[rustfmt::skip]
    fn scale(self, x: T, y: T) -> Self {
        self.transform(&[
            x,         T::zero(), T::zero(),
            T::zero(), y,         T::zero(),
            T::zero(), T::zero(), T::one(),
        ])
    }
    #[rustfmt::skip]
    fn reflect(self, x: T, y: T) -> Self {
        self.transform(&[
            T::one(),  T::zero(), T::zero(),
            T::zero(), T::one(),  T::zero(),
            x,         y,         T::one(),
        ])
    }
    #[rustfmt::skip]
    fn skew(self, x: T, y: T) -> Self {
        self.transform(&[
            T::one(),  x,         T::zero(),
            y,         T::one(),  T::zero(),
            T::zero(), T::zero(), T::one(),
        ])
    }
}
