#[derive(Debug)]
pub struct Image {
    width: u32,
    height: u32,
    pixels: std::vec::Vec<std::vec::Vec<Pixel>>,
    data: std::vec::Vec<u8>,
}

impl Image {
    pub fn new(width: u32, height: u32, buffer: &[u8]) -> Image {
        let mut data: std::vec::Vec<u8> = std::vec::Vec::new();

        for b in buffer {
            data.push(*b);
        }

        let pixels = Image::construct_pixel_data(width, height, &data);

        return Image{width: width, height: height, data: data, pixels: pixels};
    }

    pub fn get_pixel(&self, x: usize, y: usize) -> &Pixel {
        return self.pixels.get(x).unwrap().get(y).unwrap();
    }

    fn construct_pixel_data(width: u32, height: u32, data: &std::vec::Vec<u8>) -> std::vec::Vec<std::vec::Vec<Pixel>> {
        let mut pixels: std::vec::Vec<std::vec::Vec<Pixel>> = std::vec::Vec::new();

        for i in 0..height {
            pixels.push(std::vec::Vec::new());

            for j in 0..width {
                let r_index = (i*height+j) as usize;
                let g_index = (i*height+j+1) as usize;
                let b_index = (i*height+j+2) as usize;
                let pixel = Pixel::new(data[r_index], data[g_index], data[b_index]);

                pixels[i as usize].push(pixel);
            }
        }

        return pixels
    }
}

#[derive(Debug)]
pub struct Pixel {
    rgb_data: std::vec::Vec<u8>
}

impl Pixel {
    pub fn new(r: u8, g: u8, b:u8) -> Pixel {
        Pixel{rgb_data: vec!(r, g, b)}
    }
}