/* This file contains bindings for dlyd functions not included in the mach crate.
(specifically dyld_image_info, dyld_all_image_infos structs, mach_header_64 and segment_command_64 structs)

This file is generated with bindgen by going
    bindgen /Library/Developer/CommandLineTools/SDKs/MacOSX12.1.sdk/usr/include/mach-o/dyld_images.h --with-derive-default --whitelist-type dyld_all_image_infos --whitelist-type dyld_image_info > src/mac_maps/dyld_bindings.rs
    bindgen /Library/Developer/CommandLineTools/SDKs/MacOSX12.1.sdk/usr/include/mach-o/loader.h --with-derive-default --whitelist-type mach_header_64 --whitelist-type segment_command --whitelist-type segment_command_64 >> src/mac_maps/dyld_bindings.rs
    bindgen /Library/Developer/CommandLineTools/SDKs/MacOSX12.1.sdk/usr/include/mach/task_info.h --with-derive-default --whitelist-type task_dyld_info >> dyld_bindings.rs
*/
#![allow(dead_code)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(deref_nullptr)]
#![allow(unaligned_references)]

/* automatically generated by rust-bindgen 0.59.2 */

pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type size_t = __darwin_size_t;
pub type uuid_t = __darwin_uuid_t;
pub type mach_port_t = __darwin_mach_port_t;
pub const dyld_image_mode_dyld_image_adding: dyld_image_mode = 0;
pub const dyld_image_mode_dyld_image_removing: dyld_image_mode = 1;
pub const dyld_image_mode_dyld_image_info_change: dyld_image_mode = 2;
pub type dyld_image_mode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dyld_image_info {
    pub imageLoadAddress: *mut mach_header,
    pub imageFilePath: *const ::std::os::raw::c_char,
    pub imageFileModDate: usize,
}
#[test]
fn bindgen_test_layout_dyld_image_info() {
    assert_eq!(
        ::std::mem::size_of::<dyld_image_info>(),
        24usize,
        concat!("Size of: ", stringify!(dyld_image_info))
    );
    assert_eq!(
        ::std::mem::align_of::<dyld_image_info>(),
        8usize,
        concat!("Alignment of ", stringify!(dyld_image_info))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_image_info>())).imageLoadAddress as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_image_info),
            "::",
            stringify!(imageLoadAddress)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_image_info>())).imageFilePath as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_image_info),
            "::",
            stringify!(imageFilePath)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_image_info>())).imageFileModDate as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_image_info),
            "::",
            stringify!(imageFileModDate)
        )
    );
}
impl Default for dyld_image_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dyld_uuid_info {
    pub imageLoadAddress: *const mach_header,
    pub imageUUID: uuid_t,
}
#[test]
fn bindgen_test_layout_dyld_uuid_info() {
    assert_eq!(
        ::std::mem::size_of::<dyld_uuid_info>(),
        24usize,
        concat!("Size of: ", stringify!(dyld_uuid_info))
    );
    assert_eq!(
        ::std::mem::align_of::<dyld_uuid_info>(),
        8usize,
        concat!("Alignment of ", stringify!(dyld_uuid_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_uuid_info>())).imageLoadAddress as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_uuid_info),
            "::",
            stringify!(imageLoadAddress)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_uuid_info>())).imageUUID as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_uuid_info),
            "::",
            stringify!(imageUUID)
        )
    );
}
impl Default for dyld_uuid_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dyld_aot_image_info {
    pub x86LoadAddress: *const mach_header,
    pub aotLoadAddress: *const mach_header,
    pub aotImageSize: u64,
    pub aotImageKey: [u8; 32usize],
}
#[test]
fn bindgen_test_layout_dyld_aot_image_info() {
    assert_eq!(
        ::std::mem::size_of::<dyld_aot_image_info>(),
        56usize,
        concat!("Size of: ", stringify!(dyld_aot_image_info))
    );
    assert_eq!(
        ::std::mem::align_of::<dyld_aot_image_info>(),
        8usize,
        concat!("Alignment of ", stringify!(dyld_aot_image_info))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_aot_image_info>())).x86LoadAddress as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_aot_image_info),
            "::",
            stringify!(x86LoadAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_aot_image_info>())).aotLoadAddress as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_aot_image_info),
            "::",
            stringify!(aotLoadAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_aot_image_info>())).aotImageSize as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_aot_image_info),
            "::",
            stringify!(aotImageSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_aot_image_info>())).aotImageKey as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_aot_image_info),
            "::",
            stringify!(aotImageKey)
        )
    );
}
impl Default for dyld_aot_image_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type dyld_image_notifier = ::std::option::Option<
    unsafe extern "C" fn(mode: dyld_image_mode, infoCount: u32, info: *const dyld_image_info),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dyld_all_image_infos {
    pub version: u32,
    pub infoArrayCount: u32,
    pub infoArray: *const dyld_image_info,
    pub notification: dyld_image_notifier,
    pub processDetachedFromSharedRegion: bool,
    pub libSystemInitialized: bool,
    pub dyldImageLoadAddress: *const mach_header,
    pub jitInfo: *mut ::std::os::raw::c_void,
    pub dyldVersion: *const ::std::os::raw::c_char,
    pub errorMessage: *const ::std::os::raw::c_char,
    pub terminationFlags: usize,
    pub coreSymbolicationShmPage: *mut ::std::os::raw::c_void,
    pub systemOrderFlag: usize,
    pub uuidArrayCount: usize,
    pub uuidArray: *const dyld_uuid_info,
    pub dyldAllImageInfosAddress: *mut dyld_all_image_infos,
    pub initialImageCount: usize,
    pub errorKind: usize,
    pub errorClientOfDylibPath: *const ::std::os::raw::c_char,
    pub errorTargetDylibPath: *const ::std::os::raw::c_char,
    pub errorSymbol: *const ::std::os::raw::c_char,
    pub sharedCacheSlide: usize,
    pub sharedCacheUUID: [u8; 16usize],
    pub sharedCacheBaseAddress: usize,
    pub infoArrayChangeTimestamp: u64,
    pub dyldPath: *const ::std::os::raw::c_char,
    pub notifyPorts: [mach_port_t; 8usize],
    pub reserved: [usize; 7usize],
    pub sharedCacheFSID: u64,
    pub sharedCacheFSObjID: u64,
    pub compact_dyld_image_info_addr: usize,
    pub compact_dyld_image_info_size: size_t,
    pub platform: u32,
    pub aotInfoCount: u32,
    pub aotInfoArray: *const dyld_aot_image_info,
    pub aotInfoArrayChangeTimestamp: u64,
    pub aotSharedCacheBaseAddress: usize,
    pub aotSharedCacheUUID: [u8; 16usize],
}
#[test]
fn bindgen_test_layout_dyld_all_image_infos() {
    assert_eq!(
        ::std::mem::size_of::<dyld_all_image_infos>(),
        368usize,
        concat!("Size of: ", stringify!(dyld_all_image_infos))
    );
    assert_eq!(
        ::std::mem::align_of::<dyld_all_image_infos>(),
        8usize,
        concat!("Alignment of ", stringify!(dyld_all_image_infos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_all_image_infos>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).infoArrayCount as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(infoArrayCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_all_image_infos>())).infoArray as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(infoArray)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).notification as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(notification)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).processDetachedFromSharedRegion
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(processDetachedFromSharedRegion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).libSystemInitialized as *const _
                as usize
        },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(libSystemInitialized)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).dyldImageLoadAddress as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(dyldImageLoadAddress)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_all_image_infos>())).jitInfo as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(jitInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).dyldVersion as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(dyldVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).errorMessage as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(errorMessage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).terminationFlags as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(terminationFlags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).coreSymbolicationShmPage as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(coreSymbolicationShmPage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).systemOrderFlag as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(systemOrderFlag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).uuidArrayCount as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(uuidArrayCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_all_image_infos>())).uuidArray as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(uuidArray)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).dyldAllImageInfosAddress as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(dyldAllImageInfosAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).initialImageCount as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(initialImageCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_all_image_infos>())).errorKind as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(errorKind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).errorClientOfDylibPath as *const _
                as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(errorClientOfDylibPath)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).errorTargetDylibPath as *const _
                as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(errorTargetDylibPath)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).errorSymbol as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(errorSymbol)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).sharedCacheSlide as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(sharedCacheSlide)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).sharedCacheUUID as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(sharedCacheUUID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).sharedCacheBaseAddress as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(sharedCacheBaseAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).infoArrayChangeTimestamp as *const _
                as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(infoArrayChangeTimestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_all_image_infos>())).dyldPath as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(dyldPath)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).notifyPorts as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(notifyPorts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_all_image_infos>())).reserved as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).sharedCacheFSID as *const _ as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(sharedCacheFSID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).sharedCacheFSObjID as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(sharedCacheFSObjID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).compact_dyld_image_info_addr
                as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(compact_dyld_image_info_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).compact_dyld_image_info_size
                as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(compact_dyld_image_info_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dyld_all_image_infos>())).platform as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(platform)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).aotInfoCount as *const _ as usize
        },
        324usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(aotInfoCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).aotInfoArray as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(aotInfoArray)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).aotInfoArrayChangeTimestamp as *const _
                as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(aotInfoArrayChangeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).aotSharedCacheBaseAddress as *const _
                as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(aotSharedCacheBaseAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dyld_all_image_infos>())).aotSharedCacheUUID as *const _ as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_all_image_infos),
            "::",
            stringify!(aotSharedCacheUUID)
        )
    );
}
impl Default for dyld_all_image_infos {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct mach_header {
    pub _address: u8,
}
/* automatically generated by rust-bindgen 0.59.2 */

pub type integer_t = ::std::os::raw::c_int;
pub type cpu_type_t = integer_t;
pub type cpu_subtype_t = integer_t;
pub type vm_prot_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct mach_header_64 {
    pub magic: u32,
    pub cputype: cpu_type_t,
    pub cpusubtype: cpu_subtype_t,
    pub filetype: u32,
    pub ncmds: u32,
    pub sizeofcmds: u32,
    pub flags: u32,
    pub reserved: u32,
}
#[test]
fn bindgen_test_layout_mach_header_64() {
    assert_eq!(
        ::std::mem::size_of::<mach_header_64>(),
        32usize,
        concat!("Size of: ", stringify!(mach_header_64))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_header_64>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_header_64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_header_64>())).magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_header_64),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_header_64>())).cputype as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_header_64),
            "::",
            stringify!(cputype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_header_64>())).cpusubtype as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_header_64),
            "::",
            stringify!(cpusubtype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_header_64>())).filetype as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_header_64),
            "::",
            stringify!(filetype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_header_64>())).ncmds as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_header_64),
            "::",
            stringify!(ncmds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_header_64>())).sizeofcmds as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_header_64),
            "::",
            stringify!(sizeofcmds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_header_64>())).flags as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_header_64),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_header_64>())).reserved as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_header_64),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct segment_command {
    pub cmd: u32,
    pub cmdsize: u32,
    pub segname: [::std::os::raw::c_char; 16usize],
    pub vmaddr: u32,
    pub vmsize: u32,
    pub fileoff: u32,
    pub filesize: u32,
    pub maxprot: vm_prot_t,
    pub initprot: vm_prot_t,
    pub nsects: u32,
    pub flags: u32,
}
#[test]
fn bindgen_test_layout_segment_command() {
    assert_eq!(
        ::std::mem::size_of::<segment_command>(),
        56usize,
        concat!("Size of: ", stringify!(segment_command))
    );
    assert_eq!(
        ::std::mem::align_of::<segment_command>(),
        4usize,
        concat!("Alignment of ", stringify!(segment_command))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).cmdsize as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(cmdsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).segname as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(segname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).vmaddr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(vmaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).vmsize as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(vmsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).fileoff as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(fileoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).filesize as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(filesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).maxprot as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(maxprot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).initprot as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(initprot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).nsects as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(nsects)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command>())).flags as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct segment_command_64 {
    pub cmd: u32,
    pub cmdsize: u32,
    pub segname: [::std::os::raw::c_char; 16usize],
    pub vmaddr: u64,
    pub vmsize: u64,
    pub fileoff: u64,
    pub filesize: u64,
    pub maxprot: vm_prot_t,
    pub initprot: vm_prot_t,
    pub nsects: u32,
    pub flags: u32,
}
#[test]
fn bindgen_test_layout_segment_command_64() {
    assert_eq!(
        ::std::mem::size_of::<segment_command_64>(),
        72usize,
        concat!("Size of: ", stringify!(segment_command_64))
    );
    assert_eq!(
        ::std::mem::align_of::<segment_command_64>(),
        8usize,
        concat!("Alignment of ", stringify!(segment_command_64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).cmdsize as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(cmdsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).segname as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(segname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).vmaddr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(vmaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).vmsize as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(vmsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).fileoff as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(fileoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).filesize as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(filesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).maxprot as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(maxprot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).initprot as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(initprot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).nsects as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(nsects)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<segment_command_64>())).flags as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(segment_command_64),
            "::",
            stringify!(flags)
        )
    );
}
/* automatically generated by rust-bindgen 0.59.2 */

pub type mach_vm_address_t = u64;
pub type mach_vm_size_t = u64;
#[repr(C, packed(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct task_dyld_info {
    pub all_image_info_addr: mach_vm_address_t,
    pub all_image_info_size: mach_vm_size_t,
    pub all_image_info_format: integer_t,
}
#[test]
fn bindgen_test_layout_task_dyld_info() {
    assert_eq!(
        ::std::mem::size_of::<task_dyld_info>(),
        20usize,
        concat!("Size of: ", stringify!(task_dyld_info))
    );
    assert_eq!(
        ::std::mem::align_of::<task_dyld_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_dyld_info))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<task_dyld_info>())).all_image_info_addr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_dyld_info),
            "::",
            stringify!(all_image_info_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<task_dyld_info>())).all_image_info_size as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_dyld_info),
            "::",
            stringify!(all_image_info_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<task_dyld_info>())).all_image_info_format as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_dyld_info),
            "::",
            stringify!(all_image_info_format)
        )
    );
}
