## Documentation Pages

- [Index](index.md)
  - [Subcommands](subcommands.md)
  - [File Structures](file_structures.md)
  - [Installation](installation.md)

# Subcommands

The problem generator has various subcommands to switch between input modes: 
- [configuration_file](#configuration_file): single configuration file
- [codomain_file](#codomain_file): single codomain file
- [configuration_folder](#configuration_folder): multiple configuration files in a folder
- [codomain_folder](#codomain_folder): multiple codomain files in a folder

## configuration_file

We use the executable *problem\_generator* to generate the codomain files and the problems, and find the global optimum for each problem: 
``` 
    problem_generator configuration_file CONF_FILE 
        CODOMAIN_OUT PROBLEM_OUT [-n NUM]
```
where `CONF_FILE` is the input configuration file, `CODOMAIN_OUT` is the (existing) output codomain folder, `PROBLEM_OUT` is the (existing) output problem folder, and `-n NUM` is the number of problems generated per configuration setting.

An example run:
```
    problem_generator configuration_file deceptive_trap_conf.txt 
        codomain_files problems -n 25
```

## codomain_file

Instead of generating the codomain and then generating a problem with this generated codomain, one can use an existing codomain file to create a TD Mk Landscape problem. The executable offers the following subcommand for this purpose: 
```
    problem_generator codomain_file CODOMAIN_FILE 
        PROBLEM_FILE_OUT [-g]
```
where `CODOMAIN_FILE` is the input codomain file, `PROBLEM_FILE_OUT` is the output problem file, and the `-g` flag indicates the codomain was generated by the configuration_(file/folder) subcommand, and therefore contains the used codomain function on the first line. Note that this flag might change in the (near) future as this is not used much.

An example run:
```
    problem_generator codomain_file deceptive_trap_codomain.txt 
        deceptive_trap_problem.txt -g
```
## configuration_folder

Generate problems for configurations specified in a given directory that contains a directory 'problem_generation' with configuration files specifying the codomain parameters and ranges of topology parameters. See [configuration_file](#configuration_file) subcommand.

``` 
    problem_generator configuration_folder FOLDER... 
        [-n NUM]
```
where multiple folders can be passed, with each `FOLDER` being a folder as specified above (contains a 'problem_generation' folder), and `-n NUM` is the number of problems generated per configuration setting. Conveniently, this way of passing folders allows for using wildcards in Bash, for example. 

An example run that uses the mentioned wildcard:
```
    problem_generator configuration_folder test_*
        -n 25
```

## codomain_folder

Generate problems for configurations specified in a given directory that contains a directory 'codomain_files' with codomain files that specify both the topology and codomain. 

```
    problem_generator codomain_folder FOLDER...
        [-g]
```
where multiple folders can be passed, with each `FOLDER` being a folder as specified above (contains a 'codomain_files' folder), and the `-g` flag indicates the codomain was generated by the configuration_(file/folder) subcommand, and therefore contains the used codomain function on the first line. Note that this flag might change in the (near) future as this is not used much.

An example run:
```
    problem_generator codomain_folder test_folder
```

