# Rust API client for printnanny-api-client

Official API client library forprintnanny.ai print-nanny.com

For more information, please visit [https://print-nanny.com](https://print-nanny.com)

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 0.0.0
- Package version: 0.75.0
- Build package: `com.printnanny.api.rust.RustClientGenerator`

## Installation

Put the package under your project folder in a directory named `printnanny-api-client` and add the following to `Cargo.toml` under `[dependencies]`:

```
printnanny-api-client = { path = "./printnanny-api-client" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertsApi* | [**alerts_list**](docs/AlertsApi.md#alerts_list) | **GET** /api/alerts/ | 
*AlertsApi* | [**alerts_partial_update**](docs/AlertsApi.md#alerts_partial_update) | **PATCH** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_recent**](docs/AlertsApi.md#alerts_recent) | **GET** /api/alerts/recent/ | 
*AlertsApi* | [**alerts_retrieve**](docs/AlertsApi.md#alerts_retrieve) | **GET** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_seen**](docs/AlertsApi.md#alerts_seen) | **PATCH** /api/alerts/seen/ | 
*AlertsApi* | [**alerts_unread**](docs/AlertsApi.md#alerts_unread) | **GET** /api/alerts/unread/ | 
*AlertsApi* | [**alerts_update**](docs/AlertsApi.md#alerts_update) | **PUT** /api/alerts/{id}/ | 
*AuthApi* | [**auth_email_create**](docs/AuthApi.md#auth_email_create) | **POST** /auth/email/ | 
*AuthApi* | [**auth_mobile_create**](docs/AuthApi.md#auth_mobile_create) | **POST** /auth/mobile/ | 
*AuthApi* | [**auth_token_create**](docs/AuthApi.md#auth_token_create) | **POST** /auth/token/ | 
*AuthApi* | [**auth_verify_create**](docs/AuthApi.md#auth_verify_create) | **POST** /auth/verify/ | 
*AuthApi* | [**auth_verify_email_create**](docs/AuthApi.md#auth_verify_email_create) | **POST** /auth/verify/email/ | 
*AuthApi* | [**auth_verify_mobile_create**](docs/AuthApi.md#auth_verify_mobile_create) | **POST** /auth/verify/mobile/ | 
*ClientApi* | [**api_config_retreive**](docs/ClientApi.md#api_config_retreive) | **GET** /api/client | 
*CommandsApi* | [**commands_create**](docs/CommandsApi.md#commands_create) | **POST** /api/commands/ | 
*CommandsApi* | [**commands_list**](docs/CommandsApi.md#commands_list) | **GET** /api/commands/ | 
*CommandsApi* | [**commands_retrieve**](docs/CommandsApi.md#commands_retrieve) | **GET** /api/commands/{id}/ | 
*ConfigApi* | [**api_config_retreive**](docs/ConfigApi.md#api_config_retreive) | **GET** /api/client | 
*DevicesApi* | [**cloudiot_device_update_or_create**](docs/DevicesApi.md#cloudiot_device_update_or_create) | **POST** /api/devices/{device_id}/cloudiot/update-or-create/ | 
*DevicesApi* | [**devices_cloudiot_create**](docs/DevicesApi.md#devices_cloudiot_create) | **POST** /api/devices/{device_id}/cloudiot/ | 
*DevicesApi* | [**devices_cloudiot_list**](docs/DevicesApi.md#devices_cloudiot_list) | **GET** /api/devices/{device_id}/cloudiot/ | 
*DevicesApi* | [**devices_cloudiot_partial_update**](docs/DevicesApi.md#devices_cloudiot_partial_update) | **PATCH** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_cloudiot_retrieve**](docs/DevicesApi.md#devices_cloudiot_retrieve) | **GET** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_cloudiot_update**](docs/DevicesApi.md#devices_cloudiot_update) | **PUT** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_create**](docs/DevicesApi.md#devices_create) | **POST** /api/devices/ | 
*DevicesApi* | [**devices_janus_cloud_stream_get_or_create**](docs/DevicesApi.md#devices_janus_cloud_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-cloud-streams/get-or-create/ | 
*DevicesApi* | [**devices_janus_cloud_streams_create**](docs/DevicesApi.md#devices_janus_cloud_streams_create) | **POST** /api/devices/{device_id}/janus-cloud-streams/ | 
*DevicesApi* | [**devices_janus_cloud_streams_list**](docs/DevicesApi.md#devices_janus_cloud_streams_list) | **GET** /api/devices/{device_id}/janus-cloud-streams/ | 
*DevicesApi* | [**devices_janus_cloud_streams_partial_update**](docs/DevicesApi.md#devices_janus_cloud_streams_partial_update) | **PATCH** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*DevicesApi* | [**devices_janus_cloud_streams_retrieve**](docs/DevicesApi.md#devices_janus_cloud_streams_retrieve) | **GET** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*DevicesApi* | [**devices_janus_cloud_streams_update**](docs/DevicesApi.md#devices_janus_cloud_streams_update) | **PUT** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*DevicesApi* | [**devices_janus_edge_stream_get_or_create**](docs/DevicesApi.md#devices_janus_edge_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-edge-streams/get-or-create/ | 
*DevicesApi* | [**devices_janus_edge_streams_create**](docs/DevicesApi.md#devices_janus_edge_streams_create) | **POST** /api/devices/{device_id}/janus-edge-streams/ | 
*DevicesApi* | [**devices_janus_edge_streams_list**](docs/DevicesApi.md#devices_janus_edge_streams_list) | **GET** /api/devices/{device_id}/janus-edge-streams/ | 
*DevicesApi* | [**devices_janus_edge_streams_partial_update**](docs/DevicesApi.md#devices_janus_edge_streams_partial_update) | **PATCH** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*DevicesApi* | [**devices_janus_edge_streams_retrieve**](docs/DevicesApi.md#devices_janus_edge_streams_retrieve) | **GET** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*DevicesApi* | [**devices_janus_edge_streams_update**](docs/DevicesApi.md#devices_janus_edge_streams_update) | **PUT** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*DevicesApi* | [**devices_janus_streams_list**](docs/DevicesApi.md#devices_janus_streams_list) | **GET** /api/devices/{device_id}/janus-streams/ | 
*DevicesApi* | [**devices_janus_streams_retrieve**](docs/DevicesApi.md#devices_janus_streams_retrieve) | **GET** /api/devices/{device_id}/janus-streams/{id}/ | 
*DevicesApi* | [**devices_list**](docs/DevicesApi.md#devices_list) | **GET** /api/devices/ | 
*DevicesApi* | [**devices_octoprint_installs_list**](docs/DevicesApi.md#devices_octoprint_installs_list) | **GET** /api/devices/{device_id}/octoprint-installs/ | 
*DevicesApi* | [**devices_partial_update**](docs/DevicesApi.md#devices_partial_update) | **PATCH** /api/devices/{id}/ | 
*DevicesApi* | [**devices_public_keys_create**](docs/DevicesApi.md#devices_public_keys_create) | **POST** /api/devices/{device_id}/public-keys/ | 
*DevicesApi* | [**devices_public_keys_list**](docs/DevicesApi.md#devices_public_keys_list) | **GET** /api/devices/{device_id}/public-keys/ | 
*DevicesApi* | [**devices_public_keys_partial_update**](docs/DevicesApi.md#devices_public_keys_partial_update) | **PATCH** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_public_keys_retrieve**](docs/DevicesApi.md#devices_public_keys_retrieve) | **GET** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_public_keys_update**](docs/DevicesApi.md#devices_public_keys_update) | **PUT** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_retrieve**](docs/DevicesApi.md#devices_retrieve) | **GET** /api/devices/{id}/ | 
*DevicesApi* | [**devices_retrieve_hostname**](docs/DevicesApi.md#devices_retrieve_hostname) | **GET** /api/devices/{hostname} | 
*DevicesApi* | [**devices_system_info_create**](docs/DevicesApi.md#devices_system_info_create) | **POST** /api/devices/{device_id}/system-info/ | 
*DevicesApi* | [**devices_system_info_list**](docs/DevicesApi.md#devices_system_info_list) | **GET** /api/devices/{device_id}/system-info/ | 
*DevicesApi* | [**devices_system_info_partial_update**](docs/DevicesApi.md#devices_system_info_partial_update) | **PATCH** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_system_info_retrieve**](docs/DevicesApi.md#devices_system_info_retrieve) | **GET** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_system_info_update**](docs/DevicesApi.md#devices_system_info_update) | **PUT** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_update**](docs/DevicesApi.md#devices_update) | **PUT** /api/devices/{id}/ | 
*DevicesApi* | [**public_key_update_or_create**](docs/DevicesApi.md#public_key_update_or_create) | **POST** /api/devices/{device_id}/public-keys/update-or-create/ | 
*DevicesApi* | [**system_info_update_or_create**](docs/DevicesApi.md#system_info_update_or_create) | **POST** /api/devices/{device_id}/system-info/update-or-create/ | 
*EventsApi* | [**commands_create**](docs/EventsApi.md#commands_create) | **POST** /api/commands/ | 
*EventsApi* | [**commands_list**](docs/EventsApi.md#commands_list) | **GET** /api/commands/ | 
*EventsApi* | [**commands_retrieve**](docs/EventsApi.md#commands_retrieve) | **GET** /api/commands/{id}/ | 
*EventsApi* | [**events_create**](docs/EventsApi.md#events_create) | **POST** /api/events/ | 
*EventsApi* | [**events_list**](docs/EventsApi.md#events_list) | **GET** /api/events/ | 
*EventsApi* | [**events_retrieve**](docs/EventsApi.md#events_retrieve) | **GET** /api/events/{id}/ | 
*JanusApi* | [**devices_janus_cloud_stream_get_or_create**](docs/JanusApi.md#devices_janus_cloud_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-cloud-streams/get-or-create/ | 
*JanusApi* | [**devices_janus_cloud_streams_create**](docs/JanusApi.md#devices_janus_cloud_streams_create) | **POST** /api/devices/{device_id}/janus-cloud-streams/ | 
*JanusApi* | [**devices_janus_cloud_streams_list**](docs/JanusApi.md#devices_janus_cloud_streams_list) | **GET** /api/devices/{device_id}/janus-cloud-streams/ | 
*JanusApi* | [**devices_janus_cloud_streams_retrieve**](docs/JanusApi.md#devices_janus_cloud_streams_retrieve) | **GET** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*JanusApi* | [**devices_janus_cloud_streams_update**](docs/JanusApi.md#devices_janus_cloud_streams_update) | **PUT** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*JanusApi* | [**devices_janus_edge_stream_get_or_create**](docs/JanusApi.md#devices_janus_edge_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-edge-streams/get-or-create/ | 
*JanusApi* | [**devices_janus_edge_streams_create**](docs/JanusApi.md#devices_janus_edge_streams_create) | **POST** /api/devices/{device_id}/janus-edge-streams/ | 
*JanusApi* | [**devices_janus_edge_streams_list**](docs/JanusApi.md#devices_janus_edge_streams_list) | **GET** /api/devices/{device_id}/janus-edge-streams/ | 
*JanusApi* | [**devices_janus_edge_streams_retrieve**](docs/JanusApi.md#devices_janus_edge_streams_retrieve) | **GET** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*JanusApi* | [**devices_janus_edge_streams_update**](docs/JanusApi.md#devices_janus_edge_streams_update) | **PUT** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*JanusApi* | [**devices_janus_streams_list**](docs/JanusApi.md#devices_janus_streams_list) | **GET** /api/devices/{device_id}/janus-streams/ | 
*JanusApi* | [**devices_janus_streams_retrieve**](docs/JanusApi.md#devices_janus_streams_retrieve) | **GET** /api/devices/{device_id}/janus-streams/{id}/ | 
*JanusApi* | [**users_janus_auth_create**](docs/JanusApi.md#users_janus_auth_create) | **POST** /api/users/{user_id}/janus-auth/ | 
*JanusApi* | [**users_janus_auth_list**](docs/JanusApi.md#users_janus_auth_list) | **GET** /api/users/{user_id}/janus-auth/ | 
*JanusApi* | [**users_janus_auth_retrieve**](docs/JanusApi.md#users_janus_auth_retrieve) | **GET** /api/users/{user_id}/janus-auth/{id}/ | 
*JanusApi* | [**users_janus_auth_update_or_create**](docs/JanusApi.md#users_janus_auth_update_or_create) | **POST** /api/users/{user_id}/janus-auth/update-or-create/ | 
*OctoprintApi* | [**octoprint_backups_create**](docs/OctoprintApi.md#octoprint_backups_create) | **POST** /api/octoprint/backups/ | 
*OctoprintApi* | [**octoprint_backups_list**](docs/OctoprintApi.md#octoprint_backups_list) | **GET** /api/octoprint/backups/ | 
*OctoprintApi* | [**octoprint_backups_retrieve**](docs/OctoprintApi.md#octoprint_backups_retrieve) | **GET** /api/octoprint/backups/{id}/ | 
*OctoprintApi* | [**octoprint_gcode_files_create**](docs/OctoprintApi.md#octoprint_gcode_files_create) | **POST** /api/octoprint/gcode-files/ | 
*OctoprintApi* | [**octoprint_gcode_files_list**](docs/OctoprintApi.md#octoprint_gcode_files_list) | **GET** /api/octoprint/gcode-files/ | 
*OctoprintApi* | [**octoprint_gcode_files_retrieve**](docs/OctoprintApi.md#octoprint_gcode_files_retrieve) | **GET** /api/octoprint/gcode-files/{id}/ | 
*OctoprintApi* | [**octoprint_install_update_or_create**](docs/OctoprintApi.md#octoprint_install_update_or_create) | **POST** /api/octoprint/installs/update-or-create/ | 
*OctoprintApi* | [**octoprint_installs_create**](docs/OctoprintApi.md#octoprint_installs_create) | **POST** /api/octoprint/installs/ | 
*OctoprintApi* | [**octoprint_installs_list**](docs/OctoprintApi.md#octoprint_installs_list) | **GET** /api/octoprint/installs/ | 
*OctoprintApi* | [**octoprint_installs_partial_update**](docs/OctoprintApi.md#octoprint_installs_partial_update) | **PATCH** /api/octoprint/installs/{id}/ | 
*OctoprintApi* | [**octoprint_installs_update**](docs/OctoprintApi.md#octoprint_installs_update) | **PUT** /api/octoprint/installs/{id}/ | 
*OctoprintApi* | [**octoprint_printer_profiles_create**](docs/OctoprintApi.md#octoprint_printer_profiles_create) | **POST** /api/octoprint/printer-profiles/ | 
*OctoprintApi* | [**octoprint_printer_profiles_list**](docs/OctoprintApi.md#octoprint_printer_profiles_list) | **GET** /api/octoprint/printer-profiles/ | 
*OctoprintApi* | [**octoprint_printer_profiles_partial_update**](docs/OctoprintApi.md#octoprint_printer_profiles_partial_update) | **PATCH** /api/octoprint/printer-profiles/{id}/ | 
*OctoprintApi* | [**octoprint_printer_profiles_update**](docs/OctoprintApi.md#octoprint_printer_profiles_update) | **PUT** /api/octoprint/printer-profiles/{id}/ | 
*OctoprintApi* | [**octoprint_profile_update_or_create**](docs/OctoprintApi.md#octoprint_profile_update_or_create) | **POST** /api/octoprint/printer-profiles/update-or-create/ | 
*OctoprintApi* | [**octoprint_settings_create**](docs/OctoprintApi.md#octoprint_settings_create) | **POST** /api/octoprint/settings/ | 
*OctoprintApi* | [**octoprint_settings_list**](docs/OctoprintApi.md#octoprint_settings_list) | **GET** /api/octoprint/settings/ | 
*OctoprintApi* | [**octoprint_settings_partial_update**](docs/OctoprintApi.md#octoprint_settings_partial_update) | **PATCH** /api/octoprint/settings/{id}/ | 
*OctoprintApi* | [**octoprint_settings_update**](docs/OctoprintApi.md#octoprint_settings_update) | **PUT** /api/octoprint/settings/{id}/ | 
*OctoprintApi* | [**octoprint_settings_update_or_create**](docs/OctoprintApi.md#octoprint_settings_update_or_create) | **POST** /api/octoprint/settings/update-or-create/ | 
*PartnersGeeks3dApi* | [**alerts_list2**](docs/PartnersGeeks3dApi.md#alerts_list2) | **GET** /api/partners/3d-geeks/{id}/alerts/ | 
*PartnersGeeks3dApi* | [**metadata_retrieve**](docs/PartnersGeeks3dApi.md#metadata_retrieve) | **GET** /api/partners/3d-geeks/{id}/ | 
*SchemaApi* | [**schema_retrieve**](docs/SchemaApi.md#schema_retrieve) | **GET** /api/schema/ | 
*UsersApi* | [**users_janus_auth_create**](docs/UsersApi.md#users_janus_auth_create) | **POST** /api/users/{user_id}/janus-auth/ | 
*UsersApi* | [**users_janus_auth_list**](docs/UsersApi.md#users_janus_auth_list) | **GET** /api/users/{user_id}/janus-auth/ | 
*UsersApi* | [**users_janus_auth_retrieve**](docs/UsersApi.md#users_janus_auth_retrieve) | **GET** /api/users/{user_id}/janus-auth/{id}/ | 
*UsersApi* | [**users_janus_auth_update_or_create**](docs/UsersApi.md#users_janus_auth_update_or_create) | **POST** /api/users/{user_id}/janus-auth/update-or-create/ | 
*UsersApi* | [**users_me_retrieve**](docs/UsersApi.md#users_me_retrieve) | **GET** /api/users/me/ | 
*UsersApi* | [**users_partial_update**](docs/UsersApi.md#users_partial_update) | **PATCH** /api/users/{id}/ | 
*UsersApi* | [**users_retrieve**](docs/UsersApi.md#users_retrieve) | **GET** /api/users/{id}/ | 
*UsersApi* | [**users_update**](docs/UsersApi.md#users_update) | **PUT** /api/users/{id}/ | 


## Documentation For Models

 - [Alert](docs/Alert.md)
 - [AlertBulkResponse](docs/AlertBulkResponse.md)
 - [AlertRequest](docs/AlertRequest.md)
 - [CallbackTokenAuthRequest](docs/CallbackTokenAuthRequest.md)
 - [CallbackTokenVerification](docs/CallbackTokenVerification.md)
 - [CallbackTokenVerificationRequest](docs/CallbackTokenVerificationRequest.md)
 - [CloudiotDevice](docs/CloudiotDevice.md)
 - [CloudiotDeviceRequest](docs/CloudiotDeviceRequest.md)
 - [DetailResponse](docs/DetailResponse.md)
 - [Device](docs/Device.md)
 - [DeviceReleaseChannel](docs/DeviceReleaseChannel.md)
 - [DeviceRequest](docs/DeviceRequest.md)
 - [EmailAuthRequest](docs/EmailAuthRequest.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [EventSource](docs/EventSource.md)
 - [EventTypeEnum](docs/EventTypeEnum.md)
 - [GcodeFile](docs/GcodeFile.md)
 - [JanusAuth](docs/JanusAuth.md)
 - [JanusAuthRequest](docs/JanusAuthRequest.md)
 - [JanusCloudStream](docs/JanusCloudStream.md)
 - [JanusCloudStreamRequest](docs/JanusCloudStreamRequest.md)
 - [JanusConfigType](docs/JanusConfigType.md)
 - [JanusEdgeStream](docs/JanusEdgeStream.md)
 - [JanusEdgeStreamRequest](docs/JanusEdgeStreamRequest.md)
 - [JanusStream](docs/JanusStream.md)
 - [MobileAuthRequest](docs/MobileAuthRequest.md)
 - [OctoPrintBackup](docs/OctoPrintBackup.md)
 - [OctoPrintEvent](docs/OctoPrintEvent.md)
 - [OctoPrintEventEventNameEnum](docs/OctoPrintEventEventNameEnum.md)
 - [OctoPrintEventModelEnum](docs/OctoPrintEventModelEnum.md)
 - [OctoPrintEventRequest](docs/OctoPrintEventRequest.md)
 - [OctoPrintInstall](docs/OctoPrintInstall.md)
 - [OctoPrintInstallRequest](docs/OctoPrintInstallRequest.md)
 - [OctoPrintSettings](docs/OctoPrintSettings.md)
 - [OctoPrintSettingsRequest](docs/OctoPrintSettingsRequest.md)
 - [OctoPrinterProfile](docs/OctoPrinterProfile.md)
 - [OctoPrinterProfileRequest](docs/OctoPrinterProfileRequest.md)
 - [PaginatedAlertList](docs/PaginatedAlertList.md)
 - [PaginatedCloudiotDeviceList](docs/PaginatedCloudiotDeviceList.md)
 - [PaginatedDeviceList](docs/PaginatedDeviceList.md)
 - [PaginatedGcodeFileList](docs/PaginatedGcodeFileList.md)
 - [PaginatedJanusAuthList](docs/PaginatedJanusAuthList.md)
 - [PaginatedJanusCloudStreamList](docs/PaginatedJanusCloudStreamList.md)
 - [PaginatedJanusEdgeStreamList](docs/PaginatedJanusEdgeStreamList.md)
 - [PaginatedJanusStreamList](docs/PaginatedJanusStreamList.md)
 - [PaginatedOctoPrintBackupList](docs/PaginatedOctoPrintBackupList.md)
 - [PaginatedOctoPrintInstallList](docs/PaginatedOctoPrintInstallList.md)
 - [PaginatedOctoPrintSettingsList](docs/PaginatedOctoPrintSettingsList.md)
 - [PaginatedOctoPrinterProfileList](docs/PaginatedOctoPrinterProfileList.md)
 - [PaginatedPolymorphicCommandList](docs/PaginatedPolymorphicCommandList.md)
 - [PaginatedPolymorphicEventList](docs/PaginatedPolymorphicEventList.md)
 - [PaginatedPublicKeyList](docs/PaginatedPublicKeyList.md)
 - [PaginatedSystemInfoList](docs/PaginatedSystemInfoList.md)
 - [Partner3DGeeksAlert](docs/Partner3DGeeksAlert.md)
 - [Partner3DGeeksMetadata](docs/Partner3DGeeksMetadata.md)
 - [PatchedAlertBulkRequestRequest](docs/PatchedAlertBulkRequestRequest.md)
 - [PatchedAlertRequest](docs/PatchedAlertRequest.md)
 - [PatchedCloudiotDeviceRequest](docs/PatchedCloudiotDeviceRequest.md)
 - [PatchedDeviceRequest](docs/PatchedDeviceRequest.md)
 - [PatchedJanusCloudStreamRequest](docs/PatchedJanusCloudStreamRequest.md)
 - [PatchedJanusEdgeStreamRequest](docs/PatchedJanusEdgeStreamRequest.md)
 - [PatchedOctoPrintInstallRequest](docs/PatchedOctoPrintInstallRequest.md)
 - [PatchedOctoPrintSettingsRequest](docs/PatchedOctoPrintSettingsRequest.md)
 - [PatchedOctoPrinterProfileRequest](docs/PatchedOctoPrinterProfileRequest.md)
 - [PatchedPublicKeyRequest](docs/PatchedPublicKeyRequest.md)
 - [PatchedSystemInfoRequest](docs/PatchedSystemInfoRequest.md)
 - [PatchedUserRequest](docs/PatchedUserRequest.md)
 - [PolymorphicCommand](docs/PolymorphicCommand.md)
 - [PolymorphicCommandRequest](docs/PolymorphicCommandRequest.md)
 - [PolymorphicEvent](docs/PolymorphicEvent.md)
 - [PolymorphicEventRequest](docs/PolymorphicEventRequest.md)
 - [PrintNannyApiConfig](docs/PrintNannyApiConfig.md)
 - [PublicKey](docs/PublicKey.md)
 - [PublicKeyRequest](docs/PublicKeyRequest.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [SystemInfoRequest](docs/SystemInfoRequest.md)
 - [TestEvent](docs/TestEvent.md)
 - [TestEventModel](docs/TestEventModel.md)
 - [TestEventName](docs/TestEventName.md)
 - [TestEventRequest](docs/TestEventRequest.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [User](docs/User.md)
 - [UserRequest](docs/UserRequest.md)
 - [WebRtcCommand](docs/WebRtcCommand.md)
 - [WebRtcCommandEventNameEnum](docs/WebRtcCommandEventNameEnum.md)
 - [WebRtcCommandModelEnum](docs/WebRtcCommandModelEnum.md)
 - [WebRtcCommandRequest](docs/WebRtcCommandRequest.md)
 - [WebRtcEvent](docs/WebRtcEvent.md)
 - [WebRtcEventModel](docs/WebRtcEventModel.md)
 - [WebRtcEventName](docs/WebRtcEventName.md)
 - [WebRtcEventRequest](docs/WebRtcEventRequest.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

leigh@printnanny.ai

