/*
 * printnanny-api-client
 *
 * Official API client library forprintnanny.ai print-nanny.com
 *
 * The version of the OpenAPI document: 0.0.0
 * Contact: leigh@printnanny.ai
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct WebRtcEvent {
    #[serde(rename = "id")]
    pub id: i32,
    #[serde(rename = "model")]
    pub model: crate::models::WebRtcEventModel,
    #[serde(rename = "stream")]
    pub stream: Option<Box<crate::models::JanusStream>>,
    #[serde(rename = "created_dt")]
    pub created_dt: String,
    #[serde(rename = "source")]
    pub source: crate::models::EventSource,
    /// Broadcast to events websocket: /ws/events
    #[serde(rename = "send_ws", skip_serializing_if = "Option::is_none")]
    pub send_ws: Option<bool>,
    #[serde(rename = "event_name")]
    pub event_name: crate::models::WebRtcEventName,
    #[serde(rename = "data", skip_serializing_if = "Option::is_none")]
    pub data: Option<::std::collections::HashMap<String, serde_json::Value>>,
    /// Broadcast to mqtt topic: /devices/{device-id}/commands/
    #[serde(rename = "send_mqtt", skip_serializing_if = "Option::is_none")]
    pub send_mqtt: Option<bool>,
    #[serde(rename = "polymorphic_ctype")]
    pub polymorphic_ctype: i32,
    #[serde(rename = "user")]
    pub user: i32,
    #[serde(rename = "device")]
    pub device: i32,
}

impl WebRtcEvent {
    pub fn new(id: i32, model: crate::models::WebRtcEventModel, stream: Option<crate::models::JanusStream>, created_dt: String, source: crate::models::EventSource, event_name: crate::models::WebRtcEventName, polymorphic_ctype: i32, user: i32, device: i32) -> WebRtcEvent {
        WebRtcEvent {
            id,
            model,
            stream: stream.map(Box::new),
            created_dt,
            source,
            send_ws: None,
            event_name,
            data: None,
            send_mqtt: None,
            polymorphic_ctype,
            user,
            device,
        }
    }
}


