# Rust API client for printnanny-api-client

Official API client library for print-nanny.com

For more information, please visit [https://print-nanny.com](https://print-nanny.com)

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 0.0.0
- Package version: 0.58.4
- Build package: `com.printnanny.api.rust.RustClientGenerator`

## Installation

Put the package under your project folder in a directory named `printnanny-api-client` and add the following to `Cargo.toml` under `[dependencies]`:

```
printnanny-api-client = { path = "./printnanny-api-client" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertsApi* | [**alerts_list**](docs/AlertsApi.md#alerts_list) | **GET** /api/alerts/ | 
*AlertsApi* | [**alerts_partial_update**](docs/AlertsApi.md#alerts_partial_update) | **PATCH** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_recent**](docs/AlertsApi.md#alerts_recent) | **GET** /api/alerts/recent/ | 
*AlertsApi* | [**alerts_retrieve**](docs/AlertsApi.md#alerts_retrieve) | **GET** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_seen**](docs/AlertsApi.md#alerts_seen) | **PATCH** /api/alerts/seen/ | 
*AlertsApi* | [**alerts_unread**](docs/AlertsApi.md#alerts_unread) | **GET** /api/alerts/unread/ | 
*AlertsApi* | [**alerts_update**](docs/AlertsApi.md#alerts_update) | **PUT** /api/alerts/{id}/ | 
*AuthApi* | [**auth_email_create**](docs/AuthApi.md#auth_email_create) | **POST** /auth/email/ | 
*AuthApi* | [**auth_mobile_create**](docs/AuthApi.md#auth_mobile_create) | **POST** /auth/mobile/ | 
*AuthApi* | [**auth_token_create**](docs/AuthApi.md#auth_token_create) | **POST** /auth/token/ | 
*AuthApi* | [**auth_verify_create**](docs/AuthApi.md#auth_verify_create) | **POST** /auth/verify/ | 
*AuthApi* | [**auth_verify_email_create**](docs/AuthApi.md#auth_verify_email_create) | **POST** /auth/verify/email/ | 
*AuthApi* | [**auth_verify_mobile_create**](docs/AuthApi.md#auth_verify_mobile_create) | **POST** /auth/verify/mobile/ | 
*ClientConfigApi* | [**client_config_list**](docs/ClientConfigApi.md#client_config_list) | **GET** /api/client-config/ | 
*DevicesApi* | [**cloudiot_device_update_or_create**](docs/DevicesApi.md#cloudiot_device_update_or_create) | **POST** /api/devices/{device_id}/cloudiot/update-or-create/ | 
*DevicesApi* | [**devices_cameras_create**](docs/DevicesApi.md#devices_cameras_create) | **POST** /api/devices/{device_id}/cameras/ | 
*DevicesApi* | [**devices_cameras_list**](docs/DevicesApi.md#devices_cameras_list) | **GET** /api/devices/{device_id}/cameras/ | 
*DevicesApi* | [**devices_cameras_partial_update**](docs/DevicesApi.md#devices_cameras_partial_update) | **PATCH** /api/devices/{device_id}/cameras/{id}/ | 
*DevicesApi* | [**devices_cameras_retrieve**](docs/DevicesApi.md#devices_cameras_retrieve) | **GET** /api/devices/{device_id}/cameras/{id}/ | 
*DevicesApi* | [**devices_cameras_update**](docs/DevicesApi.md#devices_cameras_update) | **PUT** /api/devices/{device_id}/cameras/{id}/ | 
*DevicesApi* | [**devices_cloudiot_create**](docs/DevicesApi.md#devices_cloudiot_create) | **POST** /api/devices/{device_id}/cloudiot/ | 
*DevicesApi* | [**devices_cloudiot_list**](docs/DevicesApi.md#devices_cloudiot_list) | **GET** /api/devices/{device_id}/cloudiot/ | 
*DevicesApi* | [**devices_cloudiot_partial_update**](docs/DevicesApi.md#devices_cloudiot_partial_update) | **PATCH** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_cloudiot_retrieve**](docs/DevicesApi.md#devices_cloudiot_retrieve) | **GET** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_cloudiot_update**](docs/DevicesApi.md#devices_cloudiot_update) | **PUT** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_create**](docs/DevicesApi.md#devices_create) | **POST** /api/devices/ | 
*DevicesApi* | [**devices_janus_stream_get_or_create**](docs/DevicesApi.md#devices_janus_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-streams/get-or-create/ | 
*DevicesApi* | [**devices_janus_stream_update_or_create**](docs/DevicesApi.md#devices_janus_stream_update_or_create) | **POST** /api/devices/{device_id}/janus-streams/update-or-create/ | 
*DevicesApi* | [**devices_janus_streams_create**](docs/DevicesApi.md#devices_janus_streams_create) | **POST** /api/devices/{device_id}/janus-streams/ | 
*DevicesApi* | [**devices_janus_streams_list**](docs/DevicesApi.md#devices_janus_streams_list) | **GET** /api/devices/{device_id}/janus-streams/ | 
*DevicesApi* | [**devices_janus_streams_partial_update**](docs/DevicesApi.md#devices_janus_streams_partial_update) | **PATCH** /api/devices/{device_id}/janus-streams/{id}/ | 
*DevicesApi* | [**devices_janus_streams_retrieve**](docs/DevicesApi.md#devices_janus_streams_retrieve) | **GET** /api/devices/{device_id}/janus-streams/{id}/ | 
*DevicesApi* | [**devices_janus_streams_update**](docs/DevicesApi.md#devices_janus_streams_update) | **PUT** /api/devices/{device_id}/janus-streams/{id}/ | 
*DevicesApi* | [**devices_list**](docs/DevicesApi.md#devices_list) | **GET** /api/devices/ | 
*DevicesApi* | [**devices_partial_update**](docs/DevicesApi.md#devices_partial_update) | **PATCH** /api/devices/{id}/ | 
*DevicesApi* | [**devices_printer_controllers_create**](docs/DevicesApi.md#devices_printer_controllers_create) | **POST** /api/devices/{device_id}/printer-controllers/ | 
*DevicesApi* | [**devices_printer_controllers_list**](docs/DevicesApi.md#devices_printer_controllers_list) | **GET** /api/devices/{device_id}/printer-controllers/ | 
*DevicesApi* | [**devices_printer_controllers_partial_update**](docs/DevicesApi.md#devices_printer_controllers_partial_update) | **PATCH** /api/devices/{device_id}/printer-controllers/{id}/ | 
*DevicesApi* | [**devices_printer_controllers_retrieve**](docs/DevicesApi.md#devices_printer_controllers_retrieve) | **GET** /api/devices/{device_id}/printer-controllers/{id}/ | 
*DevicesApi* | [**devices_printer_controllers_update**](docs/DevicesApi.md#devices_printer_controllers_update) | **PUT** /api/devices/{device_id}/printer-controllers/{id}/ | 
*DevicesApi* | [**devices_public_keys_create**](docs/DevicesApi.md#devices_public_keys_create) | **POST** /api/devices/{device_id}/public-keys/ | 
*DevicesApi* | [**devices_public_keys_list**](docs/DevicesApi.md#devices_public_keys_list) | **GET** /api/devices/{device_id}/public-keys/ | 
*DevicesApi* | [**devices_public_keys_partial_update**](docs/DevicesApi.md#devices_public_keys_partial_update) | **PATCH** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_public_keys_retrieve**](docs/DevicesApi.md#devices_public_keys_retrieve) | **GET** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_public_keys_update**](docs/DevicesApi.md#devices_public_keys_update) | **PUT** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_retrieve**](docs/DevicesApi.md#devices_retrieve) | **GET** /api/devices/{id}/ | 
*DevicesApi* | [**devices_retrieve_hostname**](docs/DevicesApi.md#devices_retrieve_hostname) | **GET** /api/devices/{hostname} | 
*DevicesApi* | [**devices_system_info_create**](docs/DevicesApi.md#devices_system_info_create) | **POST** /api/devices/{device_id}/system-info/ | 
*DevicesApi* | [**devices_system_info_list**](docs/DevicesApi.md#devices_system_info_list) | **GET** /api/devices/{device_id}/system-info/ | 
*DevicesApi* | [**devices_system_info_partial_update**](docs/DevicesApi.md#devices_system_info_partial_update) | **PATCH** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_system_info_retrieve**](docs/DevicesApi.md#devices_system_info_retrieve) | **GET** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_system_info_update**](docs/DevicesApi.md#devices_system_info_update) | **PUT** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_update**](docs/DevicesApi.md#devices_update) | **PUT** /api/devices/{id}/ | 
*DevicesApi* | [**public_key_update_or_create**](docs/DevicesApi.md#public_key_update_or_create) | **POST** /api/devices/{device_id}/public-keys/update-or-create/ | 
*DevicesApi* | [**system_info_update_or_create**](docs/DevicesApi.md#system_info_update_or_create) | **POST** /api/devices/{device_id}/system-info/update-or-create/ | 
*EventsApi* | [**events_create**](docs/EventsApi.md#events_create) | **POST** /api/events/ | 
*EventsApi* | [**events_list**](docs/EventsApi.md#events_list) | **GET** /api/events/ | 
*EventsApi* | [**events_retrieve**](docs/EventsApi.md#events_retrieve) | **GET** /api/events/{id}/ | 
*JanusApi* | [**devices_janus_stream_get_or_create**](docs/JanusApi.md#devices_janus_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-streams/get-or-create/ | 
*JanusApi* | [**devices_janus_stream_update_or_create**](docs/JanusApi.md#devices_janus_stream_update_or_create) | **POST** /api/devices/{device_id}/janus-streams/update-or-create/ | 
*JanusApi* | [**devices_janus_streams_create**](docs/JanusApi.md#devices_janus_streams_create) | **POST** /api/devices/{device_id}/janus-streams/ | 
*JanusApi* | [**devices_janus_streams_list**](docs/JanusApi.md#devices_janus_streams_list) | **GET** /api/devices/{device_id}/janus-streams/ | 
*JanusApi* | [**devices_janus_streams_retrieve**](docs/JanusApi.md#devices_janus_streams_retrieve) | **GET** /api/devices/{device_id}/janus-streams/{id}/ | 
*JanusApi* | [**devices_janus_streams_update**](docs/JanusApi.md#devices_janus_streams_update) | **PUT** /api/devices/{device_id}/janus-streams/{id}/ | 
*JanusApi* | [**users_janus_auth_create**](docs/JanusApi.md#users_janus_auth_create) | **POST** /api/users/{user_id}/janus-auth/ | 
*JanusApi* | [**users_janus_auth_list**](docs/JanusApi.md#users_janus_auth_list) | **GET** /api/users/{user_id}/janus-auth/ | 
*JanusApi* | [**users_janus_auth_retrieve**](docs/JanusApi.md#users_janus_auth_retrieve) | **GET** /api/users/{user_id}/janus-auth/{id}/ | 
*JanusApi* | [**users_janus_auth_update_or_create**](docs/JanusApi.md#users_janus_auth_update_or_create) | **POST** /api/users/{user_id}/janus-auth/update-or-create/ | 
*MlOpsApi* | [**device_calibration_update_or_create**](docs/MlOpsApi.md#device_calibration_update_or_create) | **POST** /api/device-calibrations/update-or-create/ | 
*MlOpsApi* | [**device_calibrations_list**](docs/MlOpsApi.md#device_calibrations_list) | **GET** /api/device-calibrations/ | 
*MlOpsApi* | [**device_calibrations_partial_update**](docs/MlOpsApi.md#device_calibrations_partial_update) | **PATCH** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**device_calibrations_retrieve**](docs/MlOpsApi.md#device_calibrations_retrieve) | **GET** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**device_calibrations_update**](docs/MlOpsApi.md#device_calibrations_update) | **PUT** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**experiment_device_configs_list**](docs/MlOpsApi.md#experiment_device_configs_list) | **GET** /api/experiment-device-configs/ | 
*MlOpsApi* | [**experiment_device_configs_retrieve**](docs/MlOpsApi.md#experiment_device_configs_retrieve) | **GET** /api/experiment-device-configs/{id}/ | 
*MlOpsApi* | [**experiments_list**](docs/MlOpsApi.md#experiments_list) | **GET** /api/experiments/ | 
*MlOpsApi* | [**experiments_retrieve**](docs/MlOpsApi.md#experiments_retrieve) | **GET** /api/experiments/{id}/ | 
*MlOpsApi* | [**model_artifacts_list**](docs/MlOpsApi.md#model_artifacts_list) | **GET** /api/model-artifacts/ | 
*MlOpsApi* | [**model_artifacts_retrieve**](docs/MlOpsApi.md#model_artifacts_retrieve) | **GET** /api/model-artifacts/{id}/ | 
*OctoprintBackupsApi* | [**octoprint_backups_create**](docs/OctoprintBackupsApi.md#octoprint_backups_create) | **POST** /api/octoprint-backups/ | 
*OctoprintBackupsApi* | [**octoprint_backups_list**](docs/OctoprintBackupsApi.md#octoprint_backups_list) | **GET** /api/octoprint-backups/ | 
*OctoprintBackupsApi* | [**octoprint_backups_retrieve**](docs/OctoprintBackupsApi.md#octoprint_backups_retrieve) | **GET** /api/octoprint-backups/{id}/ | 
*PartnersGeeks3Api* | [**alerts_list2**](docs/PartnersGeeks3Api.md#alerts_list2) | **GET** /api/partners/3d-geeks/{id}/alerts/ | 
*PartnersGeeks3dApi* | [**metadata_retrieve**](docs/PartnersGeeks3dApi.md#metadata_retrieve) | **GET** /api/partners/3d-geeks/{id}/ | 
*RemoteControlApi* | [**commands_list**](docs/RemoteControlApi.md#commands_list) | **GET** /api/commands/ | 
*RemoteControlApi* | [**commands_partial_update**](docs/RemoteControlApi.md#commands_partial_update) | **PATCH** /api/commands/{id}/ | 
*RemoteControlApi* | [**commands_retrieve**](docs/RemoteControlApi.md#commands_retrieve) | **GET** /api/commands/{id}/ | 
*RemoteControlApi* | [**commands_update**](docs/RemoteControlApi.md#commands_update) | **PUT** /api/commands/{id}/ | 
*RemoteControlApi* | [**gcode_files_create**](docs/RemoteControlApi.md#gcode_files_create) | **POST** /api/gcode-files/ | 
*RemoteControlApi* | [**gcode_files_list**](docs/RemoteControlApi.md#gcode_files_list) | **GET** /api/gcode-files/ | 
*RemoteControlApi* | [**gcode_files_partial_update**](docs/RemoteControlApi.md#gcode_files_partial_update) | **PATCH** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**gcode_files_retrieve**](docs/RemoteControlApi.md#gcode_files_retrieve) | **GET** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**gcode_files_update**](docs/RemoteControlApi.md#gcode_files_update) | **PUT** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**gcode_files_update_or_create**](docs/RemoteControlApi.md#gcode_files_update_or_create) | **POST** /api/gcode-files/update-or-create/ | 
*RemoteControlApi* | [**octoprint_devices_create**](docs/RemoteControlApi.md#octoprint_devices_create) | **POST** /api/octoprint-devices/ | 
*RemoteControlApi* | [**octoprint_devices_list**](docs/RemoteControlApi.md#octoprint_devices_list) | **GET** /api/octoprint-devices/ | 
*RemoteControlApi* | [**octoprint_devices_partial_update**](docs/RemoteControlApi.md#octoprint_devices_partial_update) | **PATCH** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_retrieve**](docs/RemoteControlApi.md#octoprint_devices_retrieve) | **GET** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_update**](docs/RemoteControlApi.md#octoprint_devices_update) | **PUT** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_update_or_create**](docs/RemoteControlApi.md#octoprint_devices_update_or_create) | **POST** /api/octoprint-devices/update-or-create/ | 
*RemoteControlApi* | [**print_session_partial_update**](docs/RemoteControlApi.md#print_session_partial_update) | **PATCH** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**print_session_update**](docs/RemoteControlApi.md#print_session_update) | **PUT** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**print_sessions_create**](docs/RemoteControlApi.md#print_sessions_create) | **POST** /api/print-sessions/ | 
*RemoteControlApi* | [**print_sessions_list**](docs/RemoteControlApi.md#print_sessions_list) | **GET** /api/print-sessions/ | 
*RemoteControlApi* | [**print_sessions_retrieve**](docs/RemoteControlApi.md#print_sessions_retrieve) | **GET** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**printer_profiles_create**](docs/RemoteControlApi.md#printer_profiles_create) | **POST** /api/printer-profiles/ | 
*RemoteControlApi* | [**printer_profiles_list**](docs/RemoteControlApi.md#printer_profiles_list) | **GET** /api/printer-profiles/ | 
*RemoteControlApi* | [**printer_profiles_partial_update**](docs/RemoteControlApi.md#printer_profiles_partial_update) | **PATCH** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**printer_profiles_retrieve**](docs/RemoteControlApi.md#printer_profiles_retrieve) | **GET** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**printer_profiles_update**](docs/RemoteControlApi.md#printer_profiles_update) | **PUT** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**printer_profiles_update_or_create**](docs/RemoteControlApi.md#printer_profiles_update_or_create) | **POST** /api/printer-profiles/update-or-create/ | 
*SchemaApi* | [**schema_retrieve**](docs/SchemaApi.md#schema_retrieve) | **GET** /api/schema/ | 
*TelemetryApi* | [**octoprint_events_create**](docs/TelemetryApi.md#octoprint_events_create) | **POST** /api/octoprint-events/ | 
*TelemetryApi* | [**octoprint_events_list**](docs/TelemetryApi.md#octoprint_events_list) | **GET** /api/octoprint-events/ | 
*TelemetryApi* | [**octoprint_events_retrieve**](docs/TelemetryApi.md#octoprint_events_retrieve) | **GET** /api/octoprint-events/{id}/ | 
*TelemetryApi* | [**print_job_events_list**](docs/TelemetryApi.md#print_job_events_list) | **GET** /api/print-job-events/ | 
*TelemetryApi* | [**print_job_events_retrieve**](docs/TelemetryApi.md#print_job_events_retrieve) | **GET** /api/print-job-events/{id}/ | 
*TelemetryApi* | [**print_nanny_plugin_events_list**](docs/TelemetryApi.md#print_nanny_plugin_events_list) | **GET** /api/print-nanny-plugin-events/ | 
*TelemetryApi* | [**print_nanny_plugin_events_retrieve**](docs/TelemetryApi.md#print_nanny_plugin_events_retrieve) | **GET** /api/print-nanny-plugin-events/{id}/ | 
*TelemetryApi* | [**remote_command_events_list**](docs/TelemetryApi.md#remote_command_events_list) | **GET** /api/remote-command-events/ | 
*TelemetryApi* | [**remote_command_events_retrieve**](docs/TelemetryApi.md#remote_command_events_retrieve) | **GET** /api/remote-command-events/{id}/ | 
*TelemetryApi* | [**telemetry_events_create**](docs/TelemetryApi.md#telemetry_events_create) | **POST** /api/telemetry-events/ | 
*TelemetryApi* | [**telemetry_events_list**](docs/TelemetryApi.md#telemetry_events_list) | **GET** /api/telemetry-events/ | 
*TelemetryApi* | [**telemetry_events_retrieve**](docs/TelemetryApi.md#telemetry_events_retrieve) | **GET** /api/telemetry-events/{id}/ | 
*UsersApi* | [**users_janus_auth_create**](docs/UsersApi.md#users_janus_auth_create) | **POST** /api/users/{user_id}/janus-auth/ | 
*UsersApi* | [**users_janus_auth_list**](docs/UsersApi.md#users_janus_auth_list) | **GET** /api/users/{user_id}/janus-auth/ | 
*UsersApi* | [**users_janus_auth_retrieve**](docs/UsersApi.md#users_janus_auth_retrieve) | **GET** /api/users/{user_id}/janus-auth/{id}/ | 
*UsersApi* | [**users_janus_auth_update_or_create**](docs/UsersApi.md#users_janus_auth_update_or_create) | **POST** /api/users/{user_id}/janus-auth/update-or-create/ | 
*UsersApi* | [**users_me_retrieve**](docs/UsersApi.md#users_me_retrieve) | **GET** /api/users/me/ | 
*UsersApi* | [**users_partial_update**](docs/UsersApi.md#users_partial_update) | **PATCH** /api/users/{id}/ | 
*UsersApi* | [**users_retrieve**](docs/UsersApi.md#users_retrieve) | **GET** /api/users/{id}/ | 
*UsersApi* | [**users_update**](docs/UsersApi.md#users_update) | **PUT** /api/users/{id}/ | 


## Documentation For Models

 - [Alert](docs/Alert.md)
 - [AlertBulkResponse](docs/AlertBulkResponse.md)
 - [AlertEventTypeEnum](docs/AlertEventTypeEnum.md)
 - [AlertRequest](docs/AlertRequest.md)
 - [AlphaEventSource](docs/AlphaEventSource.md)
 - [ArtifactTypesEnum](docs/ArtifactTypesEnum.md)
 - [CallbackTokenAuthRequest](docs/CallbackTokenAuthRequest.md)
 - [CallbackTokenVerification](docs/CallbackTokenVerification.md)
 - [CallbackTokenVerificationRequest](docs/CallbackTokenVerificationRequest.md)
 - [Camera](docs/Camera.md)
 - [CameraRequest](docs/CameraRequest.md)
 - [CameraType](docs/CameraType.md)
 - [CloudiotDevice](docs/CloudiotDevice.md)
 - [CloudiotDeviceRequest](docs/CloudiotDeviceRequest.md)
 - [CommandEnum](docs/CommandEnum.md)
 - [DetailResponse](docs/DetailResponse.md)
 - [Device](docs/Device.md)
 - [DeviceCalibration](docs/DeviceCalibration.md)
 - [DeviceCalibrationRequest](docs/DeviceCalibrationRequest.md)
 - [DeviceReleaseChannel](docs/DeviceReleaseChannel.md)
 - [DeviceRequest](docs/DeviceRequest.md)
 - [EmailAuthRequest](docs/EmailAuthRequest.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [EventRequest](docs/EventRequest.md)
 - [EventSource](docs/EventSource.md)
 - [EventType](docs/EventType.md)
 - [Experiment](docs/Experiment.md)
 - [ExperimentDeviceConfig](docs/ExperimentDeviceConfig.md)
 - [GcodeFile](docs/GcodeFile.md)
 - [JanusAuth](docs/JanusAuth.md)
 - [JanusAuthRequest](docs/JanusAuthRequest.md)
 - [JanusConfigType](docs/JanusConfigType.md)
 - [JanusStream](docs/JanusStream.md)
 - [JanusStreamRequest](docs/JanusStreamRequest.md)
 - [MobileAuthRequest](docs/MobileAuthRequest.md)
 - [ModelArtifact](docs/ModelArtifact.md)
 - [OctoGenericEvent](docs/OctoGenericEvent.md)
 - [OctoJobEvent](docs/OctoJobEvent.md)
 - [OctoPrintBackup](docs/OctoPrintBackup.md)
 - [OctoPrintDevice](docs/OctoPrintDevice.md)
 - [OctoPrintDeviceKey](docs/OctoPrintDeviceKey.md)
 - [OctoPrintDeviceRequest](docs/OctoPrintDeviceRequest.md)
 - [OctoPrintEvent](docs/OctoPrintEvent.md)
 - [OctoPrintEventRequest](docs/OctoPrintEventRequest.md)
 - [OctoPrintNannyEvent](docs/OctoPrintNannyEvent.md)
 - [OctoPrinterEvent](docs/OctoPrinterEvent.md)
 - [OctoTelemetryEvent](docs/OctoTelemetryEvent.md)
 - [OctoprintEnvironment](docs/OctoprintEnvironment.md)
 - [OctoprintEnvironmentRequest](docs/OctoprintEnvironmentRequest.md)
 - [OctoprintFile](docs/OctoprintFile.md)
 - [OctoprintFileRequest](docs/OctoprintFileRequest.md)
 - [OctoprintHardware](docs/OctoprintHardware.md)
 - [OctoprintHardwareRequest](docs/OctoprintHardwareRequest.md)
 - [OctoprintJob](docs/OctoprintJob.md)
 - [OctoprintJobRequest](docs/OctoprintJobRequest.md)
 - [OctoprintPiSupport](docs/OctoprintPiSupport.md)
 - [OctoprintPiSupportRequest](docs/OctoprintPiSupportRequest.md)
 - [OctoprintPlatform](docs/OctoprintPlatform.md)
 - [OctoprintPlatformRequest](docs/OctoprintPlatformRequest.md)
 - [OctoprintPrinterData](docs/OctoprintPrinterData.md)
 - [OctoprintPrinterDataRequest](docs/OctoprintPrinterDataRequest.md)
 - [OctoprintPrinterFlags](docs/OctoprintPrinterFlags.md)
 - [OctoprintPrinterFlagsRequest](docs/OctoprintPrinterFlagsRequest.md)
 - [OctoprintPrinterState](docs/OctoprintPrinterState.md)
 - [OctoprintPrinterStateRequest](docs/OctoprintPrinterStateRequest.md)
 - [OctoprintProgress](docs/OctoprintProgress.md)
 - [OctoprintProgressRequest](docs/OctoprintProgressRequest.md)
 - [OctoprintPython](docs/OctoprintPython.md)
 - [OctoprintPythonRequest](docs/OctoprintPythonRequest.md)
 - [PaginatedAlertList](docs/PaginatedAlertList.md)
 - [PaginatedCameraList](docs/PaginatedCameraList.md)
 - [PaginatedCloudiotDeviceList](docs/PaginatedCloudiotDeviceList.md)
 - [PaginatedDeviceCalibrationList](docs/PaginatedDeviceCalibrationList.md)
 - [PaginatedDeviceList](docs/PaginatedDeviceList.md)
 - [PaginatedExperimentDeviceConfigList](docs/PaginatedExperimentDeviceConfigList.md)
 - [PaginatedExperimentList](docs/PaginatedExperimentList.md)
 - [PaginatedGcodeFileList](docs/PaginatedGcodeFileList.md)
 - [PaginatedJanusAuthList](docs/PaginatedJanusAuthList.md)
 - [PaginatedJanusStreamList](docs/PaginatedJanusStreamList.md)
 - [PaginatedModelArtifactList](docs/PaginatedModelArtifactList.md)
 - [PaginatedOctoPrintBackupList](docs/PaginatedOctoPrintBackupList.md)
 - [PaginatedOctoPrintDeviceList](docs/PaginatedOctoPrintDeviceList.md)
 - [PaginatedOctoPrintEventList](docs/PaginatedOctoPrintEventList.md)
 - [PaginatedPolymorphicEventList](docs/PaginatedPolymorphicEventList.md)
 - [PaginatedPrintJobEventList](docs/PaginatedPrintJobEventList.md)
 - [PaginatedPrintNannyPluginEventList](docs/PaginatedPrintNannyPluginEventList.md)
 - [PaginatedPrintSessionList](docs/PaginatedPrintSessionList.md)
 - [PaginatedPrinterControllerList](docs/PaginatedPrinterControllerList.md)
 - [PaginatedPrinterProfileList](docs/PaginatedPrinterProfileList.md)
 - [PaginatedPublicKeyList](docs/PaginatedPublicKeyList.md)
 - [PaginatedRemoteCommandEventList](docs/PaginatedRemoteCommandEventList.md)
 - [PaginatedRemoteControlCommandList](docs/PaginatedRemoteControlCommandList.md)
 - [PaginatedSystemInfoList](docs/PaginatedSystemInfoList.md)
 - [PaginatedTelemetryEventPolymorphicList](docs/PaginatedTelemetryEventPolymorphicList.md)
 - [Partner3DGeeksAlert](docs/Partner3DGeeksAlert.md)
 - [Partner3DGeeksMetadata](docs/Partner3DGeeksMetadata.md)
 - [PatchedAlertBulkRequestRequest](docs/PatchedAlertBulkRequestRequest.md)
 - [PatchedAlertRequest](docs/PatchedAlertRequest.md)
 - [PatchedCameraRequest](docs/PatchedCameraRequest.md)
 - [PatchedCloudiotDeviceRequest](docs/PatchedCloudiotDeviceRequest.md)
 - [PatchedDeviceCalibrationRequest](docs/PatchedDeviceCalibrationRequest.md)
 - [PatchedDeviceRequest](docs/PatchedDeviceRequest.md)
 - [PatchedJanusStreamRequest](docs/PatchedJanusStreamRequest.md)
 - [PatchedOctoPrintDeviceRequest](docs/PatchedOctoPrintDeviceRequest.md)
 - [PatchedPrintSessionRequest](docs/PatchedPrintSessionRequest.md)
 - [PatchedPrinterControllerRequest](docs/PatchedPrinterControllerRequest.md)
 - [PatchedPrinterProfileRequest](docs/PatchedPrinterProfileRequest.md)
 - [PatchedPublicKeyRequest](docs/PatchedPublicKeyRequest.md)
 - [PatchedRemoteControlCommandRequest](docs/PatchedRemoteControlCommandRequest.md)
 - [PatchedSystemInfoRequest](docs/PatchedSystemInfoRequest.md)
 - [PatchedUserRequest](docs/PatchedUserRequest.md)
 - [PolymorphicEvent](docs/PolymorphicEvent.md)
 - [PrintJobEvent](docs/PrintJobEvent.md)
 - [PrintJobEventRequest](docs/PrintJobEventRequest.md)
 - [PrintNannyApiConfig](docs/PrintNannyApiConfig.md)
 - [PrintNannyPluginEvent](docs/PrintNannyPluginEvent.md)
 - [PrintNannyPluginEventRequest](docs/PrintNannyPluginEventRequest.md)
 - [PrintSession](docs/PrintSession.md)
 - [PrintSessionRequest](docs/PrintSessionRequest.md)
 - [PrinterController](docs/PrinterController.md)
 - [PrinterControllerRequest](docs/PrinterControllerRequest.md)
 - [PrinterEvent](docs/PrinterEvent.md)
 - [PrinterEventRequest](docs/PrinterEventRequest.md)
 - [PrinterProfile](docs/PrinterProfile.md)
 - [PrinterProfileRequest](docs/PrinterProfileRequest.md)
 - [PublicKey](docs/PublicKey.md)
 - [PublicKeyRequest](docs/PublicKeyRequest.md)
 - [RemoteCommandEvent](docs/RemoteCommandEvent.md)
 - [RemoteCommandEventEventTypeEnum](docs/RemoteCommandEventEventTypeEnum.md)
 - [RemoteCommandEventRequest](docs/RemoteCommandEventRequest.md)
 - [RemoteControlCommand](docs/RemoteControlCommand.md)
 - [RemoteControlCommandRequest](docs/RemoteControlCommandRequest.md)
 - [SoftwareEnum](docs/SoftwareEnum.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [SystemInfoRequest](docs/SystemInfoRequest.md)
 - [TelemetryEvent](docs/TelemetryEvent.md)
 - [TelemetryEventPolymorphic](docs/TelemetryEventPolymorphic.md)
 - [TelemetryEventPolymorphicRequest](docs/TelemetryEventPolymorphicRequest.md)
 - [TelemetryEventRequest](docs/TelemetryEventRequest.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [User](docs/User.md)
 - [UserRequest](docs/UserRequest.md)
 - [WebRtcEvent](docs/WebRtcEvent.md)
 - [WebRtcEventName](docs/WebRtcEventName.md)
 - [WebRtcEventRequest](docs/WebRtcEventRequest.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

leigh@print-nanny.com

