/*
 * printnanny-api-client
 *
 * Official API client library for print-nanny.com
 *
 * The version of the OpenAPI document: 0.0.0
 * Contact: leigh@print-nanny.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Device {
    #[serde(rename = "id")]
    pub id: i32,
    #[serde(rename = "active_cameras")]
    pub active_cameras: Vec<crate::models::Camera>,
    #[serde(rename = "active_tasks")]
    pub active_tasks: Vec<crate::models::Task>,
    #[serde(rename = "cameras")]
    pub cameras: Vec<crate::models::Camera>,
    #[serde(rename = "cloudiot_device")]
    pub cloudiot_device: Option<Box<crate::models::CloudiotDevice>>,
    #[serde(rename = "dashboard_url")]
    pub dashboard_url: String,
    #[serde(rename = "video_test_url")]
    pub video_test_url: String,
    #[serde(rename = "janus_auth")]
    pub janus_auth: Option<Box<crate::models::JanusAuth>>,
    #[serde(rename = "janus_local_url")]
    pub janus_local_url: String,
    #[serde(rename = "last_task")]
    pub last_task: Option<Box<crate::models::Task>>,
    #[serde(rename = "monitoring_active", skip_serializing_if = "Option::is_none")]
    pub monitoring_active: Option<bool>,
    #[serde(rename = "setup_complete", skip_serializing_if = "Option::is_none")]
    pub setup_complete: Option<bool>,
    #[serde(rename = "printer_controllers")]
    pub printer_controllers: Vec<crate::models::PrinterController>,
    #[serde(rename = "user")]
    pub user: Option<Box<crate::models::User>>,
    #[serde(rename = "release_channel", skip_serializing_if = "Option::is_none")]
    pub release_channel: Option<Box<crate::models::DeviceReleaseChannel>>,
    #[serde(rename = "system_info")]
    pub system_info: Option<Box<crate::models::SystemInfo>>,
    #[serde(rename = "public_key")]
    pub public_key: Option<Box<crate::models::PublicKey>>,
    #[serde(rename = "created_dt")]
    pub created_dt: String,
    #[serde(rename = "updated_dt")]
    pub updated_dt: String,
    /// Please enter the hostname you set in the Raspberry Pi Imager's Advanced Options menu (without .local extension)
    #[serde(rename = "hostname", skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
}

impl Device {
    pub fn new(id: i32, active_cameras: Vec<crate::models::Camera>, active_tasks: Vec<crate::models::Task>, cameras: Vec<crate::models::Camera>, cloudiot_device: Option<crate::models::CloudiotDevice>, dashboard_url: String, video_test_url: String, janus_auth: Option<crate::models::JanusAuth>, janus_local_url: String, last_task: Option<crate::models::Task>, printer_controllers: Vec<crate::models::PrinterController>, user: Option<crate::models::User>, system_info: Option<crate::models::SystemInfo>, public_key: Option<crate::models::PublicKey>, created_dt: String, updated_dt: String) -> Device {
        Device {
            id,
            active_cameras,
            active_tasks,
            cameras,
            cloudiot_device: cloudiot_device.map(Box::new),
            dashboard_url,
            video_test_url,
            janus_auth: janus_auth.map(Box::new),
            janus_local_url,
            last_task: last_task.map(Box::new),
            monitoring_active: None,
            setup_complete: None,
            printer_controllers,
            user: user.map(Box::new),
            release_channel: None,
            system_info: system_info.map(Box::new),
            public_key: public_key.map(Box::new),
            created_dt,
            updated_dt,
            hostname: None,
        }
    }
}


