/*
 * printnanny-api-client
 *
 * Official API client library for print-nanny.com
 *
 * The version of the OpenAPI document: 0.0.0
 * Contact: leigh@print-nanny.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Device {
    #[serde(rename = "id")]
    pub id: i32,
    #[serde(rename = "bootstrap_release")]
    pub bootstrap_release: Option<Box<crate::models::Release>>,
    #[serde(rename = "cloudiot_device")]
    pub cloudiot_device: Option<Box<crate::models::CloudiotDevice>>,
    #[serde(rename = "cameras")]
    pub cameras: Vec<crate::models::Camera>,
    #[serde(rename = "janus_local_url")]
    pub janus_local_url: String,
    #[serde(rename = "dashboard_url")]
    pub dashboard_url: String,
    #[serde(rename = "printer_controllers")]
    pub printer_controllers: Vec<crate::models::PrinterController>,
    #[serde(rename = "release_channel", skip_serializing_if = "Option::is_none")]
    pub release_channel: Option<Box<crate::models::ReleaseChannelEnum>>,
    #[serde(rename = "user")]
    pub user: Option<Box<crate::models::User>>,
    #[serde(rename = "last_task")]
    pub last_task: Option<Box<crate::models::Task>>,
    #[serde(rename = "active_tasks")]
    pub active_tasks: Vec<crate::models::Task>,
    #[serde(rename = "active_cameras")]
    pub active_cameras: Vec<crate::models::Camera>,
    #[serde(rename = "monitoring_active", skip_serializing_if = "Option::is_none")]
    pub monitoring_active: Option<bool>,
    #[serde(rename = "created_dt")]
    pub created_dt: String,
    #[serde(rename = "updated_dt")]
    pub updated_dt: String,
    /// Please enter the hostname you set in the Raspberry Pi Imager's Advanced Options menu (without .local extension)
    #[serde(rename = "hostname", skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
}

impl Device {
    pub fn new(id: i32, bootstrap_release: Option<crate::models::Release>, cloudiot_device: Option<crate::models::CloudiotDevice>, cameras: Vec<crate::models::Camera>, janus_local_url: String, dashboard_url: String, printer_controllers: Vec<crate::models::PrinterController>, user: Option<crate::models::User>, last_task: Option<crate::models::Task>, active_tasks: Vec<crate::models::Task>, active_cameras: Vec<crate::models::Camera>, created_dt: String, updated_dt: String) -> Device {
        Device {
            id,
            bootstrap_release: bootstrap_release.map(Box::new),
            cloudiot_device: cloudiot_device.map(Box::new),
            cameras,
            janus_local_url,
            dashboard_url,
            printer_controllers,
            release_channel: None,
            user: user.map(Box::new),
            last_task: last_task.map(Box::new),
            active_tasks,
            active_cameras,
            monitoring_active: None,
            created_dt,
            updated_dt,
            hostname: None,
        }
    }
}


