# Rust API client for printnanny-api-client

Official API client library for print-nanny.com

For more information, please visit [https://print-nanny.com](https://print-nanny.com)

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 0.0.0
- Package version: 0.23.2
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `printnanny-api-client` and add the following to `Cargo.toml` under `[dependencies]`:

```
printnanny-api-client = { path = "./printnanny-api-client" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertsApi* | [**alerts_list**](docs/AlertsApi.md#alerts_list) | **GET** /api/alerts/ | 
*AlertsApi* | [**alerts_partial_update**](docs/AlertsApi.md#alerts_partial_update) | **PATCH** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_recent**](docs/AlertsApi.md#alerts_recent) | **GET** /api/alerts/recent/ | 
*AlertsApi* | [**alerts_retrieve**](docs/AlertsApi.md#alerts_retrieve) | **GET** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_seen**](docs/AlertsApi.md#alerts_seen) | **PATCH** /api/alerts/seen/ | 
*AlertsApi* | [**alerts_unread**](docs/AlertsApi.md#alerts_unread) | **GET** /api/alerts/unread/ | 
*AlertsApi* | [**alerts_update**](docs/AlertsApi.md#alerts_update) | **PUT** /api/alerts/{id}/ | 
*AuthApi* | [**auth_email_create**](docs/AuthApi.md#auth_email_create) | **POST** /auth/email/ | 
*AuthApi* | [**auth_mobile_create**](docs/AuthApi.md#auth_mobile_create) | **POST** /auth/mobile/ | 
*AuthApi* | [**auth_token_create**](docs/AuthApi.md#auth_token_create) | **POST** /auth/token/ | 
*AuthApi* | [**auth_verify_create**](docs/AuthApi.md#auth_verify_create) | **POST** /auth/verify/ | 
*AuthApi* | [**auth_verify_email_create**](docs/AuthApi.md#auth_verify_email_create) | **POST** /auth/verify/email/ | 
*AuthApi* | [**auth_verify_mobile_create**](docs/AuthApi.md#auth_verify_mobile_create) | **POST** /auth/verify/mobile/ | 
*ClientConfigApi* | [**client_config_list**](docs/ClientConfigApi.md#client_config_list) | **GET** /api/client-config/ | 
*DevicesApi* | [**device_info_update_or_create**](docs/DevicesApi.md#device_info_update_or_create) | **POST** /api/devices/{device_id}/info/update-or-create/ | 
*DevicesApi* | [**devices_active_license_retrieve**](docs/DevicesApi.md#devices_active_license_retrieve) | **GET** /api/devices/{id}/active-license/ | 
*DevicesApi* | [**devices_cameras_create**](docs/DevicesApi.md#devices_cameras_create) | **POST** /api/devices/{device_id}/cameras/ | 
*DevicesApi* | [**devices_cameras_list**](docs/DevicesApi.md#devices_cameras_list) | **GET** /api/devices/{device_id}/cameras/ | 
*DevicesApi* | [**devices_cameras_partial_update**](docs/DevicesApi.md#devices_cameras_partial_update) | **PATCH** /api/devices/{device_id}/cameras/{id}/ | 
*DevicesApi* | [**devices_cameras_retrieve**](docs/DevicesApi.md#devices_cameras_retrieve) | **GET** /api/devices/{device_id}/cameras/{id}/ | 
*DevicesApi* | [**devices_cameras_update**](docs/DevicesApi.md#devices_cameras_update) | **PUT** /api/devices/{device_id}/cameras/{id}/ | 
*DevicesApi* | [**devices_cloud_iot_devices_create**](docs/DevicesApi.md#devices_cloud_iot_devices_create) | **POST** /api/devices/{device_id}/cloud-iot-devices/ | 
*DevicesApi* | [**devices_cloud_iot_devices_list**](docs/DevicesApi.md#devices_cloud_iot_devices_list) | **GET** /api/devices/{device_id}/cloud-iot-devices/ | 
*DevicesApi* | [**devices_cloud_iot_devices_partial_update**](docs/DevicesApi.md#devices_cloud_iot_devices_partial_update) | **PATCH** /api/devices/{device_id}/cloud-iot-devices/{id}/ | 
*DevicesApi* | [**devices_cloud_iot_devices_retrieve**](docs/DevicesApi.md#devices_cloud_iot_devices_retrieve) | **GET** /api/devices/{device_id}/cloud-iot-devices/{id}/ | 
*DevicesApi* | [**devices_cloud_iot_devices_update**](docs/DevicesApi.md#devices_cloud_iot_devices_update) | **PUT** /api/devices/{device_id}/cloud-iot-devices/{id}/ | 
*DevicesApi* | [**devices_config_list**](docs/DevicesApi.md#devices_config_list) | **GET** /api/devices/{device_id}/config/ | 
*DevicesApi* | [**devices_config_retrieve**](docs/DevicesApi.md#devices_config_retrieve) | **GET** /api/devices/{device_id}/config/{id}/ | 
*DevicesApi* | [**devices_create**](docs/DevicesApi.md#devices_create) | **POST** /api/devices/ | 
*DevicesApi* | [**devices_generate_license_retrieve**](docs/DevicesApi.md#devices_generate_license_retrieve) | **GET** /api/devices/{id}/generate-license/ | 
*DevicesApi* | [**devices_info_create**](docs/DevicesApi.md#devices_info_create) | **POST** /api/devices/{device_id}/info/ | 
*DevicesApi* | [**devices_info_list**](docs/DevicesApi.md#devices_info_list) | **GET** /api/devices/{device_id}/info/ | 
*DevicesApi* | [**devices_info_partial_update**](docs/DevicesApi.md#devices_info_partial_update) | **PATCH** /api/devices/{device_id}/info/{id}/ | 
*DevicesApi* | [**devices_info_retrieve**](docs/DevicesApi.md#devices_info_retrieve) | **GET** /api/devices/{device_id}/info/{id}/ | 
*DevicesApi* | [**devices_info_update**](docs/DevicesApi.md#devices_info_update) | **PUT** /api/devices/{device_id}/info/{id}/ | 
*DevicesApi* | [**devices_list**](docs/DevicesApi.md#devices_list) | **GET** /api/devices/ | 
*DevicesApi* | [**devices_partial_update**](docs/DevicesApi.md#devices_partial_update) | **PATCH** /api/devices/{id}/ | 
*DevicesApi* | [**devices_printer_controllers_create**](docs/DevicesApi.md#devices_printer_controllers_create) | **POST** /api/devices/{device_id}/printer-controllers/ | 
*DevicesApi* | [**devices_printer_controllers_list**](docs/DevicesApi.md#devices_printer_controllers_list) | **GET** /api/devices/{device_id}/printer-controllers/ | 
*DevicesApi* | [**devices_printer_controllers_partial_update**](docs/DevicesApi.md#devices_printer_controllers_partial_update) | **PATCH** /api/devices/{device_id}/printer-controllers/{id}/ | 
*DevicesApi* | [**devices_printer_controllers_retrieve**](docs/DevicesApi.md#devices_printer_controllers_retrieve) | **GET** /api/devices/{device_id}/printer-controllers/{id}/ | 
*DevicesApi* | [**devices_printer_controllers_update**](docs/DevicesApi.md#devices_printer_controllers_update) | **PUT** /api/devices/{device_id}/printer-controllers/{id}/ | 
*DevicesApi* | [**devices_retrieve**](docs/DevicesApi.md#devices_retrieve) | **GET** /api/devices/{id}/ | 
*DevicesApi* | [**devices_retrieve_hostname**](docs/DevicesApi.md#devices_retrieve_hostname) | **GET** /api/devices/{hostname} | 
*DevicesApi* | [**devices_tasks_create**](docs/DevicesApi.md#devices_tasks_create) | **POST** /api/devices/{device_id}/tasks/ | 
*DevicesApi* | [**devices_tasks_list**](docs/DevicesApi.md#devices_tasks_list) | **GET** /api/devices/{device_id}/tasks/ | 
*DevicesApi* | [**devices_tasks_retrieve**](docs/DevicesApi.md#devices_tasks_retrieve) | **GET** /api/devices/{device_id}/tasks/{id}/ | 
*DevicesApi* | [**devices_tasks_status_create**](docs/DevicesApi.md#devices_tasks_status_create) | **POST** /api/devices/{device_id}/tasks/{task_id}/status/ | 
*DevicesApi* | [**devices_tasks_status_list**](docs/DevicesApi.md#devices_tasks_status_list) | **GET** /api/devices/{device_id}/tasks/{task_id}/status/ | 
*DevicesApi* | [**devices_tasks_status_retrieve**](docs/DevicesApi.md#devices_tasks_status_retrieve) | **GET** /api/devices/{device_id}/tasks/{task_id}/status/{id}/ | 
*DevicesApi* | [**devices_update**](docs/DevicesApi.md#devices_update) | **PUT** /api/devices/{id}/ | 
*LicensesApi* | [**license_activate**](docs/LicensesApi.md#license_activate) | **POST** /api/licenses/{id}/activate/ | 
*LicensesApi* | [**licenses_list**](docs/LicensesApi.md#licenses_list) | **GET** /api/licenses/ | 
*LicensesApi* | [**licenses_retrieve**](docs/LicensesApi.md#licenses_retrieve) | **GET** /api/licenses/{id}/ | 
*MlOpsApi* | [**device_calibration_update_or_create**](docs/MlOpsApi.md#device_calibration_update_or_create) | **POST** /api/device-calibrations/update-or-create/ | 
*MlOpsApi* | [**device_calibrations_list**](docs/MlOpsApi.md#device_calibrations_list) | **GET** /api/device-calibrations/ | 
*MlOpsApi* | [**device_calibrations_partial_update**](docs/MlOpsApi.md#device_calibrations_partial_update) | **PATCH** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**device_calibrations_retrieve**](docs/MlOpsApi.md#device_calibrations_retrieve) | **GET** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**device_calibrations_update**](docs/MlOpsApi.md#device_calibrations_update) | **PUT** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**experiment_device_configs_list**](docs/MlOpsApi.md#experiment_device_configs_list) | **GET** /api/experiment-device-configs/ | 
*MlOpsApi* | [**experiment_device_configs_retrieve**](docs/MlOpsApi.md#experiment_device_configs_retrieve) | **GET** /api/experiment-device-configs/{id}/ | 
*MlOpsApi* | [**experiments_list**](docs/MlOpsApi.md#experiments_list) | **GET** /api/experiments/ | 
*MlOpsApi* | [**experiments_retrieve**](docs/MlOpsApi.md#experiments_retrieve) | **GET** /api/experiments/{id}/ | 
*MlOpsApi* | [**model_artifacts_list**](docs/MlOpsApi.md#model_artifacts_list) | **GET** /api/model-artifacts/ | 
*MlOpsApi* | [**model_artifacts_retrieve**](docs/MlOpsApi.md#model_artifacts_retrieve) | **GET** /api/model-artifacts/{id}/ | 
*PartnersGeeks3Api* | [**alerts_list2**](docs/PartnersGeeks3Api.md#alerts_list2) | **GET** /api/partners/3d-geeks/{id}/alerts/ | 
*PartnersGeeks3dApi* | [**metadata_retrieve**](docs/PartnersGeeks3dApi.md#metadata_retrieve) | **GET** /api/partners/3d-geeks/{id}/ | 
*ReleasesApi* | [**releases_latest_retrieve**](docs/ReleasesApi.md#releases_latest_retrieve) | **GET** /api/releases/{release_channel}/latest | 
*ReleasesApi* | [**releases_list**](docs/ReleasesApi.md#releases_list) | **GET** /api/releases/ | 
*ReleasesApi* | [**releases_retrieve**](docs/ReleasesApi.md#releases_retrieve) | **GET** /api/releases/{id}/ | 
*RemoteControlApi* | [**commands_list**](docs/RemoteControlApi.md#commands_list) | **GET** /api/commands/ | 
*RemoteControlApi* | [**commands_partial_update**](docs/RemoteControlApi.md#commands_partial_update) | **PATCH** /api/commands/{id}/ | 
*RemoteControlApi* | [**commands_retrieve**](docs/RemoteControlApi.md#commands_retrieve) | **GET** /api/commands/{id}/ | 
*RemoteControlApi* | [**commands_update**](docs/RemoteControlApi.md#commands_update) | **PUT** /api/commands/{id}/ | 
*RemoteControlApi* | [**gcode_files_create**](docs/RemoteControlApi.md#gcode_files_create) | **POST** /api/gcode-files/ | 
*RemoteControlApi* | [**gcode_files_list**](docs/RemoteControlApi.md#gcode_files_list) | **GET** /api/gcode-files/ | 
*RemoteControlApi* | [**gcode_files_partial_update**](docs/RemoteControlApi.md#gcode_files_partial_update) | **PATCH** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**gcode_files_retrieve**](docs/RemoteControlApi.md#gcode_files_retrieve) | **GET** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**gcode_files_update**](docs/RemoteControlApi.md#gcode_files_update) | **PUT** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**gcode_files_update_or_create**](docs/RemoteControlApi.md#gcode_files_update_or_create) | **POST** /api/gcode-files/update-or-create/ | 
*RemoteControlApi* | [**octoprint_devices_create**](docs/RemoteControlApi.md#octoprint_devices_create) | **POST** /api/octoprint-devices/ | 
*RemoteControlApi* | [**octoprint_devices_list**](docs/RemoteControlApi.md#octoprint_devices_list) | **GET** /api/octoprint-devices/ | 
*RemoteControlApi* | [**octoprint_devices_partial_update**](docs/RemoteControlApi.md#octoprint_devices_partial_update) | **PATCH** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_retrieve**](docs/RemoteControlApi.md#octoprint_devices_retrieve) | **GET** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_update**](docs/RemoteControlApi.md#octoprint_devices_update) | **PUT** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_update_or_create**](docs/RemoteControlApi.md#octoprint_devices_update_or_create) | **POST** /api/octoprint-devices/update-or-create/ | 
*RemoteControlApi* | [**print_session_partial_update**](docs/RemoteControlApi.md#print_session_partial_update) | **PATCH** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**print_session_update**](docs/RemoteControlApi.md#print_session_update) | **PUT** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**print_sessions_create**](docs/RemoteControlApi.md#print_sessions_create) | **POST** /api/print-sessions/ | 
*RemoteControlApi* | [**print_sessions_list**](docs/RemoteControlApi.md#print_sessions_list) | **GET** /api/print-sessions/ | 
*RemoteControlApi* | [**print_sessions_retrieve**](docs/RemoteControlApi.md#print_sessions_retrieve) | **GET** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**printer_profiles_create**](docs/RemoteControlApi.md#printer_profiles_create) | **POST** /api/printer-profiles/ | 
*RemoteControlApi* | [**printer_profiles_list**](docs/RemoteControlApi.md#printer_profiles_list) | **GET** /api/printer-profiles/ | 
*RemoteControlApi* | [**printer_profiles_partial_update**](docs/RemoteControlApi.md#printer_profiles_partial_update) | **PATCH** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**printer_profiles_retrieve**](docs/RemoteControlApi.md#printer_profiles_retrieve) | **GET** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**printer_profiles_update**](docs/RemoteControlApi.md#printer_profiles_update) | **PUT** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**printer_profiles_update_or_create**](docs/RemoteControlApi.md#printer_profiles_update_or_create) | **POST** /api/printer-profiles/update-or-create/ | 
*SchemaApi* | [**schema_retrieve**](docs/SchemaApi.md#schema_retrieve) | **GET** /api/schema/ | 
*TelemetryApi* | [**octoprint_events_create**](docs/TelemetryApi.md#octoprint_events_create) | **POST** /api/octoprint-events/ | 
*TelemetryApi* | [**octoprint_events_list**](docs/TelemetryApi.md#octoprint_events_list) | **GET** /api/octoprint-events/ | 
*TelemetryApi* | [**octoprint_events_retrieve**](docs/TelemetryApi.md#octoprint_events_retrieve) | **GET** /api/octoprint-events/{id}/ | 
*TelemetryApi* | [**print_job_events_list**](docs/TelemetryApi.md#print_job_events_list) | **GET** /api/print-job-events/ | 
*TelemetryApi* | [**print_job_events_retrieve**](docs/TelemetryApi.md#print_job_events_retrieve) | **GET** /api/print-job-events/{id}/ | 
*TelemetryApi* | [**print_nanny_plugin_events_list**](docs/TelemetryApi.md#print_nanny_plugin_events_list) | **GET** /api/print-nanny-plugin-events/ | 
*TelemetryApi* | [**print_nanny_plugin_events_retrieve**](docs/TelemetryApi.md#print_nanny_plugin_events_retrieve) | **GET** /api/print-nanny-plugin-events/{id}/ | 
*TelemetryApi* | [**remote_command_events_list**](docs/TelemetryApi.md#remote_command_events_list) | **GET** /api/remote-command-events/ | 
*TelemetryApi* | [**remote_command_events_retrieve**](docs/TelemetryApi.md#remote_command_events_retrieve) | **GET** /api/remote-command-events/{id}/ | 
*TelemetryApi* | [**telemetry_events_create**](docs/TelemetryApi.md#telemetry_events_create) | **POST** /api/telemetry-events/ | 
*TelemetryApi* | [**telemetry_events_list**](docs/TelemetryApi.md#telemetry_events_list) | **GET** /api/telemetry-events/ | 
*TelemetryApi* | [**telemetry_events_retrieve**](docs/TelemetryApi.md#telemetry_events_retrieve) | **GET** /api/telemetry-events/{id}/ | 
*UsersApi* | [**users_list**](docs/UsersApi.md#users_list) | **GET** /api/users/ | 
*UsersApi* | [**users_me_retrieve**](docs/UsersApi.md#users_me_retrieve) | **GET** /api/users/me/ | 
*UsersApi* | [**users_partial_update**](docs/UsersApi.md#users_partial_update) | **PATCH** /api/users/{id}/ | 
*UsersApi* | [**users_retrieve**](docs/UsersApi.md#users_retrieve) | **GET** /api/users/{id}/ | 
*UsersApi* | [**users_update**](docs/UsersApi.md#users_update) | **PUT** /api/users/{id}/ | 


## Documentation For Models

 - [Alert](docs/Alert.md)
 - [AlertBulkResponse](docs/AlertBulkResponse.md)
 - [AlertEventTypeEnum](docs/AlertEventTypeEnum.md)
 - [AlertRequest](docs/AlertRequest.md)
 - [AnsibleExtraVars](docs/AnsibleExtraVars.md)
 - [AnsibleExtraVarsRequest](docs/AnsibleExtraVarsRequest.md)
 - [ArtifactTypesEnum](docs/ArtifactTypesEnum.md)
 - [CallbackTokenAuthRequest](docs/CallbackTokenAuthRequest.md)
 - [CallbackTokenVerification](docs/CallbackTokenVerification.md)
 - [CallbackTokenVerificationRequest](docs/CallbackTokenVerificationRequest.md)
 - [Camera](docs/Camera.md)
 - [CameraRequest](docs/CameraRequest.md)
 - [CameraType](docs/CameraType.md)
 - [CloudiotDevice](docs/CloudiotDevice.md)
 - [CloudiotDeviceRequest](docs/CloudiotDeviceRequest.md)
 - [CommandEnum](docs/CommandEnum.md)
 - [DetailResponse](docs/DetailResponse.md)
 - [Device](docs/Device.md)
 - [DeviceCalibration](docs/DeviceCalibration.md)
 - [DeviceCalibrationRequest](docs/DeviceCalibrationRequest.md)
 - [DeviceConfig](docs/DeviceConfig.md)
 - [DeviceInfo](docs/DeviceInfo.md)
 - [DeviceInfoRequest](docs/DeviceInfoRequest.md)
 - [DeviceRequest](docs/DeviceRequest.md)
 - [EmailAuthRequest](docs/EmailAuthRequest.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [EventSourceEnum](docs/EventSourceEnum.md)
 - [EventType0c4Enum](docs/EventType0c4Enum.md)
 - [Experiment](docs/Experiment.md)
 - [ExperimentDeviceConfig](docs/ExperimentDeviceConfig.md)
 - [GcodeFile](docs/GcodeFile.md)
 - [License](docs/License.md)
 - [LicenseRequest](docs/LicenseRequest.md)
 - [MobileAuthRequest](docs/MobileAuthRequest.md)
 - [ModelArtifact](docs/ModelArtifact.md)
 - [OctoPrintDevice](docs/OctoPrintDevice.md)
 - [OctoPrintDeviceKey](docs/OctoPrintDeviceKey.md)
 - [OctoPrintDeviceRequest](docs/OctoPrintDeviceRequest.md)
 - [OctoPrintEvent](docs/OctoPrintEvent.md)
 - [OctoPrintEventEventTypeEnum](docs/OctoPrintEventEventTypeEnum.md)
 - [OctoPrintEventRequest](docs/OctoPrintEventRequest.md)
 - [OctoprintEnvironment](docs/OctoprintEnvironment.md)
 - [OctoprintEnvironmentRequest](docs/OctoprintEnvironmentRequest.md)
 - [OctoprintFile](docs/OctoprintFile.md)
 - [OctoprintFileRequest](docs/OctoprintFileRequest.md)
 - [OctoprintHardware](docs/OctoprintHardware.md)
 - [OctoprintHardwareRequest](docs/OctoprintHardwareRequest.md)
 - [OctoprintJob](docs/OctoprintJob.md)
 - [OctoprintJobRequest](docs/OctoprintJobRequest.md)
 - [OctoprintPiSupport](docs/OctoprintPiSupport.md)
 - [OctoprintPiSupportRequest](docs/OctoprintPiSupportRequest.md)
 - [OctoprintPlatform](docs/OctoprintPlatform.md)
 - [OctoprintPlatformRequest](docs/OctoprintPlatformRequest.md)
 - [OctoprintPrinterData](docs/OctoprintPrinterData.md)
 - [OctoprintPrinterDataRequest](docs/OctoprintPrinterDataRequest.md)
 - [OctoprintPrinterFlags](docs/OctoprintPrinterFlags.md)
 - [OctoprintPrinterFlagsRequest](docs/OctoprintPrinterFlagsRequest.md)
 - [OctoprintPrinterState](docs/OctoprintPrinterState.md)
 - [OctoprintPrinterStateRequest](docs/OctoprintPrinterStateRequest.md)
 - [OctoprintProgress](docs/OctoprintProgress.md)
 - [OctoprintProgressRequest](docs/OctoprintProgressRequest.md)
 - [OctoprintPython](docs/OctoprintPython.md)
 - [OctoprintPythonRequest](docs/OctoprintPythonRequest.md)
 - [PaginatedAlertList](docs/PaginatedAlertList.md)
 - [PaginatedCameraList](docs/PaginatedCameraList.md)
 - [PaginatedCloudiotDeviceList](docs/PaginatedCloudiotDeviceList.md)
 - [PaginatedDeviceCalibrationList](docs/PaginatedDeviceCalibrationList.md)
 - [PaginatedDeviceConfigList](docs/PaginatedDeviceConfigList.md)
 - [PaginatedDeviceInfoList](docs/PaginatedDeviceInfoList.md)
 - [PaginatedDeviceList](docs/PaginatedDeviceList.md)
 - [PaginatedExperimentDeviceConfigList](docs/PaginatedExperimentDeviceConfigList.md)
 - [PaginatedExperimentList](docs/PaginatedExperimentList.md)
 - [PaginatedGcodeFileList](docs/PaginatedGcodeFileList.md)
 - [PaginatedLicenseList](docs/PaginatedLicenseList.md)
 - [PaginatedModelArtifactList](docs/PaginatedModelArtifactList.md)
 - [PaginatedOctoPrintDeviceList](docs/PaginatedOctoPrintDeviceList.md)
 - [PaginatedOctoPrintEventList](docs/PaginatedOctoPrintEventList.md)
 - [PaginatedPrintJobEventList](docs/PaginatedPrintJobEventList.md)
 - [PaginatedPrintNannyPluginEventList](docs/PaginatedPrintNannyPluginEventList.md)
 - [PaginatedPrintSessionList](docs/PaginatedPrintSessionList.md)
 - [PaginatedPrinterControllerList](docs/PaginatedPrinterControllerList.md)
 - [PaginatedPrinterProfileList](docs/PaginatedPrinterProfileList.md)
 - [PaginatedReleaseList](docs/PaginatedReleaseList.md)
 - [PaginatedRemoteCommandEventList](docs/PaginatedRemoteCommandEventList.md)
 - [PaginatedRemoteControlCommandList](docs/PaginatedRemoteControlCommandList.md)
 - [PaginatedTaskList](docs/PaginatedTaskList.md)
 - [PaginatedTaskStatusList](docs/PaginatedTaskStatusList.md)
 - [PaginatedTelemetryEventPolymorphicList](docs/PaginatedTelemetryEventPolymorphicList.md)
 - [PaginatedUserList](docs/PaginatedUserList.md)
 - [Partner3DGeeksAlert](docs/Partner3DGeeksAlert.md)
 - [Partner3DGeeksMetadata](docs/Partner3DGeeksMetadata.md)
 - [PatchedAlertBulkRequestRequest](docs/PatchedAlertBulkRequestRequest.md)
 - [PatchedAlertRequest](docs/PatchedAlertRequest.md)
 - [PatchedCameraRequest](docs/PatchedCameraRequest.md)
 - [PatchedCloudiotDeviceRequest](docs/PatchedCloudiotDeviceRequest.md)
 - [PatchedDeviceCalibrationRequest](docs/PatchedDeviceCalibrationRequest.md)
 - [PatchedDeviceInfoRequest](docs/PatchedDeviceInfoRequest.md)
 - [PatchedDeviceRequest](docs/PatchedDeviceRequest.md)
 - [PatchedOctoPrintDeviceRequest](docs/PatchedOctoPrintDeviceRequest.md)
 - [PatchedPrintSessionRequest](docs/PatchedPrintSessionRequest.md)
 - [PatchedPrinterControllerRequest](docs/PatchedPrinterControllerRequest.md)
 - [PatchedPrinterProfileRequest](docs/PatchedPrinterProfileRequest.md)
 - [PatchedRemoteControlCommandRequest](docs/PatchedRemoteControlCommandRequest.md)
 - [PatchedUserRequest](docs/PatchedUserRequest.md)
 - [PrintJobEvent](docs/PrintJobEvent.md)
 - [PrintJobEventRequest](docs/PrintJobEventRequest.md)
 - [PrintJobEventType](docs/PrintJobEventType.md)
 - [PrintNannyApiConfig](docs/PrintNannyApiConfig.md)
 - [PrintNannyPluginEvent](docs/PrintNannyPluginEvent.md)
 - [PrintNannyPluginEventEventTypeEnum](docs/PrintNannyPluginEventEventTypeEnum.md)
 - [PrintNannyPluginEventRequest](docs/PrintNannyPluginEventRequest.md)
 - [PrintSession](docs/PrintSession.md)
 - [PrintSessionRequest](docs/PrintSessionRequest.md)
 - [PrinterController](docs/PrinterController.md)
 - [PrinterControllerRequest](docs/PrinterControllerRequest.md)
 - [PrinterEvent](docs/PrinterEvent.md)
 - [PrinterEventRequest](docs/PrinterEventRequest.md)
 - [PrinterProfile](docs/PrinterProfile.md)
 - [PrinterProfileRequest](docs/PrinterProfileRequest.md)
 - [PrinterStateEnum](docs/PrinterStateEnum.md)
 - [Release](docs/Release.md)
 - [ReleaseChannelEnum](docs/ReleaseChannelEnum.md)
 - [ReleaseRequest](docs/ReleaseRequest.md)
 - [RemoteCommandEvent](docs/RemoteCommandEvent.md)
 - [RemoteCommandEventEventTypeEnum](docs/RemoteCommandEventEventTypeEnum.md)
 - [RemoteCommandEventRequest](docs/RemoteCommandEventRequest.md)
 - [RemoteControlCommand](docs/RemoteControlCommand.md)
 - [RemoteControlCommandRequest](docs/RemoteControlCommandRequest.md)
 - [SoftwareEnum](docs/SoftwareEnum.md)
 - [Task](docs/Task.md)
 - [TaskRequest](docs/TaskRequest.md)
 - [TaskStatus](docs/TaskStatus.md)
 - [TaskStatusRequest](docs/TaskStatusRequest.md)
 - [TaskStatusType](docs/TaskStatusType.md)
 - [TaskType](docs/TaskType.md)
 - [TelemetryEvent](docs/TelemetryEvent.md)
 - [TelemetryEventEventTypeEnum](docs/TelemetryEventEventTypeEnum.md)
 - [TelemetryEventPolymorphic](docs/TelemetryEventPolymorphic.md)
 - [TelemetryEventPolymorphicRequest](docs/TelemetryEventPolymorphicRequest.md)
 - [TelemetryEventRequest](docs/TelemetryEventRequest.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [User](docs/User.md)
 - [UserRequest](docs/UserRequest.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

leigh@print-nanny.com

