/*
 * printnanny-api-client
 *
 * Official API client library for print-nanny.com
 *
 * The version of the OpenAPI document: 0.0.0
 * Contact: leigh@print-nanny.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Device {
    #[serde(rename = "id")]
    pub id: i32,
    #[serde(rename = "bootstrap_release")]
    pub bootstrap_release: Option<Box<crate::models::Release>>,
    #[serde(rename = "cloudiot_device")]
    pub cloudiot_device: Option<Box<crate::models::CloudiotDevice>>,
    #[serde(rename = "cameras")]
    pub cameras: Vec<crate::models::Camera>,
    #[serde(rename = "dashboard_url")]
    pub dashboard_url: String,
    #[serde(rename = "last_system_task")]
    pub last_system_task: Option<Box<crate::models::Task>>,
    #[serde(rename = "printer_controllers")]
    pub printer_controllers: Vec<crate::models::PrinterController>,
    #[serde(rename = "release_channel", skip_serializing_if = "Option::is_none")]
    pub release_channel: Option<Box<crate::models::ReleaseChannelEnum>>,
    #[serde(rename = "user")]
    pub user: Option<Box<crate::models::User>>,
    #[serde(rename = "active_license")]
    pub active_license: Option<Box<crate::models::License>>,
    #[serde(rename = "created_dt")]
    pub created_dt: String,
    #[serde(rename = "updated_dt")]
    pub updated_dt: String,
    /// Please enter the hostname you set in the Raspberry Pi Imager's Advanced Options menu (without .local extension)
    #[serde(rename = "hostname", skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
}

impl Device {
    pub fn new(id: i32, bootstrap_release: Option<crate::models::Release>, cloudiot_device: Option<crate::models::CloudiotDevice>, cameras: Vec<crate::models::Camera>, dashboard_url: String, last_system_task: Option<crate::models::Task>, printer_controllers: Vec<crate::models::PrinterController>, user: Option<crate::models::User>, active_license: Option<crate::models::License>, created_dt: String, updated_dt: String) -> Device {
        Device {
            id,
            bootstrap_release: bootstrap_release.map(Box::new),
            cloudiot_device: cloudiot_device.map(Box::new),
            cameras,
            dashboard_url,
            last_system_task: last_system_task.map(Box::new),
            printer_controllers,
            release_channel: None,
            user: user.map(Box::new),
            active_license: active_license.map(Box::new),
            created_dt,
            updated_dt,
            hostname: None,
        }
    }
}


