# \DevicesApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**devices_create**](DevicesApi.md#devices_create) | **post** /api/devices/ | 
[**devices_list**](DevicesApi.md#devices_list) | **get** /api/devices/ | 
[**devices_partial_update**](DevicesApi.md#devices_partial_update) | **patch** /api/devices/{id}/ | 
[**devices_printer_profiles_create**](DevicesApi.md#devices_printer_profiles_create) | **post** /api/devices/{device_id}/printer-profiles/ | 
[**devices_printer_profiles_list**](DevicesApi.md#devices_printer_profiles_list) | **get** /api/devices/{device_id}/printer-profiles/ | 
[**devices_printer_profiles_partial_update**](DevicesApi.md#devices_printer_profiles_partial_update) | **patch** /api/devices/{device_id}/printer-profiles/{id}/ | 
[**devices_printer_profiles_retrieve**](DevicesApi.md#devices_printer_profiles_retrieve) | **get** /api/devices/{device_id}/printer-profiles/{id}/ | 
[**devices_printer_profiles_update**](DevicesApi.md#devices_printer_profiles_update) | **put** /api/devices/{device_id}/printer-profiles/{id}/ | 
[**devices_retrieve**](DevicesApi.md#devices_retrieve) | **get** /api/devices/{id}/ | 
[**devices_update**](DevicesApi.md#devices_update) | **put** /api/devices/{id}/ | 
[**devices_update_or_create**](DevicesApi.md#devices_update_or_create) | **post** /api/devices/update-or-create/ | 



## devices_create

> crate::models::Device devices_create(device_request)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**device_request** | [**DeviceRequest**](DeviceRequest.md) |  | [required] |

### Return type

[**crate::models::Device**](Device.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_list

> crate::models::PaginatedDeviceList devices_list(page)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**page** | Option<**i32**> | A page number within the paginated result set. |  |

### Return type

[**crate::models::PaginatedDeviceList**](PaginatedDeviceList.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_partial_update

> crate::models::Device devices_partial_update(id, patched_device_request)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**id** | **i32** | A unique integer value identifying this device. | [required] |
**patched_device_request** | Option<[**PatchedDeviceRequest**](PatchedDeviceRequest.md)> |  |  |

### Return type

[**crate::models::Device**](Device.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_printer_profiles_create

> crate::models::PrinterProfilePolymorphic devices_printer_profiles_create(device_id, printer_profile_polymorphic_request)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**device_id** | **String** |  | [required] |
**printer_profile_polymorphic_request** | Option<[**PrinterProfilePolymorphicRequest**](PrinterProfilePolymorphicRequest.md)> |  |  |

### Return type

[**crate::models::PrinterProfilePolymorphic**](PrinterProfilePolymorphic.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_printer_profiles_list

> crate::models::PaginatedPrinterProfilePolymorphicList devices_printer_profiles_list(device_id, page)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**device_id** | **String** |  | [required] |
**page** | Option<**i32**> | A page number within the paginated result set. |  |

### Return type

[**crate::models::PaginatedPrinterProfilePolymorphicList**](PaginatedPrinterProfilePolymorphicList.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_printer_profiles_partial_update

> crate::models::PrinterProfilePolymorphic devices_printer_profiles_partial_update(device_id, id, patched_printer_profile_polymorphic_request)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**device_id** | **String** |  | [required] |
**id** | **i32** | A unique integer value identifying this device. | [required] |
**patched_printer_profile_polymorphic_request** | Option<[**PatchedPrinterProfilePolymorphicRequest**](PatchedPrinterProfilePolymorphicRequest.md)> |  |  |

### Return type

[**crate::models::PrinterProfilePolymorphic**](PrinterProfilePolymorphic.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_printer_profiles_retrieve

> crate::models::PrinterProfilePolymorphic devices_printer_profiles_retrieve(device_id, id)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**device_id** | **String** |  | [required] |
**id** | **i32** | A unique integer value identifying this device. | [required] |

### Return type

[**crate::models::PrinterProfilePolymorphic**](PrinterProfilePolymorphic.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_printer_profiles_update

> crate::models::PrinterProfilePolymorphic devices_printer_profiles_update(device_id, id, printer_profile_polymorphic_request)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**device_id** | **String** |  | [required] |
**id** | **i32** | A unique integer value identifying this device. | [required] |
**printer_profile_polymorphic_request** | Option<[**PrinterProfilePolymorphicRequest**](PrinterProfilePolymorphicRequest.md)> |  |  |

### Return type

[**crate::models::PrinterProfilePolymorphic**](PrinterProfilePolymorphic.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_retrieve

> crate::models::Device devices_retrieve(id)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**id** | **i32** | A unique integer value identifying this device. | [required] |

### Return type

[**crate::models::Device**](Device.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_update

> crate::models::Device devices_update(id, device_request)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**id** | **i32** | A unique integer value identifying this device. | [required] |
**device_request** | [**DeviceRequest**](DeviceRequest.md) |  | [required] |

### Return type

[**crate::models::Device**](Device.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## devices_update_or_create

> crate::models::DeviceIdentity devices_update_or_create(device_request)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**device_request** | [**DeviceRequest**](DeviceRequest.md) |  | [required] |

### Return type

[**crate::models::DeviceIdentity**](DeviceIdentity.md)

### Authorization

[cookieAuth](../README.md#cookieAuth), [tokenAuth](../README.md#tokenAuth)

### HTTP request headers

- **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

