# Rust API client for print-nanny-client

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 0.0.0
- Package version: 0.8.5-dev2
- Build package: org.openapitools.codegen.languages.RustClientCodegen

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertsApi* | [**alerts_recent**](docs/AlertsApi.md#alerts_recent) | **get** /api/alerts/recent/ | 
*AlertsApi* | [**alerts_seen**](docs/AlertsApi.md#alerts_seen) | **patch** /api/alerts/seen/ | 
*AlertsApi* | [**alerts_unread**](docs/AlertsApi.md#alerts_unread) | **get** /api/alerts/unread/ | 
*ApiApi* | [**api_alerts_list**](docs/ApiApi.md#api_alerts_list) | **get** /api/alerts/ | 
*ApiApi* | [**api_alerts_partial_update**](docs/ApiApi.md#api_alerts_partial_update) | **patch** /api/alerts/{id}/ | 
*ApiApi* | [**api_alerts_retrieve**](docs/ApiApi.md#api_alerts_retrieve) | **get** /api/alerts/{id}/ | 
*ApiApi* | [**api_alerts_update**](docs/ApiApi.md#api_alerts_update) | **put** /api/alerts/{id}/ | 
*ApiApi* | [**api_auth_token_create**](docs/ApiApi.md#api_auth_token_create) | **post** /api/auth-token/ | 
*ApiApi* | [**api_schema_retrieve**](docs/ApiApi.md#api_schema_retrieve) | **get** /api/schema/ | 
*AuthApi* | [**auth_email_create**](docs/AuthApi.md#auth_email_create) | **post** /auth/email/ | 
*AuthApi* | [**auth_mobile_create**](docs/AuthApi.md#auth_mobile_create) | **post** /auth/mobile/ | 
*AuthApi* | [**auth_token_create**](docs/AuthApi.md#auth_token_create) | **post** /auth/token/ | 
*AuthApi* | [**auth_verify_create**](docs/AuthApi.md#auth_verify_create) | **post** /auth/verify/ | 
*AuthApi* | [**auth_verify_email_create**](docs/AuthApi.md#auth_verify_email_create) | **post** /auth/verify/email/ | 
*AuthApi* | [**auth_verify_mobile_create**](docs/AuthApi.md#auth_verify_mobile_create) | **post** /auth/verify/mobile/ | 
*DevicesApi* | [**api_devices_create**](docs/DevicesApi.md#api_devices_create) | **post** /api/devices/ | 
*DevicesApi* | [**api_devices_list**](docs/DevicesApi.md#api_devices_list) | **get** /api/devices/ | 
*DevicesApi* | [**api_devices_retrieve**](docs/DevicesApi.md#api_devices_retrieve) | **get** /api/devices/{id}/ | 
*DevicesApi* | [**devices_partial_update**](docs/DevicesApi.md#devices_partial_update) | **patch** /api/devices/{id}/ | 
*DevicesApi* | [**devices_update**](docs/DevicesApi.md#devices_update) | **put** /api/devices/{id}/ | 
*DevicesApi* | [**devices_update_or_create**](docs/DevicesApi.md#devices_update_or_create) | **post** /api/devices/update-or-create/ | 
*MlOpsApi* | [**api_device_calibrations_list**](docs/MlOpsApi.md#api_device_calibrations_list) | **get** /api/device-calibrations/ | 
*MlOpsApi* | [**api_device_calibrations_partial_update**](docs/MlOpsApi.md#api_device_calibrations_partial_update) | **patch** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**api_device_calibrations_retrieve**](docs/MlOpsApi.md#api_device_calibrations_retrieve) | **get** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**api_device_calibrations_update**](docs/MlOpsApi.md#api_device_calibrations_update) | **put** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**api_experiment_device_configs_list**](docs/MlOpsApi.md#api_experiment_device_configs_list) | **get** /api/experiment-device-configs/ | 
*MlOpsApi* | [**api_experiment_device_configs_retrieve**](docs/MlOpsApi.md#api_experiment_device_configs_retrieve) | **get** /api/experiment-device-configs/{id}/ | 
*MlOpsApi* | [**api_experiments_list**](docs/MlOpsApi.md#api_experiments_list) | **get** /api/experiments/ | 
*MlOpsApi* | [**api_experiments_retrieve**](docs/MlOpsApi.md#api_experiments_retrieve) | **get** /api/experiments/{id}/ | 
*MlOpsApi* | [**api_model_artifacts_list**](docs/MlOpsApi.md#api_model_artifacts_list) | **get** /api/model-artifacts/ | 
*MlOpsApi* | [**api_model_artifacts_retrieve**](docs/MlOpsApi.md#api_model_artifacts_retrieve) | **get** /api/model-artifacts/{id}/ | 
*MlOpsApi* | [**device_calibration_update_or_create**](docs/MlOpsApi.md#device_calibration_update_or_create) | **post** /api/device-calibrations/update-or-create/ | 
*PartnersGeeks3Api* | [**alerts_list**](docs/PartnersGeeks3Api.md#alerts_list) | **get** /api/partners/3d-geeks/{id}/alerts/ | 
*PartnersGeeks3dApi* | [**metadata_retrieve**](docs/PartnersGeeks3dApi.md#metadata_retrieve) | **get** /api/partners/3d-geeks/{id}/ | 
*RemoteControlApi* | [**api_commands_list**](docs/RemoteControlApi.md#api_commands_list) | **get** /api/commands/ | 
*RemoteControlApi* | [**api_commands_partial_update**](docs/RemoteControlApi.md#api_commands_partial_update) | **patch** /api/commands/{id}/ | 
*RemoteControlApi* | [**api_commands_retrieve**](docs/RemoteControlApi.md#api_commands_retrieve) | **get** /api/commands/{id}/ | 
*RemoteControlApi* | [**api_commands_update**](docs/RemoteControlApi.md#api_commands_update) | **put** /api/commands/{id}/ | 
*RemoteControlApi* | [**api_gcode_files_list**](docs/RemoteControlApi.md#api_gcode_files_list) | **get** /api/gcode-files/ | 
*RemoteControlApi* | [**api_gcode_files_partial_update**](docs/RemoteControlApi.md#api_gcode_files_partial_update) | **patch** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**api_gcode_files_retrieve**](docs/RemoteControlApi.md#api_gcode_files_retrieve) | **get** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**api_gcode_files_update**](docs/RemoteControlApi.md#api_gcode_files_update) | **put** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**api_octoprint_devices_create**](docs/RemoteControlApi.md#api_octoprint_devices_create) | **post** /api/octoprint-devices/ | 
*RemoteControlApi* | [**api_octoprint_devices_list**](docs/RemoteControlApi.md#api_octoprint_devices_list) | **get** /api/octoprint-devices/ | 
*RemoteControlApi* | [**api_octoprint_devices_retrieve**](docs/RemoteControlApi.md#api_octoprint_devices_retrieve) | **get** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**api_print_sessions_create**](docs/RemoteControlApi.md#api_print_sessions_create) | **post** /api/print-sessions/ | 
*RemoteControlApi* | [**api_print_sessions_list**](docs/RemoteControlApi.md#api_print_sessions_list) | **get** /api/print-sessions/ | 
*RemoteControlApi* | [**api_print_sessions_retrieve**](docs/RemoteControlApi.md#api_print_sessions_retrieve) | **get** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**api_printer_profiles_list**](docs/RemoteControlApi.md#api_printer_profiles_list) | **get** /api/printer-profiles/ | 
*RemoteControlApi* | [**api_printer_profiles_partial_update**](docs/RemoteControlApi.md#api_printer_profiles_partial_update) | **patch** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**api_printer_profiles_retrieve**](docs/RemoteControlApi.md#api_printer_profiles_retrieve) | **get** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**api_printer_profiles_update**](docs/RemoteControlApi.md#api_printer_profiles_update) | **put** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**gcode_files_create**](docs/RemoteControlApi.md#gcode_files_create) | **post** /api/gcode-files/ | 
*RemoteControlApi* | [**gcode_files_update_or_create**](docs/RemoteControlApi.md#gcode_files_update_or_create) | **post** /api/gcode-files/update-or-create/ | 
*RemoteControlApi* | [**octoprint_devices_partial_update**](docs/RemoteControlApi.md#octoprint_devices_partial_update) | **patch** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_update**](docs/RemoteControlApi.md#octoprint_devices_update) | **put** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_update_or_create**](docs/RemoteControlApi.md#octoprint_devices_update_or_create) | **post** /api/octoprint-devices/update-or-create/ | 
*RemoteControlApi* | [**print_session_partial_update**](docs/RemoteControlApi.md#print_session_partial_update) | **patch** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**print_session_update**](docs/RemoteControlApi.md#print_session_update) | **put** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**printer_profiles_create**](docs/RemoteControlApi.md#printer_profiles_create) | **post** /api/printer-profiles/ | 
*RemoteControlApi* | [**printer_profiles_update_or_create**](docs/RemoteControlApi.md#printer_profiles_update_or_create) | **post** /api/printer-profiles/update-or-create/ | 
*TelemetryApi* | [**api_octoprint_events_create**](docs/TelemetryApi.md#api_octoprint_events_create) | **post** /api/octoprint-events/ | 
*TelemetryApi* | [**api_octoprint_events_list**](docs/TelemetryApi.md#api_octoprint_events_list) | **get** /api/octoprint-events/ | 
*TelemetryApi* | [**api_octoprint_events_retrieve**](docs/TelemetryApi.md#api_octoprint_events_retrieve) | **get** /api/octoprint-events/{id}/ | 
*TelemetryApi* | [**api_print_job_events_list**](docs/TelemetryApi.md#api_print_job_events_list) | **get** /api/print-job-events/ | 
*TelemetryApi* | [**api_print_job_events_retrieve**](docs/TelemetryApi.md#api_print_job_events_retrieve) | **get** /api/print-job-events/{id}/ | 
*TelemetryApi* | [**api_print_nanny_plugin_events_list**](docs/TelemetryApi.md#api_print_nanny_plugin_events_list) | **get** /api/print-nanny-plugin-events/ | 
*TelemetryApi* | [**api_print_nanny_plugin_events_retrieve**](docs/TelemetryApi.md#api_print_nanny_plugin_events_retrieve) | **get** /api/print-nanny-plugin-events/{id}/ | 
*TelemetryApi* | [**api_remote_command_events_list**](docs/TelemetryApi.md#api_remote_command_events_list) | **get** /api/remote-command-events/ | 
*TelemetryApi* | [**api_remote_command_events_retrieve**](docs/TelemetryApi.md#api_remote_command_events_retrieve) | **get** /api/remote-command-events/{id}/ | 
*TelemetryApi* | [**api_telemetry_events_list**](docs/TelemetryApi.md#api_telemetry_events_list) | **get** /api/telemetry-events/ | 
*TelemetryApi* | [**api_telemetry_events_retrieve**](docs/TelemetryApi.md#api_telemetry_events_retrieve) | **get** /api/telemetry-events/{id}/ | 
*UsersApi* | [**api_users_list**](docs/UsersApi.md#api_users_list) | **get** /api/users/ | 
*UsersApi* | [**api_users_me_retrieve**](docs/UsersApi.md#api_users_me_retrieve) | **get** /api/users/me/ | 
*UsersApi* | [**api_users_partial_update**](docs/UsersApi.md#api_users_partial_update) | **patch** /api/users/{id}/ | 
*UsersApi* | [**api_users_retrieve**](docs/UsersApi.md#api_users_retrieve) | **get** /api/users/{id}/ | 
*UsersApi* | [**api_users_update**](docs/UsersApi.md#api_users_update) | **put** /api/users/{id}/ | 


## Documentation For Models

 - [Alert](docs/Alert.md)
 - [AlertBulkResponse](docs/AlertBulkResponse.md)
 - [AlertEventTypeEnum](docs/AlertEventTypeEnum.md)
 - [AlertMethodEnum](docs/AlertMethodEnum.md)
 - [AlertRequest](docs/AlertRequest.md)
 - [ArtifactTypesEnum](docs/ArtifactTypesEnum.md)
 - [AuthToken](docs/AuthToken.md)
 - [AuthTokenRequest](docs/AuthTokenRequest.md)
 - [CallbackTokenAuthRequest](docs/CallbackTokenAuthRequest.md)
 - [CallbackTokenVerification](docs/CallbackTokenVerification.md)
 - [CallbackTokenVerificationRequest](docs/CallbackTokenVerificationRequest.md)
 - [CommandEnum](docs/CommandEnum.md)
 - [DetailResponse](docs/DetailResponse.md)
 - [Device](docs/Device.md)
 - [DeviceCalibration](docs/DeviceCalibration.md)
 - [DeviceCalibrationRequest](docs/DeviceCalibrationRequest.md)
 - [DeviceIdentity](docs/DeviceIdentity.md)
 - [DeviceIdentityCaCerts](docs/DeviceIdentityCaCerts.md)
 - [DeviceRequest](docs/DeviceRequest.md)
 - [EmailAuthRequest](docs/EmailAuthRequest.md)
 - [EventSourceEnum](docs/EventSourceEnum.md)
 - [EventType0c4Enum](docs/EventType0c4Enum.md)
 - [EventTypeD9eEnum](docs/EventTypeD9eEnum.md)
 - [Experiment](docs/Experiment.md)
 - [ExperimentDeviceConfig](docs/ExperimentDeviceConfig.md)
 - [GcodeFile](docs/GcodeFile.md)
 - [MobileAuthRequest](docs/MobileAuthRequest.md)
 - [ModelArtifact](docs/ModelArtifact.md)
 - [Nested](docs/Nested.md)
 - [OctoPrintDevice](docs/OctoPrintDevice.md)
 - [OctoPrintDeviceKey](docs/OctoPrintDeviceKey.md)
 - [OctoPrintDeviceRequest](docs/OctoPrintDeviceRequest.md)
 - [OctoPrintEvent](docs/OctoPrintEvent.md)
 - [OctoPrintEventEventTypeEnum](docs/OctoPrintEventEventTypeEnum.md)
 - [OctoPrintEventRequest](docs/OctoPrintEventRequest.md)
 - [OctoprintEnvironment](docs/OctoprintEnvironment.md)
 - [OctoprintFile](docs/OctoprintFile.md)
 - [OctoprintHardware](docs/OctoprintHardware.md)
 - [OctoprintJob](docs/OctoprintJob.md)
 - [OctoprintPiSupport](docs/OctoprintPiSupport.md)
 - [OctoprintPlatform](docs/OctoprintPlatform.md)
 - [OctoprintPrinterData](docs/OctoprintPrinterData.md)
 - [OctoprintPrinterFlags](docs/OctoprintPrinterFlags.md)
 - [OctoprintPrinterState](docs/OctoprintPrinterState.md)
 - [OctoprintProgress](docs/OctoprintProgress.md)
 - [OctoprintPython](docs/OctoprintPython.md)
 - [PaginatedAlertList](docs/PaginatedAlertList.md)
 - [PaginatedDeviceCalibrationList](docs/PaginatedDeviceCalibrationList.md)
 - [PaginatedDeviceList](docs/PaginatedDeviceList.md)
 - [PaginatedExperimentDeviceConfigList](docs/PaginatedExperimentDeviceConfigList.md)
 - [PaginatedExperimentList](docs/PaginatedExperimentList.md)
 - [PaginatedGcodeFileList](docs/PaginatedGcodeFileList.md)
 - [PaginatedModelArtifactList](docs/PaginatedModelArtifactList.md)
 - [PaginatedOctoPrintDeviceList](docs/PaginatedOctoPrintDeviceList.md)
 - [PaginatedOctoPrintEventList](docs/PaginatedOctoPrintEventList.md)
 - [PaginatedPrintJobEventList](docs/PaginatedPrintJobEventList.md)
 - [PaginatedPrintNannyPluginEventList](docs/PaginatedPrintNannyPluginEventList.md)
 - [PaginatedPrintSessionList](docs/PaginatedPrintSessionList.md)
 - [PaginatedPrinterProfileList](docs/PaginatedPrinterProfileList.md)
 - [PaginatedRemoteCommandEventList](docs/PaginatedRemoteCommandEventList.md)
 - [PaginatedRemoteControlCommandList](docs/PaginatedRemoteControlCommandList.md)
 - [PaginatedTelemetryEventPolymorphicList](docs/PaginatedTelemetryEventPolymorphicList.md)
 - [PaginatedUserList](docs/PaginatedUserList.md)
 - [Partner3DGeeksAlert](docs/Partner3DGeeksAlert.md)
 - [Partner3DGeeksMetadata](docs/Partner3DGeeksMetadata.md)
 - [PatchedAlertBulkRequestRequest](docs/PatchedAlertBulkRequestRequest.md)
 - [PatchedAlertRequest](docs/PatchedAlertRequest.md)
 - [PatchedDeviceCalibrationRequest](docs/PatchedDeviceCalibrationRequest.md)
 - [PatchedDeviceRequest](docs/PatchedDeviceRequest.md)
 - [PatchedOctoPrintDeviceRequest](docs/PatchedOctoPrintDeviceRequest.md)
 - [PatchedPrintSessionRequest](docs/PatchedPrintSessionRequest.md)
 - [PatchedPrinterProfileRequest](docs/PatchedPrinterProfileRequest.md)
 - [PatchedRemoteControlCommandRequest](docs/PatchedRemoteControlCommandRequest.md)
 - [PatchedUserRequest](docs/PatchedUserRequest.md)
 - [PrintJobEvent](docs/PrintJobEvent.md)
 - [PrintJobStatusEnum](docs/PrintJobStatusEnum.md)
 - [PrintNannyPluginEvent](docs/PrintNannyPluginEvent.md)
 - [PrintNannyPluginEventEventTypeEnum](docs/PrintNannyPluginEventEventTypeEnum.md)
 - [PrintSession](docs/PrintSession.md)
 - [PrintSessionRequest](docs/PrintSessionRequest.md)
 - [PrinterEvent](docs/PrinterEvent.md)
 - [PrinterProfile](docs/PrinterProfile.md)
 - [PrinterProfileRequest](docs/PrinterProfileRequest.md)
 - [PrinterStateEnum](docs/PrinterStateEnum.md)
 - [RemoteCommandEvent](docs/RemoteCommandEvent.md)
 - [RemoteCommandEventEventTypeEnum](docs/RemoteCommandEventEventTypeEnum.md)
 - [RemoteControlCommand](docs/RemoteControlCommand.md)
 - [RemoteControlCommandRequest](docs/RemoteControlCommandRequest.md)
 - [TelemetryEvent](docs/TelemetryEvent.md)
 - [TelemetryEventEventTypeEnum](docs/TelemetryEventEventTypeEnum.md)
 - [TelemetryEventPolymorphic](docs/TelemetryEventPolymorphic.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [User](docs/User.md)
 - [UserRequest](docs/UserRequest.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



