# Rust API client for print-nanny-client

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 0.0.0
- Package version: 0.8.16
- Build package: org.openapitools.codegen.languages.RustClientCodegen

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertsApi* | [**alerts_list**](docs/AlertsApi.md#alerts_list) | **get** /api/alerts/ | 
*AlertsApi* | [**alerts_partial_update**](docs/AlertsApi.md#alerts_partial_update) | **patch** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_recent**](docs/AlertsApi.md#alerts_recent) | **get** /api/alerts/recent/ | 
*AlertsApi* | [**alerts_retrieve**](docs/AlertsApi.md#alerts_retrieve) | **get** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_seen**](docs/AlertsApi.md#alerts_seen) | **patch** /api/alerts/seen/ | 
*AlertsApi* | [**alerts_unread**](docs/AlertsApi.md#alerts_unread) | **get** /api/alerts/unread/ | 
*AlertsApi* | [**alerts_update**](docs/AlertsApi.md#alerts_update) | **put** /api/alerts/{id}/ | 
*AuthApi* | [**auth_email_create**](docs/AuthApi.md#auth_email_create) | **post** /auth/email/ | 
*AuthApi* | [**auth_mobile_create**](docs/AuthApi.md#auth_mobile_create) | **post** /auth/mobile/ | 
*AuthApi* | [**auth_token_create**](docs/AuthApi.md#auth_token_create) | **post** /auth/token/ | 
*AuthApi* | [**auth_verify_create**](docs/AuthApi.md#auth_verify_create) | **post** /auth/verify/ | 
*AuthApi* | [**auth_verify_email_create**](docs/AuthApi.md#auth_verify_email_create) | **post** /auth/verify/email/ | 
*AuthApi* | [**auth_verify_mobile_create**](docs/AuthApi.md#auth_verify_mobile_create) | **post** /auth/verify/mobile/ | 
*DevicesApi* | [**devices_cameras_create**](docs/DevicesApi.md#devices_cameras_create) | **post** /api/devices/{device_id}/cameras/ | 
*DevicesApi* | [**devices_cameras_list**](docs/DevicesApi.md#devices_cameras_list) | **get** /api/devices/{device_id}/cameras/ | 
*DevicesApi* | [**devices_cameras_partial_update**](docs/DevicesApi.md#devices_cameras_partial_update) | **patch** /api/devices/{device_id}/cameras/{id}/ | 
*DevicesApi* | [**devices_cameras_retrieve**](docs/DevicesApi.md#devices_cameras_retrieve) | **get** /api/devices/{device_id}/cameras/{id}/ | 
*DevicesApi* | [**devices_cameras_update**](docs/DevicesApi.md#devices_cameras_update) | **put** /api/devices/{device_id}/cameras/{id}/ | 
*DevicesApi* | [**devices_create**](docs/DevicesApi.md#devices_create) | **post** /api/devices/ | 
*DevicesApi* | [**devices_list**](docs/DevicesApi.md#devices_list) | **get** /api/devices/ | 
*DevicesApi* | [**devices_partial_update**](docs/DevicesApi.md#devices_partial_update) | **patch** /api/devices/{id}/ | 
*DevicesApi* | [**devices_retrieve**](docs/DevicesApi.md#devices_retrieve) | **get** /api/devices/{id}/ | 
*DevicesApi* | [**devices_update**](docs/DevicesApi.md#devices_update) | **put** /api/devices/{id}/ | 
*DevicesApi* | [**devices_update_or_create**](docs/DevicesApi.md#devices_update_or_create) | **post** /api/devices/update-or-create/ | 
*MlOpsApi* | [**device_calibration_update_or_create**](docs/MlOpsApi.md#device_calibration_update_or_create) | **post** /api/device-calibrations/update-or-create/ | 
*MlOpsApi* | [**device_calibrations_list**](docs/MlOpsApi.md#device_calibrations_list) | **get** /api/device-calibrations/ | 
*MlOpsApi* | [**device_calibrations_partial_update**](docs/MlOpsApi.md#device_calibrations_partial_update) | **patch** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**device_calibrations_retrieve**](docs/MlOpsApi.md#device_calibrations_retrieve) | **get** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**device_calibrations_update**](docs/MlOpsApi.md#device_calibrations_update) | **put** /api/device-calibrations/{id}/ | 
*MlOpsApi* | [**experiment_device_configs_list**](docs/MlOpsApi.md#experiment_device_configs_list) | **get** /api/experiment-device-configs/ | 
*MlOpsApi* | [**experiment_device_configs_retrieve**](docs/MlOpsApi.md#experiment_device_configs_retrieve) | **get** /api/experiment-device-configs/{id}/ | 
*MlOpsApi* | [**experiments_list**](docs/MlOpsApi.md#experiments_list) | **get** /api/experiments/ | 
*MlOpsApi* | [**experiments_retrieve**](docs/MlOpsApi.md#experiments_retrieve) | **get** /api/experiments/{id}/ | 
*MlOpsApi* | [**model_artifacts_list**](docs/MlOpsApi.md#model_artifacts_list) | **get** /api/model-artifacts/ | 
*MlOpsApi* | [**model_artifacts_retrieve**](docs/MlOpsApi.md#model_artifacts_retrieve) | **get** /api/model-artifacts/{id}/ | 
*PartnersGeeks3Api* | [**alerts_list2**](docs/PartnersGeeks3Api.md#alerts_list2) | **get** /api/partners/3d-geeks/{id}/alerts/ | 
*PartnersGeeks3dApi* | [**metadata_retrieve**](docs/PartnersGeeks3dApi.md#metadata_retrieve) | **get** /api/partners/3d-geeks/{id}/ | 
*RemoteControlApi* | [**commands_list**](docs/RemoteControlApi.md#commands_list) | **get** /api/commands/ | 
*RemoteControlApi* | [**commands_partial_update**](docs/RemoteControlApi.md#commands_partial_update) | **patch** /api/commands/{id}/ | 
*RemoteControlApi* | [**commands_retrieve**](docs/RemoteControlApi.md#commands_retrieve) | **get** /api/commands/{id}/ | 
*RemoteControlApi* | [**commands_update**](docs/RemoteControlApi.md#commands_update) | **put** /api/commands/{id}/ | 
*RemoteControlApi* | [**gcode_files_create**](docs/RemoteControlApi.md#gcode_files_create) | **post** /api/gcode-files/ | 
*RemoteControlApi* | [**gcode_files_list**](docs/RemoteControlApi.md#gcode_files_list) | **get** /api/gcode-files/ | 
*RemoteControlApi* | [**gcode_files_partial_update**](docs/RemoteControlApi.md#gcode_files_partial_update) | **patch** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**gcode_files_retrieve**](docs/RemoteControlApi.md#gcode_files_retrieve) | **get** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**gcode_files_update**](docs/RemoteControlApi.md#gcode_files_update) | **put** /api/gcode-files/{id}/ | 
*RemoteControlApi* | [**gcode_files_update_or_create**](docs/RemoteControlApi.md#gcode_files_update_or_create) | **post** /api/gcode-files/update-or-create/ | 
*RemoteControlApi* | [**octoprint_devices_create**](docs/RemoteControlApi.md#octoprint_devices_create) | **post** /api/octoprint-devices/ | 
*RemoteControlApi* | [**octoprint_devices_list**](docs/RemoteControlApi.md#octoprint_devices_list) | **get** /api/octoprint-devices/ | 
*RemoteControlApi* | [**octoprint_devices_partial_update**](docs/RemoteControlApi.md#octoprint_devices_partial_update) | **patch** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_retrieve**](docs/RemoteControlApi.md#octoprint_devices_retrieve) | **get** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_update**](docs/RemoteControlApi.md#octoprint_devices_update) | **put** /api/octoprint-devices/{id}/ | 
*RemoteControlApi* | [**octoprint_devices_update_or_create**](docs/RemoteControlApi.md#octoprint_devices_update_or_create) | **post** /api/octoprint-devices/update-or-create/ | 
*RemoteControlApi* | [**print_session_partial_update**](docs/RemoteControlApi.md#print_session_partial_update) | **patch** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**print_session_update**](docs/RemoteControlApi.md#print_session_update) | **put** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**print_sessions_create**](docs/RemoteControlApi.md#print_sessions_create) | **post** /api/print-sessions/ | 
*RemoteControlApi* | [**print_sessions_list**](docs/RemoteControlApi.md#print_sessions_list) | **get** /api/print-sessions/ | 
*RemoteControlApi* | [**print_sessions_retrieve**](docs/RemoteControlApi.md#print_sessions_retrieve) | **get** /api/print-sessions/{session}/ | 
*RemoteControlApi* | [**printer_profiles_create**](docs/RemoteControlApi.md#printer_profiles_create) | **post** /api/printer-profiles/ | 
*RemoteControlApi* | [**printer_profiles_list**](docs/RemoteControlApi.md#printer_profiles_list) | **get** /api/printer-profiles/ | 
*RemoteControlApi* | [**printer_profiles_partial_update**](docs/RemoteControlApi.md#printer_profiles_partial_update) | **patch** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**printer_profiles_retrieve**](docs/RemoteControlApi.md#printer_profiles_retrieve) | **get** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**printer_profiles_update**](docs/RemoteControlApi.md#printer_profiles_update) | **put** /api/printer-profiles/{id}/ | 
*RemoteControlApi* | [**printer_profiles_update_or_create**](docs/RemoteControlApi.md#printer_profiles_update_or_create) | **post** /api/printer-profiles/update-or-create/ | 
*SchemaApi* | [**schema_retrieve**](docs/SchemaApi.md#schema_retrieve) | **get** /api/schema/ | 
*TelemetryApi* | [**octoprint_events_create**](docs/TelemetryApi.md#octoprint_events_create) | **post** /api/octoprint-events/ | 
*TelemetryApi* | [**octoprint_events_list**](docs/TelemetryApi.md#octoprint_events_list) | **get** /api/octoprint-events/ | 
*TelemetryApi* | [**octoprint_events_retrieve**](docs/TelemetryApi.md#octoprint_events_retrieve) | **get** /api/octoprint-events/{id}/ | 
*TelemetryApi* | [**print_job_events_list**](docs/TelemetryApi.md#print_job_events_list) | **get** /api/print-job-events/ | 
*TelemetryApi* | [**print_job_events_retrieve**](docs/TelemetryApi.md#print_job_events_retrieve) | **get** /api/print-job-events/{id}/ | 
*TelemetryApi* | [**print_nanny_plugin_events_list**](docs/TelemetryApi.md#print_nanny_plugin_events_list) | **get** /api/print-nanny-plugin-events/ | 
*TelemetryApi* | [**print_nanny_plugin_events_retrieve**](docs/TelemetryApi.md#print_nanny_plugin_events_retrieve) | **get** /api/print-nanny-plugin-events/{id}/ | 
*TelemetryApi* | [**remote_command_events_list**](docs/TelemetryApi.md#remote_command_events_list) | **get** /api/remote-command-events/ | 
*TelemetryApi* | [**remote_command_events_retrieve**](docs/TelemetryApi.md#remote_command_events_retrieve) | **get** /api/remote-command-events/{id}/ | 
*TelemetryApi* | [**telemetry_events_create**](docs/TelemetryApi.md#telemetry_events_create) | **post** /api/telemetry-events/ | 
*TelemetryApi* | [**telemetry_events_list**](docs/TelemetryApi.md#telemetry_events_list) | **get** /api/telemetry-events/ | 
*TelemetryApi* | [**telemetry_events_retrieve**](docs/TelemetryApi.md#telemetry_events_retrieve) | **get** /api/telemetry-events/{id}/ | 
*UsersApi* | [**users_list**](docs/UsersApi.md#users_list) | **get** /api/users/ | 
*UsersApi* | [**users_me_retrieve**](docs/UsersApi.md#users_me_retrieve) | **get** /api/users/me/ | 
*UsersApi* | [**users_partial_update**](docs/UsersApi.md#users_partial_update) | **patch** /api/users/{id}/ | 
*UsersApi* | [**users_retrieve**](docs/UsersApi.md#users_retrieve) | **get** /api/users/{id}/ | 
*UsersApi* | [**users_update**](docs/UsersApi.md#users_update) | **put** /api/users/{id}/ | 


## Documentation For Models

 - [Alert](docs/Alert.md)
 - [AlertBulkResponse](docs/AlertBulkResponse.md)
 - [AlertEventTypeEnum](docs/AlertEventTypeEnum.md)
 - [AlertMethodEnum](docs/AlertMethodEnum.md)
 - [AlertRequest](docs/AlertRequest.md)
 - [ArtifactTypesEnum](docs/ArtifactTypesEnum.md)
 - [CallbackTokenAuthRequest](docs/CallbackTokenAuthRequest.md)
 - [CallbackTokenVerification](docs/CallbackTokenVerification.md)
 - [CallbackTokenVerificationRequest](docs/CallbackTokenVerificationRequest.md)
 - [CameraController](docs/CameraController.md)
 - [CameraControllerRequest](docs/CameraControllerRequest.md)
 - [CameraSourceTypeEnum](docs/CameraSourceTypeEnum.md)
 - [CameraTypeEnum](docs/CameraTypeEnum.md)
 - [CommandEnum](docs/CommandEnum.md)
 - [DetailResponse](docs/DetailResponse.md)
 - [Device](docs/Device.md)
 - [DeviceCalibration](docs/DeviceCalibration.md)
 - [DeviceCalibrationRequest](docs/DeviceCalibrationRequest.md)
 - [DeviceIdentity](docs/DeviceIdentity.md)
 - [DeviceIdentityCaCerts](docs/DeviceIdentityCaCerts.md)
 - [DeviceRequest](docs/DeviceRequest.md)
 - [EmailAuthRequest](docs/EmailAuthRequest.md)
 - [EventSourceEnum](docs/EventSourceEnum.md)
 - [EventType0c4Enum](docs/EventType0c4Enum.md)
 - [EventTypeD9eEnum](docs/EventTypeD9eEnum.md)
 - [Experiment](docs/Experiment.md)
 - [ExperimentDeviceConfig](docs/ExperimentDeviceConfig.md)
 - [GcodeFile](docs/GcodeFile.md)
 - [MobileAuthRequest](docs/MobileAuthRequest.md)
 - [ModelArtifact](docs/ModelArtifact.md)
 - [Nested](docs/Nested.md)
 - [OctoPrintDevice](docs/OctoPrintDevice.md)
 - [OctoPrintDeviceKey](docs/OctoPrintDeviceKey.md)
 - [OctoPrintDeviceRequest](docs/OctoPrintDeviceRequest.md)
 - [OctoPrintEvent](docs/OctoPrintEvent.md)
 - [OctoPrintEventEventTypeEnum](docs/OctoPrintEventEventTypeEnum.md)
 - [OctoPrintEventRequest](docs/OctoPrintEventRequest.md)
 - [OctoprintEnvironment](docs/OctoprintEnvironment.md)
 - [OctoprintEnvironmentRequest](docs/OctoprintEnvironmentRequest.md)
 - [OctoprintFile](docs/OctoprintFile.md)
 - [OctoprintFileRequest](docs/OctoprintFileRequest.md)
 - [OctoprintHardware](docs/OctoprintHardware.md)
 - [OctoprintHardwareRequest](docs/OctoprintHardwareRequest.md)
 - [OctoprintJob](docs/OctoprintJob.md)
 - [OctoprintJobRequest](docs/OctoprintJobRequest.md)
 - [OctoprintPiSupport](docs/OctoprintPiSupport.md)
 - [OctoprintPiSupportRequest](docs/OctoprintPiSupportRequest.md)
 - [OctoprintPlatform](docs/OctoprintPlatform.md)
 - [OctoprintPlatformRequest](docs/OctoprintPlatformRequest.md)
 - [OctoprintPrinterData](docs/OctoprintPrinterData.md)
 - [OctoprintPrinterDataRequest](docs/OctoprintPrinterDataRequest.md)
 - [OctoprintPrinterFlags](docs/OctoprintPrinterFlags.md)
 - [OctoprintPrinterFlagsRequest](docs/OctoprintPrinterFlagsRequest.md)
 - [OctoprintPrinterState](docs/OctoprintPrinterState.md)
 - [OctoprintPrinterStateRequest](docs/OctoprintPrinterStateRequest.md)
 - [OctoprintProgress](docs/OctoprintProgress.md)
 - [OctoprintProgressRequest](docs/OctoprintProgressRequest.md)
 - [OctoprintPython](docs/OctoprintPython.md)
 - [OctoprintPythonRequest](docs/OctoprintPythonRequest.md)
 - [PaginatedAlertList](docs/PaginatedAlertList.md)
 - [PaginatedCameraControllerList](docs/PaginatedCameraControllerList.md)
 - [PaginatedDeviceCalibrationList](docs/PaginatedDeviceCalibrationList.md)
 - [PaginatedDeviceList](docs/PaginatedDeviceList.md)
 - [PaginatedExperimentDeviceConfigList](docs/PaginatedExperimentDeviceConfigList.md)
 - [PaginatedExperimentList](docs/PaginatedExperimentList.md)
 - [PaginatedGcodeFileList](docs/PaginatedGcodeFileList.md)
 - [PaginatedModelArtifactList](docs/PaginatedModelArtifactList.md)
 - [PaginatedOctoPrintDeviceList](docs/PaginatedOctoPrintDeviceList.md)
 - [PaginatedOctoPrintEventList](docs/PaginatedOctoPrintEventList.md)
 - [PaginatedPrintJobEventList](docs/PaginatedPrintJobEventList.md)
 - [PaginatedPrintNannyPluginEventList](docs/PaginatedPrintNannyPluginEventList.md)
 - [PaginatedPrintSessionList](docs/PaginatedPrintSessionList.md)
 - [PaginatedPrinterProfileList](docs/PaginatedPrinterProfileList.md)
 - [PaginatedRemoteCommandEventList](docs/PaginatedRemoteCommandEventList.md)
 - [PaginatedRemoteControlCommandList](docs/PaginatedRemoteControlCommandList.md)
 - [PaginatedTelemetryEventPolymorphicList](docs/PaginatedTelemetryEventPolymorphicList.md)
 - [PaginatedUserList](docs/PaginatedUserList.md)
 - [Partner3DGeeksAlert](docs/Partner3DGeeksAlert.md)
 - [Partner3DGeeksMetadata](docs/Partner3DGeeksMetadata.md)
 - [PatchedAlertBulkRequestRequest](docs/PatchedAlertBulkRequestRequest.md)
 - [PatchedAlertRequest](docs/PatchedAlertRequest.md)
 - [PatchedCameraControllerRequest](docs/PatchedCameraControllerRequest.md)
 - [PatchedDeviceCalibrationRequest](docs/PatchedDeviceCalibrationRequest.md)
 - [PatchedDeviceRequest](docs/PatchedDeviceRequest.md)
 - [PatchedOctoPrintDeviceRequest](docs/PatchedOctoPrintDeviceRequest.md)
 - [PatchedPrintSessionRequest](docs/PatchedPrintSessionRequest.md)
 - [PatchedPrinterProfileRequest](docs/PatchedPrinterProfileRequest.md)
 - [PatchedRemoteControlCommandRequest](docs/PatchedRemoteControlCommandRequest.md)
 - [PatchedUserRequest](docs/PatchedUserRequest.md)
 - [PrintJobEvent](docs/PrintJobEvent.md)
 - [PrintJobEventRequest](docs/PrintJobEventRequest.md)
 - [PrintJobStatusEnum](docs/PrintJobStatusEnum.md)
 - [PrintNannyPluginEvent](docs/PrintNannyPluginEvent.md)
 - [PrintNannyPluginEventEventTypeEnum](docs/PrintNannyPluginEventEventTypeEnum.md)
 - [PrintNannyPluginEventRequest](docs/PrintNannyPluginEventRequest.md)
 - [PrintSession](docs/PrintSession.md)
 - [PrintSessionRequest](docs/PrintSessionRequest.md)
 - [PrinterEvent](docs/PrinterEvent.md)
 - [PrinterEventRequest](docs/PrinterEventRequest.md)
 - [PrinterProfile](docs/PrinterProfile.md)
 - [PrinterProfileRequest](docs/PrinterProfileRequest.md)
 - [PrinterStateEnum](docs/PrinterStateEnum.md)
 - [RemoteCommandEvent](docs/RemoteCommandEvent.md)
 - [RemoteCommandEventEventTypeEnum](docs/RemoteCommandEventEventTypeEnum.md)
 - [RemoteCommandEventRequest](docs/RemoteCommandEventRequest.md)
 - [RemoteControlCommand](docs/RemoteControlCommand.md)
 - [RemoteControlCommandRequest](docs/RemoteControlCommandRequest.md)
 - [TelemetryEvent](docs/TelemetryEvent.md)
 - [TelemetryEventEventTypeEnum](docs/TelemetryEventEventTypeEnum.md)
 - [TelemetryEventPolymorphic](docs/TelemetryEventPolymorphic.md)
 - [TelemetryEventPolymorphicRequest](docs/TelemetryEventPolymorphicRequest.md)
 - [TelemetryEventRequest](docs/TelemetryEventRequest.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [User](docs/User.md)
 - [UserRequest](docs/UserRequest.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



