use integer_sqrt::IntegerSquareRoot;

fn main() {
	for prime in Prime::new(1) {
		println!("Prime {}", prime);
		if prime > 100 {
			break;
		}
	}
}

struct Prime {
	number: u64,
}

impl Prime {
	fn new(seed: u64) -> Prime {
		Prime { number: seed }
	}
}

impl Iterator for Prime {
	type Item = u64;

	/* slowest implementation ever - count divisors and assume prime if 2
	fn next(&mut self) -> Option<Self::Item> {
		for number in self.number+1.. {
			//number.integer_sqrt()
			let mut divisors = 0;
			for tester in 1..number+1 {
				if number % tester == 0 {
					divisors += 1;
				}
			}
			if divisors == 2 {
				self.number = number;
				return Some(self.number);
			}
		}
		None
	}*/

	//
	fn next(&mut self) -> Option<Self::Item> {
		for number in self.number+1.. {
			let mut isprime = true;
			for tester in 2..number.integer_sqrt()+1 {
				if number % tester == 0 {
					isprime = false;
					break;
				}
			}
			if isprime {
				self.number = number;
				return Some(self.number);
			}
		}
		None
	}
}
