use integer_sqrt::IntegerSquareRoot;

#[cfg(test)]
mod tests {
    use crate::{check_prime, check_area, check_big_prime, sieve_of_eratosthenes};
    use std::time;

    #[test]
    fn it_works() {
        let start = time::Instant::now();

        println!("{}", check_prime(5)); //true (-> u64 numbers)
        //println!("{}", check_big_prime(49999999999999998491)); //true (-> u128 numbers)
        println!("{:?}", check_area(1, 10)); //[2, 3, 5, 7]
        println!("{:?}", sieve_of_eratosthenes(10)); //[2, 3, 5, 7]

        println!("duration: {:?}", time::Instant::now().duration_since(start));
    }
}

pub fn check_prime(number:u64) -> bool {
    if number <= 1 { return false }
    for divisor in 2..number.integer_sqrt()+1 {
        if &number%divisor == 0 { return false }
    }
    true
}

fn check_big_prime(number:u128) -> bool {
    todo!("Miller-Rabin-Test")
}

pub fn check_area(start:u64, end:u64) -> Vec<u64> {
    let mut primes:Vec<u64> = Vec::new();
    let mut divisor:u64;
    if start < 1 && start >= end { return primes }
    for number in start..end {
        divisor = 2;
        while (number%divisor != 0) && (divisor <= number.integer_sqrt()) { divisor = divisor + 1; }
        if (divisor >= number.integer_sqrt()+1) && (number != 1) { primes.push(number); }
    }
    primes
}

pub fn sieve_of_eratosthenes(limit:u32) -> Vec<u32> {
    let limit = limit as usize;
    let mut numbers:Vec<u32> = vec![0; limit];
    for i in 0..limit {
        numbers[i] = i as u32;
    }
    let mut number:usize;
    for divisor in 2..(limit.integer_sqrt()+1) {
        if numbers[divisor] != 0 {
            number = divisor*divisor;
            while number < limit {
                numbers[number] = 0;
                number += divisor;
            }
        }
    }
    let mut primes= vec![];
    for number in numbers {
        if number != 0 && number != 1 {
            primes.push(number);
        }
    }
    primes
}