pub mod constants;
pub mod reader;
pub mod writer;

pub use reader::PackedReader;
pub use writer::PackedWriter;

use super::{Reader, IOValue};
use super::reader::IOResult;

pub fn from_bytes(bs: &[u8]) -> IOResult<IOValue> {
    PackedReader::decode_bytes(bs).demand_next(false)
}

pub fn annotated_from_bytes(bs: &[u8]) -> IOResult<IOValue> {
    PackedReader::decode_bytes(bs).demand_next(true)
}
