pub mod de;
pub mod magic;
pub mod packed;
pub mod reader;
pub mod ser;
pub mod signed_integer;
pub mod repr;
pub mod writer;

pub use de::Deserializer;
pub use de::from_value;
pub use packed::PackedReader;
pub use packed::PackedWriter;
pub use reader::ConfiguredReader;
pub use reader::Reader;
pub use repr::AnnotatedValue;
pub use repr::ArcValue;
pub use repr::Domain;
pub use repr::IOValue;
pub use repr::Map;
pub use repr::NestedValue;
pub use repr::PlainValue;
pub use repr::RcValue;
pub use repr::Record;
pub use repr::Set;
pub use repr::UnwrappedIOValue;
pub use repr::Value;
pub use ser::Serializer;
pub use ser::to_value;
pub use writer::Writer;

pub use repr::FALSE;
pub use repr::TRUE;
pub use repr::EMPTY_SEQ;

pub fn invert_map<A, B>(m: &Map<A, B>) -> Map<B, A>
    where A: Clone, B: Clone + Ord
{
    m.iter().map(|(a, b)| (b.clone(), a.clone())).collect()
}
