#![allow(unused_parens)]

use std::convert::TryFrom;
use preserves::value::NestedValue;
use lazy_static::lazy_static;

lazy_static! {
    pub static ref LIT15: preserves::value::IOValue = /* #f */ preserves::value::packed::from_bytes(&vec![128]).unwrap();
    pub static ref LIT28: preserves::value::IOValue = /* 1 */ preserves::value::packed::from_bytes(&vec![145]).unwrap();
    pub static ref LIT0: preserves::value::IOValue = /* Boolean */ preserves::value::packed::from_bytes(&vec![179, 7, 66, 111, 111, 108, 101, 97, 110]).unwrap();
    pub static ref LIT5: preserves::value::IOValue = /* ByteString */ preserves::value::packed::from_bytes(&vec![179, 10, 66, 121, 116, 101, 83, 116, 114, 105, 110, 103]).unwrap();
    pub static ref LIT2: preserves::value::IOValue = /* Double */ preserves::value::packed::from_bytes(&vec![179, 6, 68, 111, 117, 98, 108, 101]).unwrap();
    pub static ref LIT1: preserves::value::IOValue = /* Float */ preserves::value::packed::from_bytes(&vec![179, 5, 70, 108, 111, 97, 116]).unwrap();
    pub static ref LIT3: preserves::value::IOValue = /* SignedInteger */ preserves::value::packed::from_bytes(&vec![179, 13, 83, 105, 103, 110, 101, 100, 73, 110, 116, 101, 103, 101, 114]).unwrap();
    pub static ref LIT4: preserves::value::IOValue = /* String */ preserves::value::packed::from_bytes(&vec![179, 6, 83, 116, 114, 105, 110, 103]).unwrap();
    pub static ref LIT6: preserves::value::IOValue = /* Symbol */ preserves::value::packed::from_bytes(&vec![179, 6, 83, 121, 109, 98, 111, 108]).unwrap();
    pub static ref LIT14: preserves::value::IOValue = /* and */ preserves::value::packed::from_bytes(&vec![179, 3, 97, 110, 100]).unwrap();
    pub static ref LIT21: preserves::value::IOValue = /* any */ preserves::value::packed::from_bytes(&vec![179, 3, 97, 110, 121]).unwrap();
    pub static ref LIT22: preserves::value::IOValue = /* atom */ preserves::value::packed::from_bytes(&vec![179, 4, 97, 116, 111, 109]).unwrap();
    pub static ref LIT8: preserves::value::IOValue = /* bundle */ preserves::value::packed::from_bytes(&vec![179, 6, 98, 117, 110, 100, 108, 101]).unwrap();
    pub static ref LIT18: preserves::value::IOValue = /* definitions */ preserves::value::packed::from_bytes(&vec![179, 11, 100, 101, 102, 105, 110, 105, 116, 105, 111, 110, 115]).unwrap();
    pub static ref LIT12: preserves::value::IOValue = /* dict */ preserves::value::packed::from_bytes(&vec![179, 4, 100, 105, 99, 116]).unwrap();
    pub static ref LIT27: preserves::value::IOValue = /* dictof */ preserves::value::packed::from_bytes(&vec![179, 6, 100, 105, 99, 116, 111, 102]).unwrap();
    pub static ref LIT23: preserves::value::IOValue = /* embedded */ preserves::value::packed::from_bytes(&vec![179, 8, 101, 109, 98, 101, 100, 100, 101, 100]).unwrap();
    pub static ref LIT19: preserves::value::IOValue = /* embeddedType */ preserves::value::packed::from_bytes(&vec![179, 12, 101, 109, 98, 101, 100, 100, 101, 100, 84, 121, 112, 101]).unwrap();
    pub static ref LIT24: preserves::value::IOValue = /* lit */ preserves::value::packed::from_bytes(&vec![179, 3, 108, 105, 116]).unwrap();
    pub static ref LIT7: preserves::value::IOValue = /* named */ preserves::value::packed::from_bytes(&vec![179, 5, 110, 97, 109, 101, 100]).unwrap();
    pub static ref LIT13: preserves::value::IOValue = /* or */ preserves::value::packed::from_bytes(&vec![179, 2, 111, 114]).unwrap();
    pub static ref LIT9: preserves::value::IOValue = /* rec */ preserves::value::packed::from_bytes(&vec![179, 3, 114, 101, 99]).unwrap();
    pub static ref LIT16: preserves::value::IOValue = /* ref */ preserves::value::packed::from_bytes(&vec![179, 3, 114, 101, 102]).unwrap();
    pub static ref LIT17: preserves::value::IOValue = /* schema */ preserves::value::packed::from_bytes(&vec![179, 6, 115, 99, 104, 101, 109, 97]).unwrap();
    pub static ref LIT25: preserves::value::IOValue = /* seqof */ preserves::value::packed::from_bytes(&vec![179, 5, 115, 101, 113, 111, 102]).unwrap();
    pub static ref LIT26: preserves::value::IOValue = /* setof */ preserves::value::packed::from_bytes(&vec![179, 5, 115, 101, 116, 111, 102]).unwrap();
    pub static ref LIT10: preserves::value::IOValue = /* tuple */ preserves::value::packed::from_bytes(&vec![179, 5, 116, 117, 112, 108, 101]).unwrap();
    pub static ref LIT11: preserves::value::IOValue = /* tuplePrefix */ preserves::value::packed::from_bytes(&vec![179, 11, 116, 117, 112, 108, 101, 80, 114, 101, 102, 105, 120]).unwrap();
    pub static ref LIT20: preserves::value::IOValue = /* version */ preserves::value::packed::from_bytes(&vec![179, 7, 118, 101, 114, 115, 105, 111, 110]).unwrap();
}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub enum AtomKind {Boolean, Float, Double, SignedInteger, String, ByteString, Symbol}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct Binding {pub name: std::string::String, pub pattern: SimplePattern}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct Bundle {pub modules: Modules}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub enum CompoundPattern {
    Rec {label: std::boxed::Box<NamedPattern>, fields: std::boxed::Box<NamedPattern>},
    Tuple {patterns: std::vec::Vec<NamedPattern>},
    TuplePrefix {
        fixed: std::vec::Vec<NamedPattern>,
        variable: std::boxed::Box<NamedSimplePattern>
    },
    Dict {entries: std::boxed::Box<DictionaryEntries>}
}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub enum Definition {
    Or {
        pattern_0: std::boxed::Box<NamedAlternative>,
        pattern_1: std::boxed::Box<NamedAlternative>,
        pattern_n: std::vec::Vec<NamedAlternative>
    },
    And {
        pattern_0: std::boxed::Box<NamedPattern>,
        pattern_1: std::boxed::Box<NamedPattern>,
        pattern_n: std::vec::Vec<NamedPattern>
    },
    Pattern(std::boxed::Box<Pattern>)
}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct Definitions(pub preserves::value::Map<std::string::String, Definition>);

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct DictionaryEntries(pub preserves::value::Map<preserves::value::IOValue, NamedSimplePattern>);

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub enum EmbeddedTypeName {Ref(std::boxed::Box<Ref>), False}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct ModulePath(pub std::vec::Vec<std::string::String>);

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct Modules(pub preserves::value::Map<ModulePath, Schema>);

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct NamedAlternative {pub variant_label: std::string::String, pub pattern: Pattern}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub enum NamedPattern {Named(std::boxed::Box<Binding>), Anonymous(std::boxed::Box<Pattern>)}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub enum NamedSimplePattern {Named(std::boxed::Box<Binding>), Anonymous(std::boxed::Box<SimplePattern>)}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub enum Pattern {
    SimplePattern(std::boxed::Box<SimplePattern>),
    CompoundPattern(std::boxed::Box<CompoundPattern>)
}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct Ref {pub module: ModulePath, pub name: std::string::String}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct Schema {
    pub definitions: Definitions,
    pub embedded_type: EmbeddedTypeName,
    pub version: Version
}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub enum SimplePattern {
    Any,
    Atom {atom_kind: std::boxed::Box<AtomKind>},
    Embedded {interface: std::boxed::Box<SimplePattern>},
    Lit {value: preserves::value::IOValue},
    Seqof {pattern: std::boxed::Box<SimplePattern>},
    Setof {pattern: std::boxed::Box<SimplePattern>},
    Dictof {key: std::boxed::Box<SimplePattern>, value: std::boxed::Box<SimplePattern>},
    Ref(std::boxed::Box<Ref>)
}

#[derive(Debug, PartialOrd, Ord, PartialEq, Eq, Clone)]
pub struct Version;

fn _parse_atom_kind_boolean(value: &preserves::value::IOValue) -> std::result::Result<AtomKind, ()> {if value != &*LIT0 { return Err(()); } let _tmp0 = (); Ok(AtomKind::Boolean)}

fn _parse_atom_kind_float(value: &preserves::value::IOValue) -> std::result::Result<AtomKind, ()> {if value != &*LIT1 { return Err(()); } let _tmp0 = (); Ok(AtomKind::Float)}

fn _parse_atom_kind_double(value: &preserves::value::IOValue) -> std::result::Result<AtomKind, ()> {if value != &*LIT2 { return Err(()); } let _tmp0 = (); Ok(AtomKind::Double)}

fn _parse_atom_kind_signed_integer(value: &preserves::value::IOValue) -> std::result::Result<AtomKind, ()> {
    if value != &*LIT3 { return Err(()); }
    let _tmp0 = ();
    Ok(AtomKind::SignedInteger)
}

fn _parse_atom_kind_string(value: &preserves::value::IOValue) -> std::result::Result<AtomKind, ()> {if value != &*LIT4 { return Err(()); } let _tmp0 = (); Ok(AtomKind::String)}

fn _parse_atom_kind_byte_string(value: &preserves::value::IOValue) -> std::result::Result<AtomKind, ()> {
    if value != &*LIT5 { return Err(()); }
    let _tmp0 = ();
    Ok(AtomKind::ByteString)
}

fn _parse_atom_kind_symbol(value: &preserves::value::IOValue) -> std::result::Result<AtomKind, ()> {if value != &*LIT6 { return Err(()); } let _tmp0 = (); Ok(AtomKind::Symbol)}

impl std::convert::TryFrom<&preserves::value::IOValue> for AtomKind {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        if let Ok(r) = _parse_atom_kind_boolean(value) { return Ok(r); }
        if let Ok(r) = _parse_atom_kind_float(value) { return Ok(r); }
        if let Ok(r) = _parse_atom_kind_double(value) { return Ok(r); }
        if let Ok(r) = _parse_atom_kind_signed_integer(value) { return Ok(r); }
        if let Ok(r) = _parse_atom_kind_string(value) { return Ok(r); }
        if let Ok(r) = _parse_atom_kind_byte_string(value) { return Ok(r); }
        if let Ok(r) = _parse_atom_kind_symbol(value) { return Ok(r); }
        Err(())
    }
}

impl std::convert::From<&AtomKind> for preserves::value::IOValue {
    fn from(value: &AtomKind) -> Self {
        match value {
            AtomKind::Boolean => (&*LIT0).clone(),
            AtomKind::Float => (&*LIT1).clone(),
            AtomKind::Double => (&*LIT2).clone(),
            AtomKind::SignedInteger => (&*LIT3).clone(),
            AtomKind::String => (&*LIT4).clone(),
            AtomKind::ByteString => (&*LIT5).clone(),
            AtomKind::Symbol => (&*LIT6).clone(),
        }
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for Binding {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
        if _tmp0.label() != &*LIT7 { return Err(()); }
        let _tmp1 = ();
        if _tmp0.fields().len() - 0 < 2 { return Err(()); }
        let _tmp2 = (&_tmp0.fields()[0]).value().to_symbol().map_err(|_| ())?;
        let _tmp3 = SimplePattern::try_from((&_tmp0.fields()[1]))?;
        Ok(Binding {name: _tmp2.clone(), pattern: _tmp3})
    }
}

impl std::convert::From<&Binding> for preserves::value::IOValue {
    fn from(value: &Binding) -> Self {
        let Binding {name: _tmp0, pattern: _tmp1} = value;
        {
            let mut _tmp2 = preserves::value::Record(vec![(&*LIT7).clone()]);
            _tmp2.fields_vec_mut().push(preserves::value::Value::symbol(_tmp0).wrap());
            _tmp2.fields_vec_mut().push(preserves::value::IOValue::from(_tmp1));
            _tmp2.finish().wrap()
        }
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for Bundle {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
        if _tmp0.label() != &*LIT8 { return Err(()); }
        let _tmp1 = ();
        if _tmp0.fields().len() - 0 < 1 { return Err(()); }
        let _tmp2 = Modules::try_from((&_tmp0.fields()[0]))?;
        Ok(Bundle {modules: _tmp2})
    }
}

impl std::convert::From<&Bundle> for preserves::value::IOValue {
    fn from(value: &Bundle) -> Self {
        let Bundle {modules: _tmp0} = value;
        {
            let mut _tmp1 = preserves::value::Record(vec![(&*LIT8).clone()]);
            _tmp1.fields_vec_mut().push(preserves::value::IOValue::from(_tmp0));
            _tmp1.finish().wrap()
        }
    }
}

fn _parse_compound_pattern_rec(value: &preserves::value::IOValue) -> std::result::Result<CompoundPattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT9 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 2 { return Err(()); }
    let _tmp2 = NamedPattern::try_from((&_tmp0.fields()[0]))?;
    let _tmp3 = NamedPattern::try_from((&_tmp0.fields()[1]))?;
    Ok(CompoundPattern::Rec {label: std::boxed::Box::new(_tmp2), fields: std::boxed::Box::new(_tmp3)})
}

fn _parse_compound_pattern_tuple(value: &preserves::value::IOValue) -> std::result::Result<CompoundPattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT10 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 1 { return Err(()); }
    let _tmp3 = (&_tmp0.fields()[0]).value().to_sequence().map_err(|_| ())?;
    let mut _tmp2 = std::vec::Vec::new();
    for _tmp4 in &_tmp3[0..] {let _tmp5 = NamedPattern::try_from(_tmp4)?; _tmp2.push(_tmp5);}
    Ok(CompoundPattern::Tuple {patterns: _tmp2})
}

fn _parse_compound_pattern_tuple_prefix(value: &preserves::value::IOValue) -> std::result::Result<CompoundPattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT11 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 2 { return Err(()); }
    let _tmp3 = (&_tmp0.fields()[0]).value().to_sequence().map_err(|_| ())?;
    let mut _tmp2 = std::vec::Vec::new();
    for _tmp4 in &_tmp3[0..] {let _tmp5 = NamedPattern::try_from(_tmp4)?; _tmp2.push(_tmp5);}
    let _tmp6 = NamedSimplePattern::try_from((&_tmp0.fields()[1]))?;
    Ok(CompoundPattern::TuplePrefix {fixed: _tmp2, variable: std::boxed::Box::new(_tmp6)})
}

fn _parse_compound_pattern_dict(value: &preserves::value::IOValue) -> std::result::Result<CompoundPattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT12 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 1 { return Err(()); }
    let _tmp2 = DictionaryEntries::try_from((&_tmp0.fields()[0]))?;
    Ok(CompoundPattern::Dict {entries: std::boxed::Box::new(_tmp2)})
}

impl std::convert::TryFrom<&preserves::value::IOValue> for CompoundPattern {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        if let Ok(r) = _parse_compound_pattern_rec(value) { return Ok(r); }
        if let Ok(r) = _parse_compound_pattern_tuple(value) { return Ok(r); }
        if let Ok(r) = _parse_compound_pattern_tuple_prefix(value) { return Ok(r); }
        if let Ok(r) = _parse_compound_pattern_dict(value) { return Ok(r); }
        Err(())
    }
}

impl std::convert::From<&CompoundPattern> for preserves::value::IOValue {
    fn from(value: &CompoundPattern) -> Self {
        match value {
            CompoundPattern::Rec {label: _tmp0, fields: _tmp1} => {
                let mut _tmp2 = preserves::value::Record(vec![(&*LIT9).clone()]);
                _tmp2.fields_vec_mut().push(preserves::value::IOValue::from(_tmp0.as_ref()));
                _tmp2.fields_vec_mut().push(preserves::value::IOValue::from(_tmp1.as_ref()));
                _tmp2.finish().wrap()
            },
            CompoundPattern::Tuple {patterns: _tmp0} => {
                let mut _tmp1 = preserves::value::Record(vec![(&*LIT10).clone()]);
                _tmp1.fields_vec_mut().push(
                    {
                        let mut _tmp2 = vec![];
                        for _tmp3 in _tmp0 {_tmp2.push(preserves::value::IOValue::from(_tmp3));}
                        preserves::value::Value::Sequence(_tmp2).wrap()
                    }
                );
                _tmp1.finish().wrap()
            },
            CompoundPattern::TuplePrefix {fixed: _tmp0, variable: _tmp1} => {
                let mut _tmp2 = preserves::value::Record(vec![(&*LIT11).clone()]);
                _tmp2.fields_vec_mut().push(
                    {
                        let mut _tmp3 = vec![];
                        for _tmp4 in _tmp0 {_tmp3.push(preserves::value::IOValue::from(_tmp4));}
                        preserves::value::Value::Sequence(_tmp3).wrap()
                    }
                );
                _tmp2.fields_vec_mut().push(preserves::value::IOValue::from(_tmp1.as_ref()));
                _tmp2.finish().wrap()
            },
            CompoundPattern::Dict {entries: _tmp0} => {
                let mut _tmp1 = preserves::value::Record(vec![(&*LIT12).clone()]);
                _tmp1.fields_vec_mut().push(preserves::value::IOValue::from(_tmp0.as_ref()));
                _tmp1.finish().wrap()
            },
        }
    }
}

fn _parse_definition_or(value: &preserves::value::IOValue) -> std::result::Result<Definition, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT13 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 1 { return Err(()); }
    let _tmp2 = (&_tmp0.fields()[0]).value().to_sequence().map_err(|_| ())?;
    if _tmp2.len() - 0 < 2 { return Err(()); }
    let _tmp3 = NamedAlternative::try_from((&_tmp2[0]))?;
    let _tmp4 = NamedAlternative::try_from((&_tmp2[1]))?;
    let mut _tmp5 = std::vec::Vec::new();
    for _tmp6 in &_tmp2[2..] {let _tmp7 = NamedAlternative::try_from(_tmp6)?; _tmp5.push(_tmp7);}
    Ok(Definition::Or {
        pattern_0: std::boxed::Box::new(_tmp3),
        pattern_1: std::boxed::Box::new(_tmp4),
        pattern_n: _tmp5
    })
}

fn _parse_definition_and(value: &preserves::value::IOValue) -> std::result::Result<Definition, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT14 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 1 { return Err(()); }
    let _tmp2 = (&_tmp0.fields()[0]).value().to_sequence().map_err(|_| ())?;
    if _tmp2.len() - 0 < 2 { return Err(()); }
    let _tmp3 = NamedPattern::try_from((&_tmp2[0]))?;
    let _tmp4 = NamedPattern::try_from((&_tmp2[1]))?;
    let mut _tmp5 = std::vec::Vec::new();
    for _tmp6 in &_tmp2[2..] {let _tmp7 = NamedPattern::try_from(_tmp6)?; _tmp5.push(_tmp7);}
    Ok(Definition::And {
        pattern_0: std::boxed::Box::new(_tmp3),
        pattern_1: std::boxed::Box::new(_tmp4),
        pattern_n: _tmp5
    })
}

fn _parse_definition_pattern(value: &preserves::value::IOValue) -> std::result::Result<Definition, ()> {
    let _tmp0 = Pattern::try_from(value)?;
    Ok(Definition::Pattern(std::boxed::Box::new(_tmp0)))
}

impl std::convert::TryFrom<&preserves::value::IOValue> for Definition {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        if let Ok(r) = _parse_definition_or(value) { return Ok(r); }
        if let Ok(r) = _parse_definition_and(value) { return Ok(r); }
        if let Ok(r) = _parse_definition_pattern(value) { return Ok(r); }
        Err(())
    }
}

impl std::convert::From<&Definition> for preserves::value::IOValue {
    fn from(value: &Definition) -> Self {
        match value {
            Definition::Or {pattern_0: _tmp0, pattern_1: _tmp1, pattern_n: _tmp2} => {
                let mut _tmp3 = preserves::value::Record(vec![(&*LIT13).clone()]);
                _tmp3.fields_vec_mut().push(
                    {
                        let mut _tmp4 = vec![];
                        _tmp4.push(preserves::value::IOValue::from(_tmp0.as_ref()));
                        _tmp4.push(preserves::value::IOValue::from(_tmp1.as_ref()));
                        for _tmp5 in _tmp2 {_tmp4.push(preserves::value::IOValue::from(_tmp5));}
                        preserves::value::Value::Sequence(_tmp4).wrap()
                    }
                );
                _tmp3.finish().wrap()
            },
            Definition::And {pattern_0: _tmp0, pattern_1: _tmp1, pattern_n: _tmp2} => {
                let mut _tmp3 = preserves::value::Record(vec![(&*LIT14).clone()]);
                _tmp3.fields_vec_mut().push(
                    {
                        let mut _tmp4 = vec![];
                        _tmp4.push(preserves::value::IOValue::from(_tmp0.as_ref()));
                        _tmp4.push(preserves::value::IOValue::from(_tmp1.as_ref()));
                        for _tmp5 in _tmp2 {_tmp4.push(preserves::value::IOValue::from(_tmp5));}
                        preserves::value::Value::Sequence(_tmp4).wrap()
                    }
                );
                _tmp3.finish().wrap()
            },
            Definition::Pattern(_tmp0) => preserves::value::IOValue::from(_tmp0.as_ref()),
        }
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for Definitions {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        let mut _tmp0 = preserves::value::Map::new();
        for (_tmp1, _tmp2) in value.value().to_dictionary().map_err(|_| ())? {
            let _tmp3 = _tmp1.value().to_symbol().map_err(|_| ())?;
            let _tmp4 = Definition::try_from(_tmp2)?;
            _tmp0.insert(_tmp3.clone(), _tmp4);
        }
        Ok(Definitions(_tmp0))
    }
}

impl std::convert::From<&Definitions> for preserves::value::IOValue {
    fn from(value: &Definitions) -> Self {
        let Definitions(_tmp0) = value;
        preserves::value::Value::Dictionary(_tmp0.iter().map(|(_tmp1, _tmp2)| (
            preserves::value::Value::symbol(_tmp1).wrap(),
            preserves::value::IOValue::from(_tmp2)
        )).collect()).wrap()
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for DictionaryEntries {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        let mut _tmp0 = preserves::value::Map::new();
        for (_tmp1, _tmp2) in value.value().to_dictionary().map_err(|_| ())? {
            let _tmp3 = _tmp1;
            let _tmp4 = NamedSimplePattern::try_from(_tmp2)?;
            _tmp0.insert(_tmp3.clone(), _tmp4);
        }
        Ok(DictionaryEntries(_tmp0))
    }
}

impl std::convert::From<&DictionaryEntries> for preserves::value::IOValue {
    fn from(value: &DictionaryEntries) -> Self {
        let DictionaryEntries(_tmp0) = value;
        preserves::value::Value::Dictionary(_tmp0.iter().map(|(_tmp1, _tmp2)| (_tmp1.clone(), preserves::value::IOValue::from(_tmp2))).collect()).wrap()
    }
}

fn _parse_embedded_type_name_ref(value: &preserves::value::IOValue) -> std::result::Result<EmbeddedTypeName, ()> {
    let _tmp0 = Ref::try_from(value)?;
    Ok(EmbeddedTypeName::Ref(std::boxed::Box::new(_tmp0)))
}

fn _parse_embedded_type_name_false(value: &preserves::value::IOValue) -> std::result::Result<EmbeddedTypeName, ()> {
    if value != &*LIT15 { return Err(()); }
    let _tmp0 = ();
    Ok(EmbeddedTypeName::False)
}

impl std::convert::TryFrom<&preserves::value::IOValue> for EmbeddedTypeName {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        if let Ok(r) = _parse_embedded_type_name_ref(value) { return Ok(r); }
        if let Ok(r) = _parse_embedded_type_name_false(value) { return Ok(r); }
        Err(())
    }
}

impl std::convert::From<&EmbeddedTypeName> for preserves::value::IOValue {
    fn from(value: &EmbeddedTypeName) -> Self {
        match value {
            EmbeddedTypeName::Ref(_tmp0) => preserves::value::IOValue::from(_tmp0.as_ref()),
            EmbeddedTypeName::False => (&*LIT15).clone(),
        }
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for ModulePath {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        let _tmp1 = value.value().to_sequence().map_err(|_| ())?;
        let mut _tmp0 = std::vec::Vec::new();
        for _tmp2 in &_tmp1[0..] {
            let _tmp3 = _tmp2.value().to_symbol().map_err(|_| ())?;
            _tmp0.push(_tmp3.clone());
        }
        Ok(ModulePath(_tmp0))
    }
}

impl std::convert::From<&ModulePath> for preserves::value::IOValue {
    fn from(value: &ModulePath) -> Self {
        let ModulePath(_tmp0) = value;
        {
            let mut _tmp1 = vec![];
            for _tmp2 in _tmp0 {_tmp1.push(preserves::value::Value::symbol(_tmp2).wrap());}
            preserves::value::Value::Sequence(_tmp1).wrap()
        }
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for Modules {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        let mut _tmp0 = preserves::value::Map::new();
        for (_tmp1, _tmp2) in value.value().to_dictionary().map_err(|_| ())? {
            let _tmp3 = ModulePath::try_from(_tmp1)?;
            let _tmp4 = Schema::try_from(_tmp2)?;
            _tmp0.insert(_tmp3, _tmp4);
        }
        Ok(Modules(_tmp0))
    }
}

impl std::convert::From<&Modules> for preserves::value::IOValue {
    fn from(value: &Modules) -> Self {
        let Modules(_tmp0) = value;
        preserves::value::Value::Dictionary(_tmp0.iter().map(|(_tmp1, _tmp2)| (preserves::value::IOValue::from(_tmp1), preserves::value::IOValue::from(_tmp2))).collect()).wrap()
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for NamedAlternative {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        let _tmp0 = value.value().to_sequence().map_err(|_| ())?;
        if _tmp0.len() - 0 < 2 { return Err(()); }
        let _tmp1 = (&_tmp0[0]).value().to_string().map_err(|_| ())?;
        let _tmp2 = Pattern::try_from((&_tmp0[1]))?;
        Ok(NamedAlternative {variant_label: _tmp1.clone(), pattern: _tmp2})
    }
}

impl std::convert::From<&NamedAlternative> for preserves::value::IOValue {
    fn from(value: &NamedAlternative) -> Self {
        let NamedAlternative {variant_label: _tmp0, pattern: _tmp1} = value;
        {
            let mut _tmp2 = vec![];
            _tmp2.push(preserves::value::Value::from(_tmp0).wrap());
            _tmp2.push(preserves::value::IOValue::from(_tmp1));
            preserves::value::Value::Sequence(_tmp2).wrap()
        }
    }
}

fn _parse_named_pattern_named(value: &preserves::value::IOValue) -> std::result::Result<NamedPattern, ()> {
    let _tmp0 = Binding::try_from(value)?;
    Ok(NamedPattern::Named(std::boxed::Box::new(_tmp0)))
}

fn _parse_named_pattern_anonymous(value: &preserves::value::IOValue) -> std::result::Result<NamedPattern, ()> {
    let _tmp0 = Pattern::try_from(value)?;
    Ok(NamedPattern::Anonymous(std::boxed::Box::new(_tmp0)))
}

impl std::convert::TryFrom<&preserves::value::IOValue> for NamedPattern {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        if let Ok(r) = _parse_named_pattern_named(value) { return Ok(r); }
        if let Ok(r) = _parse_named_pattern_anonymous(value) { return Ok(r); }
        Err(())
    }
}

impl std::convert::From<&NamedPattern> for preserves::value::IOValue {
    fn from(value: &NamedPattern) -> Self {
        match value {
            NamedPattern::Named(_tmp0) => preserves::value::IOValue::from(_tmp0.as_ref()),
            NamedPattern::Anonymous(_tmp0) => preserves::value::IOValue::from(_tmp0.as_ref()),
        }
    }
}

fn _parse_named_simple_pattern_named(value: &preserves::value::IOValue) -> std::result::Result<NamedSimplePattern, ()> {
    let _tmp0 = Binding::try_from(value)?;
    Ok(NamedSimplePattern::Named(std::boxed::Box::new(_tmp0)))
}

fn _parse_named_simple_pattern_anonymous(value: &preserves::value::IOValue) -> std::result::Result<NamedSimplePattern, ()> {
    let _tmp0 = SimplePattern::try_from(value)?;
    Ok(NamedSimplePattern::Anonymous(std::boxed::Box::new(_tmp0)))
}

impl std::convert::TryFrom<&preserves::value::IOValue> for NamedSimplePattern {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        if let Ok(r) = _parse_named_simple_pattern_named(value) { return Ok(r); }
        if let Ok(r) = _parse_named_simple_pattern_anonymous(value) { return Ok(r); }
        Err(())
    }
}

impl std::convert::From<&NamedSimplePattern> for preserves::value::IOValue {
    fn from(value: &NamedSimplePattern) -> Self {
        match value {
            NamedSimplePattern::Named(_tmp0) => preserves::value::IOValue::from(_tmp0.as_ref()),
            NamedSimplePattern::Anonymous(_tmp0) => preserves::value::IOValue::from(_tmp0.as_ref()),
        }
    }
}

fn _parse_pattern_simple_pattern(value: &preserves::value::IOValue) -> std::result::Result<Pattern, ()> {
    let _tmp0 = SimplePattern::try_from(value)?;
    Ok(Pattern::SimplePattern(std::boxed::Box::new(_tmp0)))
}

fn _parse_pattern_compound_pattern(value: &preserves::value::IOValue) -> std::result::Result<Pattern, ()> {
    let _tmp0 = CompoundPattern::try_from(value)?;
    Ok(Pattern::CompoundPattern(std::boxed::Box::new(_tmp0)))
}

impl std::convert::TryFrom<&preserves::value::IOValue> for Pattern {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        if let Ok(r) = _parse_pattern_simple_pattern(value) { return Ok(r); }
        if let Ok(r) = _parse_pattern_compound_pattern(value) { return Ok(r); }
        Err(())
    }
}

impl std::convert::From<&Pattern> for preserves::value::IOValue {
    fn from(value: &Pattern) -> Self {
        match value {
            Pattern::SimplePattern(_tmp0) => preserves::value::IOValue::from(_tmp0.as_ref()),
            Pattern::CompoundPattern(_tmp0) => preserves::value::IOValue::from(_tmp0.as_ref()),
        }
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for Ref {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
        if _tmp0.label() != &*LIT16 { return Err(()); }
        let _tmp1 = ();
        if _tmp0.fields().len() - 0 < 2 { return Err(()); }
        let _tmp2 = ModulePath::try_from((&_tmp0.fields()[0]))?;
        let _tmp3 = (&_tmp0.fields()[1]).value().to_symbol().map_err(|_| ())?;
        Ok(Ref {module: _tmp2, name: _tmp3.clone()})
    }
}

impl std::convert::From<&Ref> for preserves::value::IOValue {
    fn from(value: &Ref) -> Self {
        let Ref {module: _tmp0, name: _tmp1} = value;
        {
            let mut _tmp2 = preserves::value::Record(vec![(&*LIT16).clone()]);
            _tmp2.fields_vec_mut().push(preserves::value::IOValue::from(_tmp0));
            _tmp2.fields_vec_mut().push(preserves::value::Value::symbol(_tmp1).wrap());
            _tmp2.finish().wrap()
        }
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for Schema {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
        if _tmp0.label() != &*LIT17 { return Err(()); }
        let _tmp1 = ();
        if _tmp0.fields().len() - 0 < 1 { return Err(()); }
        let _tmp2 = (&_tmp0.fields()[0]).value().to_dictionary().map_err(|_| ())?;
        let _tmp3 = _tmp2.get(&*LIT18).ok_or(())?;
        let _tmp4 = Definitions::try_from(_tmp3)?;
        let _tmp5 = _tmp2.get(&*LIT19).ok_or(())?;
        let _tmp6 = EmbeddedTypeName::try_from(_tmp5)?;
        let _tmp7 = _tmp2.get(&*LIT20).ok_or(())?;
        let _tmp8 = Version::try_from(_tmp7)?;
        Ok(Schema {definitions: _tmp4, embedded_type: _tmp6, version: _tmp8})
    }
}

impl std::convert::From<&Schema> for preserves::value::IOValue {
    fn from(value: &Schema) -> Self {
        let Schema {definitions: _tmp0, embedded_type: _tmp1, version: _tmp2} = value;
        {
            let mut _tmp3 = preserves::value::Record(vec![(&*LIT17).clone()]);
            _tmp3.fields_vec_mut().push(
                {
                    let mut _tmp4 = preserves::value::Map::new();
                    _tmp4.insert((&*LIT18).clone(), preserves::value::IOValue::from(_tmp0));
                    _tmp4.insert((&*LIT19).clone(), preserves::value::IOValue::from(_tmp1));
                    _tmp4.insert((&*LIT20).clone(), preserves::value::IOValue::from(_tmp2));
                    preserves::value::Value::Dictionary(_tmp4).wrap()
                }
            );
            _tmp3.finish().wrap()
        }
    }
}

fn _parse_simple_pattern_any(value: &preserves::value::IOValue) -> std::result::Result<SimplePattern, ()> {if value != &*LIT21 { return Err(()); } let _tmp0 = (); Ok(SimplePattern::Any)}

fn _parse_simple_pattern_atom(value: &preserves::value::IOValue) -> std::result::Result<SimplePattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT22 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 1 { return Err(()); }
    let _tmp2 = AtomKind::try_from((&_tmp0.fields()[0]))?;
    Ok(SimplePattern::Atom {atom_kind: std::boxed::Box::new(_tmp2)})
}

fn _parse_simple_pattern_embedded(value: &preserves::value::IOValue) -> std::result::Result<SimplePattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT23 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 1 { return Err(()); }
    let _tmp2 = SimplePattern::try_from((&_tmp0.fields()[0]))?;
    Ok(SimplePattern::Embedded {interface: std::boxed::Box::new(_tmp2)})
}

fn _parse_simple_pattern_lit(value: &preserves::value::IOValue) -> std::result::Result<SimplePattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT24 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 1 { return Err(()); }
    let _tmp2 = (&_tmp0.fields()[0]);
    Ok(SimplePattern::Lit {value: _tmp2.clone()})
}

fn _parse_simple_pattern_seqof(value: &preserves::value::IOValue) -> std::result::Result<SimplePattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT25 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 1 { return Err(()); }
    let _tmp2 = SimplePattern::try_from((&_tmp0.fields()[0]))?;
    Ok(SimplePattern::Seqof {pattern: std::boxed::Box::new(_tmp2)})
}

fn _parse_simple_pattern_setof(value: &preserves::value::IOValue) -> std::result::Result<SimplePattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT26 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 1 { return Err(()); }
    let _tmp2 = SimplePattern::try_from((&_tmp0.fields()[0]))?;
    Ok(SimplePattern::Setof {pattern: std::boxed::Box::new(_tmp2)})
}

fn _parse_simple_pattern_dictof(value: &preserves::value::IOValue) -> std::result::Result<SimplePattern, ()> {
    let _tmp0 = value.value().to_record(None).map_err(|_| ())?;
    if _tmp0.label() != &*LIT27 { return Err(()); }
    let _tmp1 = ();
    if _tmp0.fields().len() - 0 < 2 { return Err(()); }
    let _tmp2 = SimplePattern::try_from((&_tmp0.fields()[0]))?;
    let _tmp3 = SimplePattern::try_from((&_tmp0.fields()[1]))?;
    Ok(SimplePattern::Dictof {key: std::boxed::Box::new(_tmp2), value: std::boxed::Box::new(_tmp3)})
}

fn _parse_simple_pattern_ref(value: &preserves::value::IOValue) -> std::result::Result<SimplePattern, ()> {
    let _tmp0 = Ref::try_from(value)?;
    Ok(SimplePattern::Ref(std::boxed::Box::new(_tmp0)))
}

impl std::convert::TryFrom<&preserves::value::IOValue> for SimplePattern {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {
        if let Ok(r) = _parse_simple_pattern_any(value) { return Ok(r); }
        if let Ok(r) = _parse_simple_pattern_atom(value) { return Ok(r); }
        if let Ok(r) = _parse_simple_pattern_embedded(value) { return Ok(r); }
        if let Ok(r) = _parse_simple_pattern_lit(value) { return Ok(r); }
        if let Ok(r) = _parse_simple_pattern_seqof(value) { return Ok(r); }
        if let Ok(r) = _parse_simple_pattern_setof(value) { return Ok(r); }
        if let Ok(r) = _parse_simple_pattern_dictof(value) { return Ok(r); }
        if let Ok(r) = _parse_simple_pattern_ref(value) { return Ok(r); }
        Err(())
    }
}

impl std::convert::From<&SimplePattern> for preserves::value::IOValue {
    fn from(value: &SimplePattern) -> Self {
        match value {
            SimplePattern::Any => (&*LIT21).clone(),
            SimplePattern::Atom {atom_kind: _tmp0} => {
                let mut _tmp1 = preserves::value::Record(vec![(&*LIT22).clone()]);
                _tmp1.fields_vec_mut().push(preserves::value::IOValue::from(_tmp0.as_ref()));
                _tmp1.finish().wrap()
            },
            SimplePattern::Embedded {interface: _tmp0} => {
                let mut _tmp1 = preserves::value::Record(vec![(&*LIT23).clone()]);
                _tmp1.fields_vec_mut().push(preserves::value::IOValue::from(_tmp0.as_ref()));
                _tmp1.finish().wrap()
            },
            SimplePattern::Lit {value: _tmp0} => {
                let mut _tmp1 = preserves::value::Record(vec![(&*LIT24).clone()]);
                _tmp1.fields_vec_mut().push(_tmp0.clone());
                _tmp1.finish().wrap()
            },
            SimplePattern::Seqof {pattern: _tmp0} => {
                let mut _tmp1 = preserves::value::Record(vec![(&*LIT25).clone()]);
                _tmp1.fields_vec_mut().push(preserves::value::IOValue::from(_tmp0.as_ref()));
                _tmp1.finish().wrap()
            },
            SimplePattern::Setof {pattern: _tmp0} => {
                let mut _tmp1 = preserves::value::Record(vec![(&*LIT26).clone()]);
                _tmp1.fields_vec_mut().push(preserves::value::IOValue::from(_tmp0.as_ref()));
                _tmp1.finish().wrap()
            },
            SimplePattern::Dictof {key: _tmp0, value: _tmp1} => {
                let mut _tmp2 = preserves::value::Record(vec![(&*LIT27).clone()]);
                _tmp2.fields_vec_mut().push(preserves::value::IOValue::from(_tmp0.as_ref()));
                _tmp2.fields_vec_mut().push(preserves::value::IOValue::from(_tmp1.as_ref()));
                _tmp2.finish().wrap()
            },
            SimplePattern::Ref(_tmp0) => preserves::value::IOValue::from(_tmp0.as_ref()),
        }
    }
}

impl std::convert::TryFrom<&preserves::value::IOValue> for Version {
    type Error = ();
    fn try_from(value: &preserves::value::IOValue) -> std::result::Result<Self, Self::Error> {if value != &*LIT28 { return Err(()); } let _tmp0 = (); Ok(Version)}
}

impl std::convert::From<&Version> for preserves::value::IOValue {fn from(value: &Version) -> Self {let Version = value; (&*LIT28).clone()}}

