pub mod syntax;
pub mod compiler;
pub mod metaschema;

#[cfg(test)]
mod tests {
    #[test]
    fn can_access_preserves_core() {
        use preserves::value::*;
        assert_eq!(format!("{:?}", UnwrappedIOValue::from(3 + 4)), "7");
    }

    #[test]
    fn simple_rendering() {
        use crate::*;
        use crate::syntax::block::*;

        let code = semiblock![
            seq!["f", parens!["a", "b", "c"]],
            seq!["f", parens!["a", "b", "c"]],
            seq!["f", parens!["a", "b", "c"]],
            seq!["f", parens!["a", "b", "c"]],
            seq!["f", parens!["a", "b", "c"]],
            seq!["f", parens!["a", "b", "c"]],
            seq!["g", parens![]],
            parens![]
        ];
        println!("{}", Formatter::to_string(&code));
    }

    #[test]
    fn metaschema_parsing() -> Result<(), std::io::Error> {
        use preserves::value::{IOValue, Reader};
        use std::convert::TryFrom;
        use std::convert::From;

        let mut f = std::fs::File::open("../../../schema/schema.bin")?;
        let mut reader = preserves::value::PackedReader::decode_read(&mut f);
        let schema = reader.demand_next(false)?;
        let parsed = crate::metaschema::Schema::try_from(&schema).expect("successful parse");
        assert_eq!(schema, IOValue::from(&parsed));
        Ok(())
    }
}
