use crate::syntax::block::Emittable;
use crate::syntax::block::constructors::*;
use convert_case::{Case, Casing};

pub fn render_ref(pieces: Vec<String>) -> impl Emittable {
    let mut items = Vec::new();
    for p in pieces { items.push(item(p)); }
    name(items)
}

pub fn render_constructor(n: &str) -> String {
    n.to_case(Case::UpperCamel)
}

pub fn render_fieldname(n: &str) -> String {
    n.to_case(Case::Snake)
}
